/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.Serializable;
import org.apache.commons.io.FilenameUtils;

public enum IOCase implements Serializable
{
    SENSITIVE("Sensitive", true),
    INSENSITIVE("Insensitive", false),
    SYSTEM("System", !FilenameUtils.a());

    private final String a;
    private final transient boolean b;

    public static IOCase forName(String string) {
        for (IOCase iOCase : IOCase.values()) {
            if (!iOCase.getName().equals(string)) continue;
            return iOCase;
        }
        throw new IllegalArgumentException("Invalid IOCase name: " + string);
    }

    private IOCase(String string2, boolean bl2) {
        this.a = string2;
        this.b = bl2;
    }

    public final String getName() {
        return this.a;
    }

    public final boolean isCaseSensitive() {
        return this.b;
    }

    public final int checkCompareTo(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("The strings must not be null");
        }
        if (this.b) {
            return string.compareTo(string2);
        }
        return string.compareToIgnoreCase(string2);
    }

    public final boolean checkEquals(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("The strings must not be null");
        }
        if (this.b) {
            return string.equals(string2);
        }
        return string.equalsIgnoreCase(string2);
    }

    public final boolean checkStartsWith(String string, String string2) {
        return string.regionMatches(!this.b, 0, string2, 0, string2.length());
    }

    public final boolean checkEndsWith(String string, String string2) {
        int n2 = string2.length();
        return string.regionMatches(!this.b, string.length() - n2, string2, 0, n2);
    }

    public final int checkIndexOf(String string, int n2, String string2) {
        int n3 = string.length() - string2.length();
        if (n3 >= n2) {
            while (n2 <= n3) {
                if (this.checkRegionMatches(string, n2, string2)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public final boolean checkRegionMatches(String string, int n2, String string2) {
        return string.regionMatches(!this.b, n2, string2, 0, string2.length());
    }

    public final String toString() {
        return this.a;
    }
}

