/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.StringBuilderWriter;

public class IOUtils {
    public static final int EOF = -1;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final String LINE_SEPARATOR;
    private static char[] a;
    private static byte[] b;

    public static void close(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    @Deprecated
    public static void closeQuietly(Reader reader) {
        IOUtils.closeQuietly((Closeable)reader);
    }

    @Deprecated
    public static void closeQuietly(Writer writer) {
        IOUtils.closeQuietly((Closeable)writer);
    }

    @Deprecated
    public static void closeQuietly(InputStream inputStream) {
        IOUtils.closeQuietly((Closeable)inputStream);
    }

    @Deprecated
    public static void closeQuietly(OutputStream outputStream) {
        IOUtils.closeQuietly((Closeable)outputStream);
    }

    @Deprecated
    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    @Deprecated
    public static void closeQuietly(Closeable ... closeableArray) {
        if (closeableArray == null) {
            return;
        }
        for (Closeable closeable : closeableArray) {
            IOUtils.closeQuietly(closeable);
        }
    }

    @Deprecated
    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    @Deprecated
    public static void closeQuietly(Selector selector) {
        if (selector != null) {
            try {
                selector.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    @Deprecated
    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static InputStream toBufferedInputStream(InputStream inputStream) {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream, int n2) {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream, n2);
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    public static BufferedReader toBufferedReader(Reader reader, int n2) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader, n2);
    }

    public static BufferedReader buffer(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    public static BufferedReader buffer(Reader reader, int n2) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader, n2);
    }

    public static BufferedWriter buffer(Writer writer) {
        if (writer instanceof BufferedWriter) {
            return (BufferedWriter)writer;
        }
        return new BufferedWriter(writer);
    }

    public static BufferedWriter buffer(Writer writer, int n2) {
        if (writer instanceof BufferedWriter) {
            return (BufferedWriter)writer;
        }
        return new BufferedWriter(writer, n2);
    }

    public static BufferedOutputStream buffer(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (outputStream instanceof BufferedOutputStream) {
            return (BufferedOutputStream)outputStream;
        }
        return new BufferedOutputStream(outputStream);
    }

    public static BufferedOutputStream buffer(OutputStream outputStream, int n2) {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (outputStream instanceof BufferedOutputStream) {
            return (BufferedOutputStream)outputStream;
        }
        return new BufferedOutputStream(outputStream, n2);
    }

    public static BufferedInputStream buffer(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (inputStream instanceof BufferedInputStream) {
            return (BufferedInputStream)inputStream;
        }
        return new BufferedInputStream(inputStream);
    }

    public static BufferedInputStream buffer(InputStream inputStream, int n2) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (inputStream instanceof BufferedInputStream) {
            return (BufferedInputStream)inputStream;
        }
        return new BufferedInputStream(inputStream, n2);
    }

    public static byte[] toByteArray(InputStream object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            IOUtils.copy((InputStream)object, (OutputStream)byteArrayOutputStream);
            object = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return object;
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (throwable != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    byteArrayOutputStream.close();
                }
                throw throwable3;
            }
        }
    }

    public static byte[] toByteArray(InputStream inputStream, long l2) {
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + l2);
        }
        return IOUtils.toByteArray(inputStream, (int)l2);
    }

    public static byte[] toByteArray(InputStream inputStream, int n2) {
        int n3;
        int n4;
        if (n2 < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + n2);
        }
        if (n2 == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n2];
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n3, n2 - n3)) != -1; n3 += n4) {
        }
        if (n3 != n2) {
            throw new IOException("Unexpected read size. current: " + n3 + ", expected: " + n2);
        }
        return byArray;
    }

    @Deprecated
    public static byte[] toByteArray(Reader reader) {
        return IOUtils.toByteArray(reader, Charset.defaultCharset());
    }

    public static byte[] toByteArray(Reader object, Charset charset) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            IOUtils.copy((Reader)object, (OutputStream)byteArrayOutputStream, charset);
            object = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return object;
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (throwable != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    byteArrayOutputStream.close();
                }
                throw throwable3;
            }
        }
    }

    public static byte[] toByteArray(Reader reader, String string) {
        return IOUtils.toByteArray(reader, Charsets.toCharset(string));
    }

    @Deprecated
    public static byte[] toByteArray(String string) {
        return string.getBytes(Charset.defaultCharset());
    }

    public static byte[] toByteArray(URI uRI) {
        return IOUtils.toByteArray(uRI.toURL());
    }

    public static byte[] toByteArray(URL object) {
        object = ((URL)object).openConnection();
        try {
            byte[] byArray = IOUtils.toByteArray((URLConnection)object);
            return byArray;
        }
        finally {
            IOUtils.close((URLConnection)object);
        }
    }

    public static byte[] toByteArray(URLConnection object) {
        byte[] byArray;
        block9: {
            object = ((URLConnection)object).getInputStream();
            Throwable throwable = null;
            try {
                byArray = IOUtils.toByteArray((InputStream)object);
                if (object == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((InputStream)object).close();
                        }
                    }
                    throw throwable4;
                }
            }
            ((InputStream)object).close();
        }
        return byArray;
    }

    @Deprecated
    public static char[] toCharArray(InputStream inputStream) {
        return IOUtils.toCharArray(inputStream, Charset.defaultCharset());
    }

    public static char[] toCharArray(InputStream inputStream, Charset charset) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, (Writer)charArrayWriter, charset);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String string) {
        return IOUtils.toCharArray(inputStream, Charsets.toCharset(string));
    }

    public static char[] toCharArray(Reader reader) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(reader, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    @Deprecated
    public static String toString(InputStream inputStream) {
        return IOUtils.toString(inputStream, Charset.defaultCharset());
    }

    public static String toString(InputStream object, Charset charset) {
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();
        Throwable throwable = null;
        try {
            IOUtils.copy((InputStream)object, (Writer)stringBuilderWriter, charset);
            object = stringBuilderWriter.toString();
            stringBuilderWriter.close();
            return object;
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (throwable != null) {
                    try {
                        stringBuilderWriter.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    stringBuilderWriter.close();
                }
                throw throwable3;
            }
        }
    }

    public static String toString(InputStream inputStream, String string) {
        return IOUtils.toString(inputStream, Charsets.toCharset(string));
    }

    public static String toString(Reader object) {
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();
        Throwable throwable = null;
        try {
            IOUtils.copy((Reader)object, (Writer)stringBuilderWriter);
            object = stringBuilderWriter.toString();
            stringBuilderWriter.close();
            return object;
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (throwable != null) {
                    try {
                        stringBuilderWriter.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    stringBuilderWriter.close();
                }
                throw throwable3;
            }
        }
    }

    @Deprecated
    public static String toString(URI uRI) {
        return IOUtils.toString(uRI, Charset.defaultCharset());
    }

    public static String toString(URI uRI, Charset charset) {
        return IOUtils.toString(uRI.toURL(), Charsets.toCharset(charset));
    }

    public static String toString(URI uRI, String string) {
        return IOUtils.toString(uRI, Charsets.toCharset(string));
    }

    @Deprecated
    public static String toString(URL uRL) {
        return IOUtils.toString(uRL, Charset.defaultCharset());
    }

    public static String toString(URL object, Charset object2) {
        block9: {
            object = ((URL)object).openStream();
            Throwable throwable = null;
            try {
                object2 = IOUtils.toString((InputStream)object, (Charset)object2);
                if (object == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    object2 = throwable2;
                    throwable = throwable2;
                    throw object2;
                }
                catch (Throwable throwable3) {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ((InputStream)object).close();
                        }
                    }
                    throw throwable3;
                }
            }
            ((InputStream)object).close();
        }
        return object2;
    }

    public static String toString(URL uRL, String string) {
        return IOUtils.toString(uRL, Charsets.toCharset(string));
    }

    @Deprecated
    public static String toString(byte[] byArray) {
        return new String(byArray, Charset.defaultCharset());
    }

    public static String toString(byte[] byArray, String string) {
        return new String(byArray, Charsets.toCharset(string));
    }

    public static String resourceToString(String string, Charset charset) {
        return IOUtils.resourceToString(string, charset, null);
    }

    public static String resourceToString(String string, Charset charset, ClassLoader classLoader) {
        return IOUtils.toString(IOUtils.resourceToURL(string, classLoader), charset);
    }

    public static byte[] resourceToByteArray(String string) {
        return IOUtils.resourceToByteArray(string, null);
    }

    public static byte[] resourceToByteArray(String string, ClassLoader classLoader) {
        return IOUtils.toByteArray(IOUtils.resourceToURL(string, classLoader));
    }

    public static URL resourceToURL(String string) {
        return IOUtils.resourceToURL(string, null);
    }

    public static URL resourceToURL(String string, ClassLoader object) {
        if ((object = object == null ? IOUtils.class.getResource(string) : ((ClassLoader)object).getResource(string)) == null) {
            throw new IOException("Resource not found: " + string);
        }
        return object;
    }

    @Deprecated
    public static List<String> readLines(InputStream inputStream) {
        return IOUtils.readLines(inputStream, Charset.defaultCharset());
    }

    public static List<String> readLines(InputStream closeable, Charset charset) {
        closeable = new InputStreamReader((InputStream)closeable, Charsets.toCharset(charset));
        return IOUtils.readLines((Reader)closeable);
    }

    public static List<String> readLines(InputStream inputStream, String string) {
        return IOUtils.readLines(inputStream, Charsets.toCharset(string));
    }

    public static List<String> readLines(Reader reader) {
        reader = IOUtils.toBufferedReader(reader);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = ((BufferedReader)reader).readLine();
        while (string != null) {
            arrayList.add(string);
            string = ((BufferedReader)reader).readLine();
        }
        return arrayList;
    }

    public static LineIterator lineIterator(Reader reader) {
        return new LineIterator(reader);
    }

    public static LineIterator lineIterator(InputStream inputStream, Charset charset) {
        return new LineIterator(new InputStreamReader(inputStream, Charsets.toCharset(charset)));
    }

    public static LineIterator lineIterator(InputStream inputStream, String string) {
        return IOUtils.lineIterator(inputStream, Charsets.toCharset(string));
    }

    @Deprecated
    public static InputStream toInputStream(CharSequence charSequence) {
        return IOUtils.toInputStream(charSequence, Charset.defaultCharset());
    }

    public static InputStream toInputStream(CharSequence charSequence, Charset charset) {
        return IOUtils.toInputStream(charSequence.toString(), charset);
    }

    public static InputStream toInputStream(CharSequence charSequence, String string) {
        return IOUtils.toInputStream(charSequence, Charsets.toCharset(string));
    }

    @Deprecated
    public static InputStream toInputStream(String string) {
        return IOUtils.toInputStream(string, Charset.defaultCharset());
    }

    public static InputStream toInputStream(String string, Charset charset) {
        return new ByteArrayInputStream(string.getBytes(Charsets.toCharset(charset)));
    }

    public static InputStream toInputStream(String object, String string) {
        object = ((String)object).getBytes(Charsets.toCharset(string));
        return new ByteArrayInputStream((byte[])object);
    }

    public static void write(byte[] byArray, OutputStream outputStream) {
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    public static void writeChunked(byte[] byArray, OutputStream outputStream) {
        if (byArray != null) {
            int n2 = byArray.length;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = Math.min(n2, 4096);
                outputStream.write(byArray, n3, n4);
                n2 -= n4;
                n3 += n4;
            }
        }
    }

    @Deprecated
    public static void write(byte[] byArray, Writer writer) {
        IOUtils.write(byArray, writer, Charset.defaultCharset());
    }

    public static void write(byte[] byArray, Writer writer, Charset charset) {
        if (byArray != null) {
            writer.write(new String(byArray, Charsets.toCharset(charset)));
        }
    }

    public static void write(byte[] byArray, Writer writer, String string) {
        IOUtils.write(byArray, writer, Charsets.toCharset(string));
    }

    public static void write(char[] cArray, Writer writer) {
        if (cArray != null) {
            writer.write(cArray);
        }
    }

    public static void writeChunked(char[] cArray, Writer writer) {
        if (cArray != null) {
            int n2 = cArray.length;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = Math.min(n2, 4096);
                writer.write(cArray, n3, n4);
                n2 -= n4;
                n3 += n4;
            }
        }
    }

    @Deprecated
    public static void write(char[] cArray, OutputStream outputStream) {
        IOUtils.write(cArray, outputStream, Charset.defaultCharset());
    }

    public static void write(char[] cArray, OutputStream outputStream, Charset charset) {
        if (cArray != null) {
            outputStream.write(new String(cArray).getBytes(Charsets.toCharset(charset)));
        }
    }

    public static void write(char[] cArray, OutputStream outputStream, String string) {
        IOUtils.write(cArray, outputStream, Charsets.toCharset(string));
    }

    public static void write(CharSequence charSequence, Writer writer) {
        if (charSequence != null) {
            IOUtils.write(charSequence.toString(), writer);
        }
    }

    @Deprecated
    public static void write(CharSequence charSequence, OutputStream outputStream) {
        IOUtils.write(charSequence, outputStream, Charset.defaultCharset());
    }

    public static void write(CharSequence charSequence, OutputStream outputStream, Charset charset) {
        if (charSequence != null) {
            IOUtils.write(charSequence.toString(), outputStream, charset);
        }
    }

    public static void write(CharSequence charSequence, OutputStream outputStream, String string) {
        IOUtils.write(charSequence, outputStream, Charsets.toCharset(string));
    }

    public static void write(String string, Writer writer) {
        if (string != null) {
            writer.write(string);
        }
    }

    @Deprecated
    public static void write(String string, OutputStream outputStream) {
        IOUtils.write(string, outputStream, Charset.defaultCharset());
    }

    public static void write(String string, OutputStream outputStream, Charset charset) {
        if (string != null) {
            outputStream.write(string.getBytes(Charsets.toCharset(charset)));
        }
    }

    public static void write(String string, OutputStream outputStream, String string2) {
        IOUtils.write(string, outputStream, Charsets.toCharset(string2));
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, Writer writer) {
        if (stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, OutputStream outputStream) {
        IOUtils.write(stringBuffer, outputStream, null);
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, OutputStream outputStream, String string) {
        if (stringBuffer != null) {
            outputStream.write(stringBuffer.toString().getBytes(Charsets.toCharset(string)));
        }
    }

    @Deprecated
    public static void writeLines(Collection<?> collection, String string, OutputStream outputStream) {
        IOUtils.writeLines(collection, string, outputStream, Charset.defaultCharset());
    }

    public static void writeLines(Collection<?> object, String string, OutputStream outputStream, Charset charset) {
        if (object == null) {
            return;
        }
        if (string == null) {
            string = LINE_SEPARATOR;
        }
        charset = Charsets.toCharset(charset);
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (e2 != null) {
                outputStream.write(e2.toString().getBytes(charset));
            }
            outputStream.write(string.getBytes(charset));
        }
    }

    public static void writeLines(Collection<?> collection, String string, OutputStream outputStream, String string2) {
        IOUtils.writeLines(collection, string, outputStream, Charsets.toCharset(string2));
    }

    public static void writeLines(Collection<?> object, String string, Writer writer) {
        if (object == null) {
            return;
        }
        if (string == null) {
            string = LINE_SEPARATOR;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (e2 != null) {
                writer.write(e2.toString());
            }
            writer.write(string);
        }
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) {
        long l2 = IOUtils.copyLarge(inputStream, outputStream);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int n2) {
        return IOUtils.copyLarge(inputStream, outputStream, new byte[n2]);
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) {
        return IOUtils.copy(inputStream, outputStream, 4096);
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        int n2;
        long l2 = 0L;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3) {
        return IOUtils.copyLarge(inputStream, outputStream, l2, l3, new byte[4096]);
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3, byte[] byArray) {
        int n2;
        int n3;
        if (l2 > 0L) {
            IOUtils.skipFully(inputStream, l2);
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n4 = n3 = byArray.length;
        if (l3 > 0L && l3 < (long)n3) {
            n4 = (int)l3;
        }
        long l4 = 0L;
        while (n4 > 0 && -1 != (n2 = inputStream.read(byArray, 0, n4))) {
            outputStream.write(byArray, 0, n2);
            l4 += (long)n2;
            if (l3 <= 0L) continue;
            n4 = (int)Math.min(l3 - l4, (long)n3);
        }
        return l4;
    }

    @Deprecated
    public static void copy(InputStream inputStream, Writer writer) {
        IOUtils.copy(inputStream, writer, Charset.defaultCharset());
    }

    public static void copy(InputStream closeable, Writer writer, Charset charset) {
        closeable = new InputStreamReader((InputStream)closeable, Charsets.toCharset(charset));
        IOUtils.copy((Reader)closeable, writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string) {
        IOUtils.copy(inputStream, writer, Charsets.toCharset(string));
    }

    public static int copy(Reader reader, Writer writer) {
        long l2 = IOUtils.copyLarge(reader, writer);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static long copyLarge(Reader reader, Writer writer) {
        return IOUtils.copyLarge(reader, writer, new char[4096]);
    }

    public static long copyLarge(Reader reader, Writer writer, char[] cArray) {
        int n2;
        long l2 = 0L;
        while (-1 != (n2 = reader.read(cArray))) {
            writer.write(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copyLarge(Reader reader, Writer writer, long l2, long l3) {
        return IOUtils.copyLarge(reader, writer, l2, l3, new char[4096]);
    }

    public static long copyLarge(Reader reader, Writer writer, long l2, long l3, char[] cArray) {
        int n2;
        if (l2 > 0L) {
            IOUtils.skipFully(reader, l2);
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n3 = cArray.length;
        if (l3 > 0L && l3 < (long)cArray.length) {
            n3 = (int)l3;
        }
        long l4 = 0L;
        while (n3 > 0 && -1 != (n2 = reader.read(cArray, 0, n3))) {
            writer.write(cArray, 0, n2);
            l4 += (long)n2;
            if (l3 <= 0L) continue;
            n3 = (int)Math.min(l3 - l4, (long)cArray.length);
        }
        return l4;
    }

    @Deprecated
    public static void copy(Reader reader, OutputStream outputStream) {
        IOUtils.copy(reader, outputStream, Charset.defaultCharset());
    }

    public static void copy(Reader reader, OutputStream closeable, Charset charset) {
        closeable = new OutputStreamWriter((OutputStream)closeable, Charsets.toCharset(charset));
        IOUtils.copy(reader, (Writer)closeable);
        ((OutputStreamWriter)closeable).flush();
    }

    public static void copy(Reader reader, OutputStream outputStream, String string) {
        IOUtils.copy(reader, outputStream, Charsets.toCharset(string));
    }

    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) {
        int n2;
        if (inputStream == inputStream2) {
            return true;
        }
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        int n3 = inputStream.read();
        while (-1 != n3) {
            n2 = inputStream2.read();
            if (n3 != n2) {
                return false;
            }
            n3 = inputStream.read();
        }
        n2 = inputStream2.read();
        return n2 == -1;
    }

    public static boolean contentEquals(Reader reader, Reader reader2) {
        int n2;
        if (reader == reader2) {
            return true;
        }
        reader = IOUtils.toBufferedReader(reader);
        reader2 = IOUtils.toBufferedReader(reader2);
        int n3 = reader.read();
        while (-1 != n3) {
            n2 = reader2.read();
            if (n3 != n2) {
                return false;
            }
            n3 = reader.read();
        }
        n2 = reader2.read();
        return n2 == -1;
    }

    public static boolean contentEqualsIgnoreEOL(Reader reader, Reader reader2) {
        if (reader == reader2) {
            return true;
        }
        reader = IOUtils.toBufferedReader(reader);
        reader2 = IOUtils.toBufferedReader(reader2);
        String string = ((BufferedReader)reader).readLine();
        String string2 = ((BufferedReader)reader2).readLine();
        while (string != null && string2 != null && string.equals(string2)) {
            string = ((BufferedReader)reader).readLine();
            string2 = ((BufferedReader)reader2).readLine();
        }
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static long skip(InputStream inputStream, long l2) {
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        if (b == null) {
            b = new byte[2048];
        }
        for (l3 = l2; l3 > 0L && (l4 = (long)inputStream.read(b, 0, (int)Math.min(l3, 2048L))) >= 0L; l3 -= l4) {
        }
        return l2 - l3;
    }

    public static long skip(ReadableByteChannel readableByteChannel, long l2) {
        long l3;
        int n2;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)Math.min(l2, 2048L));
        for (l3 = l2; l3 > 0L; l3 -= (long)n2) {
            byteBuffer.position(0);
            byteBuffer.limit((int)Math.min(l3, 2048L));
            n2 = readableByteChannel.read(byteBuffer);
            if (n2 == -1) break;
        }
        return l2 - l3;
    }

    public static long skip(Reader reader, long l2) {
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        if (a == null) {
            a = new char[2048];
        }
        for (l3 = l2; l3 > 0L && (l4 = (long)reader.read(a, 0, (int)Math.min(l3, 2048L))) >= 0L; l3 -= l4) {
        }
        return l2 - l3;
    }

    public static void skipFully(InputStream inputStream, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + l2);
        }
        long l3 = IOUtils.skip(inputStream, l2);
        if (l3 != l2) {
            throw new EOFException("Bytes to skip: " + l2 + " actual: " + l3);
        }
    }

    public static void skipFully(ReadableByteChannel readableByteChannel, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + l2);
        }
        long l3 = IOUtils.skip(readableByteChannel, l2);
        if (l3 != l2) {
            throw new EOFException("Bytes to skip: " + l2 + " actual: " + l3);
        }
    }

    public static void skipFully(Reader reader, long l2) {
        long l3 = IOUtils.skip(reader, l2);
        if (l3 != l2) {
            throw new EOFException("Chars to skip: " + l2 + " actual: " + l3);
        }
    }

    public static int read(Reader reader, char[] cArray, int n2, int n3) {
        int n4;
        int n5;
        if (n3 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n3);
        }
        for (n4 = n3; n4 > 0; n4 -= n5) {
            n5 = n3 - n4;
            if (-1 == (n5 = reader.read(cArray, n2 + n5, n4))) break;
        }
        return n3 - n4;
    }

    public static int read(Reader reader, char[] cArray) {
        return IOUtils.read(reader, cArray, 0, cArray.length);
    }

    public static int read(InputStream inputStream, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        if (n3 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n3);
        }
        for (n4 = n3; n4 > 0; n4 -= n5) {
            n5 = n3 - n4;
            if (-1 == (n5 = inputStream.read(byArray, n2 + n5, n4))) break;
        }
        return n3 - n4;
    }

    public static int read(InputStream inputStream, byte[] byArray) {
        return IOUtils.read(inputStream, byArray, 0, byArray.length);
    }

    public static int read(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) {
        int n2;
        int n3 = byteBuffer.remaining();
        while (byteBuffer.remaining() > 0 && -1 != (n2 = readableByteChannel.read(byteBuffer))) {
        }
        return n3 - byteBuffer.remaining();
    }

    public static void readFully(Reader reader, char[] cArray, int n2, int n3) {
        int n4 = IOUtils.read(reader, cArray, n2, n3);
        if (n4 != n3) {
            throw new EOFException("Length to read: " + n3 + " actual: " + n4);
        }
    }

    public static void readFully(Reader reader, char[] cArray) {
        IOUtils.readFully(reader, cArray, 0, cArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n2, int n3) {
        int n4 = IOUtils.read(inputStream, byArray, n2, n3);
        if (n4 != n3) {
            throw new EOFException("Length to read: " + n3 + " actual: " + n4);
        }
    }

    public static void readFully(InputStream inputStream, byte[] byArray) {
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static byte[] readFully(InputStream inputStream, int n2) {
        byte[] byArray = new byte[n2];
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
        return byArray;
    }

    public static void readFully(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        int n3 = IOUtils.read(readableByteChannel, byteBuffer);
        if (n3 != n2) {
            throw new EOFException("Length to read: " + n2 + " actual: " + n3);
        }
    }

    static {
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter(4);
        Throwable throwable = null;
        try {
            PrintWriter printWriter = new PrintWriter(stringBuilderWriter);
            Throwable throwable2 = null;
            try {
                printWriter.println();
                LINE_SEPARATOR = stringBuilderWriter.toString();
                printWriter.close();
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable4 = throwable3;
                    throwable2 = throwable3;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (throwable2 != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        printWriter.close();
                    }
                    throw throwable5;
                }
            }
            stringBuilderWriter.close();
            return;
        }
        catch (Throwable throwable7) {
            try {
                Throwable throwable8 = throwable7;
                throwable = throwable7;
                throw throwable8;
            }
            catch (Throwable throwable9) {
                if (throwable != null) {
                    try {
                        stringBuilderWriter.close();
                    }
                    catch (Throwable throwable10) {
                        throwable.addSuppressed(throwable10);
                    }
                } else {
                    stringBuilderWriter.close();
                }
                throw throwable9;
            }
        }
    }
}

