/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LineIterator
implements Closeable,
Iterator<String> {
    private final BufferedReader a;
    private String b;
    private boolean c = false;

    public LineIterator(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Reader must not be null");
        }
        if (reader instanceof BufferedReader) {
            this.a = (BufferedReader)reader;
            return;
        }
        this.a = new BufferedReader(reader);
    }

    @Override
    public boolean hasNext() {
        if (this.b != null) {
            return true;
        }
        if (this.c) {
            return false;
        }
        try {
            String string;
            do {
                if ((string = this.a.readLine()) != null) continue;
                this.c = true;
                return false;
            } while (!this.isValidLine(string));
            this.b = string;
            return true;
        }
        catch (IOException iOException) {
            try {
                this.close();
            }
            catch (IOException iOException2) {
                iOException.addSuppressed(iOException2);
            }
            throw new IllegalStateException(iOException);
        }
    }

    protected boolean isValidLine(String string) {
        return true;
    }

    @Override
    public String next() {
        return this.nextLine();
    }

    public String nextLine() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more lines");
        }
        String string = this.b;
        this.b = null;
        return string;
    }

    @Override
    public void close() {
        this.c = true;
        this.b = null;
        if (this.a != null) {
            this.a.close();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove unsupported on LineIterator");
    }

    @Deprecated
    public static void closeQuietly(LineIterator lineIterator) {
        try {
            if (lineIterator != null) {
                lineIterator.close();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

