/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.ConditionalFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;

public class AndFileFilter
extends AbstractFileFilter
implements Serializable,
ConditionalFileFilter {
    private final List<IOFileFilter> a;

    public AndFileFilter() {
        this.a = new ArrayList<IOFileFilter>();
    }

    public AndFileFilter(List<IOFileFilter> list) {
        if (list == null) {
            this.a = new ArrayList<IOFileFilter>();
            return;
        }
        this.a = new ArrayList<IOFileFilter>(list);
    }

    public AndFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        if (iOFileFilter == null || iOFileFilter2 == null) {
            throw new IllegalArgumentException("The filters must not be null");
        }
        this.a = new ArrayList<IOFileFilter>(2);
        this.addFileFilter(iOFileFilter);
        this.addFileFilter(iOFileFilter2);
    }

    @Override
    public void addFileFilter(IOFileFilter iOFileFilter) {
        this.a.add(iOFileFilter);
    }

    @Override
    public List<IOFileFilter> getFileFilters() {
        return Collections.unmodifiableList(this.a);
    }

    @Override
    public boolean removeFileFilter(IOFileFilter iOFileFilter) {
        return this.a.remove(iOFileFilter);
    }

    @Override
    public void setFileFilters(List<IOFileFilter> list) {
        this.a.clear();
        this.a.addAll(list);
    }

    @Override
    public boolean accept(File file) {
        if (this.a.isEmpty()) {
            return false;
        }
        for (IOFileFilter iOFileFilter : this.a) {
            if (iOFileFilter.accept(file)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(File file, String string) {
        if (this.a.isEmpty()) {
            return false;
        }
        for (IOFileFilter iOFileFilter : this.a) {
            if (iOFileFilter.accept(file, string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        if (this.a != null) {
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                IOFileFilter iOFileFilter;
                if (i2 > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append((iOFileFilter = this.a.get(i2)) == null ? "null" : iOFileFilter.toString());
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

