/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class MagicNumberFileFilter
extends AbstractFileFilter
implements Serializable {
    private final byte[] a;
    private final long b;

    public MagicNumberFileFilter(byte[] byArray) {
        this(byArray, 0L);
    }

    public MagicNumberFileFilter(String string) {
        this(string, 0L);
    }

    public MagicNumberFileFilter(String string, long l2) {
        if (string == null) {
            throw new IllegalArgumentException("The magic number cannot be null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("The magic number must contain at least one byte");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("The offset cannot be negative");
        }
        this.a = string.getBytes(Charset.defaultCharset());
        this.b = l2;
    }

    public MagicNumberFileFilter(byte[] byArray, long l2) {
        if (byArray == null) {
            throw new IllegalArgumentException("The magic number cannot be null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("The magic number must contain at least one byte");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("The offset cannot be negative");
        }
        this.a = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.a, 0, byArray.length);
        this.b = l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean accept(File object) {
        if (object == null) return false;
        if (!((File)object).isFile()) return false;
        if (!((File)object).canRead()) return false;
        try {
            boolean bl2;
            Object object2;
            Throwable throwable;
            block10: {
                object = new RandomAccessFile((File)object, "r");
                throwable = null;
                object2 = new byte[this.a.length];
                ((RandomAccessFile)object).seek(this.b);
                int n2 = ((RandomAccessFile)object).read((byte[])object2);
                if (n2 == this.a.length) break block10;
                ((RandomAccessFile)object).close();
                return false;
            }
            try {
                bl2 = Arrays.equals(this.a, (byte[])object2);
            }
            catch (Throwable throwable2) {
                try {
                    object2 = throwable2;
                    throwable = throwable2;
                    throw object2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        ((RandomAccessFile)object).close();
                        throw throwable3;
                    }
                    try {
                        ((RandomAccessFile)object).close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                        throw throwable3;
                    }
                }
            }
            ((RandomAccessFile)object).close();
            return bl2;
        }
        catch (IOException iOException) {}
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("(");
        stringBuilder.append(new String(this.a, Charset.defaultCharset()));
        stringBuilder.append(",");
        stringBuilder.append(this.b);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

