/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.ProxyInputStream;

public class BOMInputStream
extends ProxyInputStream {
    private final boolean a;
    private final List<ByteOrderMark> b;
    private ByteOrderMark c;
    private int[] d;
    private int e;
    private int f;
    private int g;
    private boolean h;
    private static final Comparator<ByteOrderMark> i = new Comparator<ByteOrderMark>(){

        @Override
        public final /* synthetic */ int compare(Object object, Object object2) {
            int n2;
            object2 = (ByteOrderMark)object2;
            int n3 = ((ByteOrderMark)(object = (ByteOrderMark)object)).length();
            if (n3 > (n2 = ((ByteOrderMark)object2).length())) {
                return -1;
            }
            if (n2 > n3) {
                return 1;
            }
            return 0;
        }
    };

    public BOMInputStream(InputStream inputStream) {
        this(inputStream, false, ByteOrderMark.UTF_8);
    }

    public BOMInputStream(InputStream inputStream, boolean bl2) {
        this(inputStream, bl2, ByteOrderMark.UTF_8);
    }

    public BOMInputStream(InputStream inputStream, ByteOrderMark ... byteOrderMarkArray) {
        this(inputStream, false, byteOrderMarkArray);
    }

    public BOMInputStream(InputStream object, boolean bl2, ByteOrderMark ... byteOrderMarkArray) {
        super((InputStream)object);
        if (byteOrderMarkArray == null || byteOrderMarkArray.length == 0) {
            throw new IllegalArgumentException("No BOMs specified");
        }
        this.a = bl2;
        object = Arrays.asList(byteOrderMarkArray);
        Collections.sort(object, i);
        this.b = object;
    }

    public boolean hasBOM() {
        return this.getBOM() != null;
    }

    public boolean hasBOM(ByteOrderMark byteOrderMark) {
        if (!this.b.contains(byteOrderMark)) {
            throw new IllegalArgumentException("Stream not configure to detect " + byteOrderMark);
        }
        this.getBOM();
        return this.c != null && this.c.equals(byteOrderMark);
    }

    public ByteOrderMark getBOM() {
        if (this.d == null) {
            block8: {
                ByteOrderMark byteOrderMark;
                this.e = 0;
                int n2 = this.b.get(0).length();
                this.d = new int[n2];
                for (n2 = 0; n2 < this.d.length; ++n2) {
                    this.d[n2] = this.in.read();
                    ++this.e;
                    if (this.d[n2] < 0) break;
                }
                BOMInputStream bOMInputStream = this;
                Iterator<ByteOrderMark> iterator = bOMInputStream.b.iterator();
                while (iterator.hasNext()) {
                    boolean bl2;
                    ByteOrderMark byteOrderMark2;
                    block7: {
                        ByteOrderMark byteOrderMark3 = byteOrderMark2 = iterator.next();
                        BOMInputStream bOMInputStream2 = bOMInputStream;
                        for (int i2 = 0; i2 < byteOrderMark3.length(); ++i2) {
                            if (byteOrderMark3.get(i2) == bOMInputStream2.d[i2]) continue;
                            bl2 = false;
                            break block7;
                        }
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    byteOrderMark = byteOrderMark2;
                    break block8;
                }
                byteOrderMark = bOMInputStream.c = null;
            }
            if (this.c != null && !this.a) {
                if (this.c.length() < this.d.length) {
                    this.f = this.c.length();
                } else {
                    this.e = 0;
                }
            }
        }
        return this.c;
    }

    public String getBOMCharsetName() {
        this.getBOM();
        if (this.c == null) {
            return null;
        }
        return this.c.getCharsetName();
    }

    private int a() {
        this.getBOM();
        if (this.f < this.e) {
            return this.d[this.f++];
        }
        return -1;
    }

    @Override
    public int read() {
        int n2 = this.a();
        if (n2 >= 0) {
            return n2;
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n3 > 0 && n5 >= 0) {
            n5 = this.a();
            if (n5 < 0) continue;
            byArray[n2++] = (byte)n5;
            --n3;
            ++n4;
        }
        int n6 = this.in.read(byArray, n2, n3);
        if (n6 < 0) {
            if (n4 > 0) {
                return n4;
            }
            return -1;
        }
        return n4 + n6;
    }

    @Override
    public int read(byte[] byArray) {
        return ((ProxyInputStream)this).read(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void mark(int n2) {
        this.g = this.f;
        this.h = this.d == null;
        this.in.mark(n2);
    }

    @Override
    public synchronized void reset() {
        this.f = this.g;
        if (this.h) {
            this.d = null;
        }
        this.in.reset();
    }

    @Override
    public long skip(long l2) {
        int n2 = 0;
        while (l2 > (long)n2 && this.a() >= 0) {
            ++n2;
        }
        return this.in.skip(l2 - (long)n2) + (long)n2;
    }
}

