/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class CharSequenceInputStream
extends InputStream {
    private final CharsetEncoder a;
    private final CharBuffer b;
    private final ByteBuffer c;
    private int d;
    private int e;

    public CharSequenceInputStream(CharSequence charSequence, Charset charset, int n2) {
        this.a = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        float f2 = this.a.maxBytesPerChar();
        if ((float)n2 < f2) {
            throw new IllegalArgumentException("Buffer size " + n2 + " is less than maxBytesPerChar " + f2);
        }
        this.c = ByteBuffer.allocate(n2);
        this.c.flip();
        this.b = CharBuffer.wrap(charSequence);
        this.d = -1;
        this.e = -1;
    }

    public CharSequenceInputStream(CharSequence charSequence, String string, int n2) {
        this(charSequence, Charset.forName(string), n2);
    }

    public CharSequenceInputStream(CharSequence charSequence, Charset charset) {
        this(charSequence, charset, 2048);
    }

    public CharSequenceInputStream(CharSequence charSequence, String string) {
        this(charSequence, string, 2048);
    }

    private void a() {
        this.c.compact();
        CoderResult coderResult = this.a.encode(this.b, this.c, true);
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        this.c.flip();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("Array Size=" + byArray.length + ", offset=" + n2 + ", length=" + n3);
        }
        if (n3 == 0) {
            return 0;
        }
        if (!this.c.hasRemaining() && !this.b.hasRemaining()) {
            return -1;
        }
        int n4 = 0;
        while (n3 > 0) {
            if (this.c.hasRemaining()) {
                int n5 = Math.min(this.c.remaining(), n3);
                this.c.get(byArray, n2, n5);
                n2 += n5;
                n3 -= n5;
                n4 += n5;
                continue;
            }
            this.a();
            if (this.c.hasRemaining() || this.b.hasRemaining()) continue;
        }
        if (n4 == 0 && !this.b.hasRemaining()) {
            return -1;
        }
        return n4;
    }

    @Override
    public int read() {
        do {
            if (this.c.hasRemaining()) {
                return this.c.get() & 0xFF;
            }
            this.a();
        } while (this.c.hasRemaining() || this.b.hasRemaining());
        return -1;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public long skip(long l2) {
        long l3 = 0L;
        while (l2 > 0L && this.available() > 0) {
            this.read();
            --l2;
            ++l3;
        }
        return l3;
    }

    @Override
    public int available() {
        return this.c.remaining() + this.b.remaining();
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized void mark(int n2) {
        this.d = this.b.position();
        this.e = this.c.position();
        this.b.mark();
        this.c.mark();
    }

    @Override
    public synchronized void reset() {
        if (this.d != -1) {
            if (this.b.position() != 0) {
                this.a.reset();
                this.b.rewind();
                this.c.rewind();
                this.c.limit(0);
                while (this.b.position() < this.d) {
                    this.c.rewind();
                    this.c.limit(0);
                    this.a();
                }
            }
            if (this.b.position() != this.d) {
                throw new IllegalStateException("Unexpected CharBuffer postion: actual=" + this.b.position() + " expected=" + this.d);
            }
            this.c.position(this.e);
            this.d = -1;
            this.e = -1;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

