/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.input.ProxyInputStream;

public class ObservableInputStream
extends ProxyInputStream {
    private final List<Observer> a = new ArrayList<Observer>();

    public ObservableInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public void add(Observer observer) {
        this.a.add(observer);
    }

    public void remove(Observer observer) {
        this.a.remove(observer);
    }

    public void removeAllObservers() {
        this.a.clear();
    }

    @Override
    public int read() {
        int n2 = 0;
        IOException iOException = null;
        try {
            n2 = super.read();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            iOException = iOException2;
        }
        if (iOException != null) {
            this.noteError(iOException);
        } else if (n2 == -1) {
            this.noteFinished();
        } else {
            this.noteDataByte(n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray) {
        int n2 = 0;
        IOException iOException = null;
        try {
            n2 = super.read(byArray);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            iOException = iOException2;
        }
        if (iOException != null) {
            this.noteError(iOException);
        } else if (n2 == -1) {
            this.noteFinished();
        } else if (n2 > 0) {
            this.noteDataBytes(byArray, 0, n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        IOException iOException = null;
        try {
            n4 = super.read(byArray, n2, n3);
        }
        catch (IOException iOException2) {
            IOException iOException3 = iOException2;
            iOException = iOException2;
        }
        if (iOException != null) {
            this.noteError(iOException);
        } else if (n4 == -1) {
            this.noteFinished();
        } else if (n4 > 0) {
            this.noteDataBytes(byArray, n2, n4);
        }
        return n4;
    }

    protected void noteDataBytes(byte[] byArray, int n2, int n3) {
        for (Observer observer : this.getObservers()) {
            observer.a(byArray, n2, n3);
        }
    }

    protected void noteFinished() {
        Iterator<Observer> iterator = this.getObservers().iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    protected void noteDataByte(int n2) {
        for (Observer observer : this.getObservers()) {
            observer.a(n2);
        }
    }

    protected void noteError(IOException iOException) {
        Iterator<Observer> iterator = this.getObservers().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            Observer.a(iOException);
        }
    }

    protected void noteClosed() {
        Iterator<Observer> iterator = this.getObservers().iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    protected List<Observer> getObservers() {
        return this.a;
    }

    @Override
    public void close() {
        IOException iOException = null;
        try {
            super.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            iOException = iOException2;
        }
        if (iOException == null) {
            this.noteClosed();
            return;
        }
        this.noteError(iOException);
    }

    public void consume() {
        int n2;
        byte[] byArray = new byte[8192];
        while ((n2 = ((ProxyInputStream)this).read(byArray)) != -1) {
        }
    }

    public static abstract class Observer {
        void a(int n2) {
        }

        void a(byte[] byArray, int n2, int n3) {
        }

        static void a(IOException iOException) {
            throw iOException;
        }
    }
}

