/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public abstract class ProxyReader
extends FilterReader {
    public ProxyReader(Reader reader) {
        super(reader);
    }

    @Override
    public int read() {
        try {
            this.beforeRead(1);
            int n2 = this.in.read();
            this.afterRead(n2 != -1 ? 1 : -1);
            return n2;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public int read(char[] cArray) {
        try {
            this.beforeRead(cArray != null ? cArray.length : 0);
            int n2 = this.in.read(cArray);
            this.afterRead(n2);
            return n2;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        try {
            this.beforeRead(n3);
            int n4 = this.in.read(cArray, n2, n3);
            this.afterRead(n4);
            return n4;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public int read(CharBuffer charBuffer) {
        try {
            this.beforeRead(charBuffer != null ? charBuffer.length() : 0);
            int n2 = this.in.read(charBuffer);
            this.afterRead(n2);
            return n2;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public long skip(long l2) {
        try {
            return this.in.skip(l2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return 0L;
        }
    }

    @Override
    public boolean ready() {
        try {
            return this.in.ready();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.in.close();
            return;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return;
        }
    }

    @Override
    public synchronized void mark(int n2) {
        try {
            this.in.mark(n2);
            return;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return;
        }
    }

    @Override
    public synchronized void reset() {
        try {
            this.in.reset();
            return;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return;
        }
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    protected void beforeRead(int n2) {
    }

    protected void afterRead(int n2) {
    }

    protected void handleIOException(IOException iOException) {
        throw iOException;
    }
}

