/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class ReaderInputStream
extends InputStream {
    private final Reader a;
    private final CharsetEncoder b;
    private final CharBuffer c;
    private final ByteBuffer d;
    private CoderResult e;
    private boolean f;

    public ReaderInputStream(Reader reader, CharsetEncoder charsetEncoder) {
        this(reader, charsetEncoder, 1024);
    }

    public ReaderInputStream(Reader reader, CharsetEncoder charsetEncoder, int n2) {
        this.a = reader;
        this.b = charsetEncoder;
        this.c = CharBuffer.allocate(n2);
        this.c.flip();
        this.d = ByteBuffer.allocate(128);
        this.d.flip();
    }

    public ReaderInputStream(Reader reader, Charset charset, int n2) {
        this(reader, charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), n2);
    }

    public ReaderInputStream(Reader reader, Charset charset) {
        this(reader, charset, 1024);
    }

    public ReaderInputStream(Reader reader, String string, int n2) {
        this(reader, Charset.forName(string), n2);
    }

    public ReaderInputStream(Reader reader, String string) {
        this(reader, string, 1024);
    }

    @Deprecated
    public ReaderInputStream(Reader reader) {
        this(reader, Charset.defaultCharset());
    }

    private void a() {
        if (!this.f && (this.e == null || this.e.isUnderflow())) {
            this.c.compact();
            int n2 = this.c.position();
            int n3 = this.a.read(this.c.array(), n2, this.c.remaining());
            if (n3 == -1) {
                this.f = true;
            } else {
                this.c.position(n2 + n3);
            }
            this.c.flip();
        }
        this.d.compact();
        this.e = this.b.encode(this.c, this.d, this.f);
        this.d.flip();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException("Byte array must not be null");
        }
        if (n3 < 0 || n2 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("Array Size=" + byArray.length + ", offset=" + n2 + ", length=" + n3);
        }
        int n4 = 0;
        if (n3 == 0) {
            return 0;
        }
        while (n3 > 0) {
            if (this.d.hasRemaining()) {
                int n5 = Math.min(this.d.remaining(), n3);
                this.d.get(byArray, n2, n5);
                n2 += n5;
                n3 -= n5;
                n4 += n5;
                continue;
            }
            this.a();
            if (!this.f || this.d.hasRemaining()) continue;
        }
        if (n4 == 0 && this.f) {
            return -1;
        }
        return n4;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read() {
        do {
            if (this.d.hasRemaining()) {
                return this.d.get() & 0xFF;
            }
            this.a();
        } while (!this.f || this.d.hasRemaining());
        return -1;
    }

    @Override
    public void close() {
        this.a.close();
    }
}

