/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.io.input.XmlStreamReaderException;

public class XmlStreamReader
extends Reader {
    private static final ByteOrderMark[] a = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE};
    private static final ByteOrderMark[] b = new ByteOrderMark[]{new ByteOrderMark("UTF-8", 60, 63, 120, 109), new ByteOrderMark("UTF-16BE", 0, 60, 0, 63), new ByteOrderMark("UTF-16LE", 60, 0, 63, 0), new ByteOrderMark("UTF-32BE", 0, 0, 0, 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 109), new ByteOrderMark("UTF-32LE", 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 109, 0, 0, 0), new ByteOrderMark("CP1047", 76, 111, 167, 148)};
    private final Reader c;
    private final String d;
    private final String e;
    private static final Pattern f = Pattern.compile("charset=[\"']?([.[^; \"']]*)[\"']?");
    public static final Pattern ENCODING_PATTERN = Pattern.compile("<\\?xml.*encoding[\\s]*=[\\s]*((?:\".[^\"]*\")|(?:'.[^']*'))", 8);

    public String getDefaultEncoding() {
        return this.e;
    }

    public XmlStreamReader(File file) {
        this(new FileInputStream(file));
    }

    public XmlStreamReader(InputStream inputStream) {
        this(inputStream, true);
    }

    public XmlStreamReader(InputStream inputStream, boolean bl2) {
        this(inputStream, bl2, null);
    }

    public XmlStreamReader(InputStream inputStream, boolean bl2, String object) {
        this.e = object;
        inputStream = new BOMInputStream((InputStream)new BufferedInputStream(inputStream, 4096), false, a);
        object = new BOMInputStream(inputStream, true, b);
        this.d = this.a((BOMInputStream)inputStream, (BOMInputStream)object, bl2);
        this.c = new InputStreamReader((InputStream)object, this.d);
    }

    public XmlStreamReader(URL uRL) {
        this(uRL.openConnection(), null);
    }

    public XmlStreamReader(URLConnection uRLConnection, String string) {
        this.e = string;
        string = uRLConnection.getContentType();
        InputStream inputStream = uRLConnection.getInputStream();
        inputStream = new BOMInputStream((InputStream)new BufferedInputStream(inputStream, 4096), false, a);
        BOMInputStream bOMInputStream = new BOMInputStream(inputStream, true, b);
        this.d = uRLConnection instanceof HttpURLConnection || string != null ? this.a((BOMInputStream)inputStream, bOMInputStream, string, true) : this.a((BOMInputStream)inputStream, bOMInputStream, true);
        this.c = new InputStreamReader((InputStream)bOMInputStream, this.d);
    }

    public XmlStreamReader(InputStream inputStream, String string) {
        this(inputStream, string, true);
    }

    public XmlStreamReader(InputStream inputStream, String string, boolean bl2, String object) {
        this.e = object;
        inputStream = new BOMInputStream((InputStream)new BufferedInputStream(inputStream, 4096), false, a);
        object = new BOMInputStream(inputStream, true, b);
        this.d = this.a((BOMInputStream)inputStream, (BOMInputStream)object, string, bl2);
        this.c = new InputStreamReader((InputStream)object, this.d);
    }

    public XmlStreamReader(InputStream inputStream, String string, boolean bl2) {
        this(inputStream, string, bl2, null);
    }

    public String getEncoding() {
        return this.d;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        return this.c.read(cArray, n2, n3);
    }

    @Override
    public void close() {
        this.c.close();
    }

    private String a(BOMInputStream object, BOMInputStream object2, boolean bl2) {
        object = ((BOMInputStream)object).getBOMCharsetName();
        String string = ((BOMInputStream)object2).getBOMCharsetName();
        object2 = XmlStreamReader.a((BOMInputStream)object2, string);
        try {
            return this.a((String)object, string, (String)object2);
        }
        catch (XmlStreamReaderException xmlStreamReaderException) {
            if (bl2) {
                return this.a(null, xmlStreamReaderException);
            }
            throw xmlStreamReaderException;
        }
    }

    private String a(BOMInputStream object, BOMInputStream object2, String string, boolean bl2) {
        object = ((BOMInputStream)object).getBOMCharsetName();
        String string2 = ((BOMInputStream)object2).getBOMCharsetName();
        object2 = XmlStreamReader.a((BOMInputStream)object2, string2);
        try {
            return this.a(string, (String)object, string2, (String)object2, bl2);
        }
        catch (XmlStreamReaderException xmlStreamReaderException) {
            if (bl2) {
                return this.a(string, xmlStreamReaderException);
            }
            throw xmlStreamReaderException;
        }
    }

    private String a(String object, XmlStreamReaderException xmlStreamReaderException) {
        if (object != null && ((String)object).startsWith("text/html")) {
            object = ((String)object).substring(9);
            object = "text/xml" + (String)object;
            try {
                return this.a((String)object, xmlStreamReaderException.getBomEncoding(), xmlStreamReaderException.getXmlGuessEncoding(), xmlStreamReaderException.getXmlEncoding(), true);
            }
            catch (XmlStreamReaderException xmlStreamReaderException2) {
                object = xmlStreamReaderException2;
                xmlStreamReaderException = xmlStreamReaderException2;
            }
        }
        if ((object = xmlStreamReaderException.getXmlEncoding()) == null) {
            object = xmlStreamReaderException.getContentTypeEncoding();
        }
        if (object == null) {
            object = this.e == null ? "UTF-8" : this.e;
        }
        return object;
    }

    private String a(String string, String string2, String string3) {
        if (string == null) {
            if (string2 == null || string3 == null) {
                if (this.e == null) {
                    return "UTF-8";
                }
                return this.e;
            }
            if (string3.equals("UTF-16") && (string2.equals("UTF-16BE") || string2.equals("UTF-16LE"))) {
                return string2;
            }
            return string3;
        }
        if (string.equals("UTF-8")) {
            if (string2 != null && !string2.equals("UTF-8")) {
                String string4 = MessageFormat.format("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch", string, string2, string3);
                throw new XmlStreamReaderException(string4, string, string2, string3);
            }
            if (string3 != null && !string3.equals("UTF-8")) {
                String string5 = MessageFormat.format("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch", string, string2, string3);
                throw new XmlStreamReaderException(string5, string, string2, string3);
            }
            return string;
        }
        if (string.equals("UTF-16BE") || string.equals("UTF-16LE")) {
            if (string2 != null && !string2.equals(string)) {
                String string6 = MessageFormat.format("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch", string, string2, string3);
                throw new XmlStreamReaderException(string6, string, string2, string3);
            }
            if (string3 != null && !string3.equals("UTF-16") && !string3.equals(string)) {
                String string7 = MessageFormat.format("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch", string, string2, string3);
                throw new XmlStreamReaderException(string7, string, string2, string3);
            }
            return string;
        }
        if (string.equals("UTF-32BE") || string.equals("UTF-32LE")) {
            if (string2 != null && !string2.equals(string)) {
                String string8 = MessageFormat.format("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch", string, string2, string3);
                throw new XmlStreamReaderException(string8, string, string2, string3);
            }
            if (string3 != null && !string3.equals("UTF-32") && !string3.equals(string)) {
                String string9 = MessageFormat.format("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch", string, string2, string3);
                throw new XmlStreamReaderException(string9, string, string2, string3);
            }
            return string;
        }
        String string10 = MessageFormat.format("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] unknown BOM", string, string2, string3);
        throw new XmlStreamReaderException(string10, string, string2, string3);
    }

    private String a(String string, String string2, String string3, String string4, boolean bl2) {
        if (bl2 && string4 != null) {
            return string4;
        }
        String string5 = XmlStreamReader.a(string);
        string = XmlStreamReader.b(string);
        boolean bl3 = XmlStreamReader.c(string5);
        boolean bl4 = XmlStreamReader.d(string5);
        if (!bl3 && !bl4) {
            String string6 = MessageFormat.format("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], Invalid MIME", string5, string, string2, string3, string4);
            throw new XmlStreamReaderException(string6, string5, string, string2, string3, string4);
        }
        if (string == null) {
            if (bl3) {
                return this.a(string2, string3, string4);
            }
            if (this.e == null) {
                return "US-ASCII";
            }
            return this.e;
        }
        if (string.equals("UTF-16BE") || string.equals("UTF-16LE")) {
            if (string2 != null) {
                String string7 = MessageFormat.format("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], BOM must be NULL", string5, string, string2, string3, string4);
                throw new XmlStreamReaderException(string7, string5, string, string2, string3, string4);
            }
            return string;
        }
        if (string.equals("UTF-16")) {
            if (string2 != null && string2.startsWith("UTF-16")) {
                return string2;
            }
            String string8 = MessageFormat.format("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], encoding mismatch", string5, string, string2, string3, string4);
            throw new XmlStreamReaderException(string8, string5, string, string2, string3, string4);
        }
        if (string.equals("UTF-32BE") || string.equals("UTF-32LE")) {
            if (string2 != null) {
                String string9 = MessageFormat.format("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], BOM must be NULL", string5, string, string2, string3, string4);
                throw new XmlStreamReaderException(string9, string5, string, string2, string3, string4);
            }
            return string;
        }
        if (string.equals("UTF-32")) {
            if (string2 != null && string2.startsWith("UTF-32")) {
                return string2;
            }
            String string10 = MessageFormat.format("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], encoding mismatch", string5, string, string2, string3, string4);
            throw new XmlStreamReaderException(string10, string5, string, string2, string3, string4);
        }
        return string;
    }

    private static String a(String string) {
        String string2 = null;
        if (string != null) {
            int n2 = string.indexOf(";");
            string2 = n2 >= 0 ? string.substring(0, n2) : string;
            string2 = string2.trim();
        }
        return string2;
    }

    private static String b(String object) {
        int n2;
        String string = null;
        if (object != null && (n2 = ((String)object).indexOf(";")) >= 0) {
            object = ((String)object).substring(n2 + 1);
            string = ((Matcher)(object = f.matcher((CharSequence)object))).find() ? ((Matcher)object).group(1) : null;
            string = string != null ? string.toUpperCase(Locale.US) : null;
        }
        return string;
    }

    private static String a(BOMInputStream object, String string) {
        String string2 = null;
        if (string != null) {
            Object object2 = new byte[4096];
            ((InputStream)object).mark(4096);
            int n2 = 0;
            int n3 = 4096;
            int n4 = ((InputStream)object).read((byte[])object2, 0, 4096);
            int n5 = -1;
            String string3 = "";
            while (n4 != -1 && n5 == -1 && n2 < 4096) {
                n4 = ((InputStream)object).read((byte[])object2, n2 += n4, n3 -= n4);
                string3 = new String((byte[])object2, 0, n2, string);
                n5 = string3.indexOf(62);
            }
            if (n5 == -1) {
                if (n4 == -1) {
                    throw new IOException("Unexpected end of XML stream");
                }
                throw new IOException("XML prolog or ROOT element not found on first " + n2 + " bytes");
            }
            int n6 = n2;
            if (n6 > 0) {
                ((InputStream)object).reset();
                object = new BufferedReader(new StringReader(string3.substring(0, n5 + 1)));
                StringBuffer stringBuffer = new StringBuffer();
                object2 = ((BufferedReader)object).readLine();
                while (object2 != null) {
                    stringBuffer.append((String)object2);
                    object2 = ((BufferedReader)object).readLine();
                }
                object = ENCODING_PATTERN.matcher(stringBuffer);
                if (((Matcher)object).find()) {
                    string2 = ((Matcher)object).group(1).toUpperCase();
                    string2 = string2.substring(1, string2.length() - 1);
                }
            }
        }
        return string2;
    }

    private static boolean c(String string) {
        return string != null && (string.equals("application/xml") || string.equals("application/xml-dtd") || string.equals("application/xml-external-parsed-entity") || string.startsWith("application/") && string.endsWith("+xml"));
    }

    private static boolean d(String string) {
        return string != null && (string.equals("text/xml") || string.equals("text/xml-external-parsed-entity") || string.startsWith("text/") && string.endsWith("+xml"));
    }
}

