/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.io.monitor.FileAlterationObserver;

public final class FileAlterationMonitor
implements Runnable {
    private final long a;
    private final List<FileAlterationObserver> b = new CopyOnWriteArrayList<FileAlterationObserver>();
    private Thread c = null;
    private ThreadFactory d;
    private volatile boolean e = false;

    public FileAlterationMonitor() {
        this(10000L);
    }

    public FileAlterationMonitor(long l2) {
        this.a = l2;
    }

    public FileAlterationMonitor(long l2, FileAlterationObserver ... fileAlterationObserverArray) {
        this(l2);
        if (fileAlterationObserverArray != null) {
            FileAlterationObserver[] fileAlterationObserverArray2 = fileAlterationObserverArray;
            int n2 = fileAlterationObserverArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                FileAlterationObserver fileAlterationObserver = fileAlterationObserverArray2[i2];
                this.addObserver(fileAlterationObserver);
            }
        }
    }

    public final long getInterval() {
        return this.a;
    }

    public final synchronized void setThreadFactory(ThreadFactory threadFactory) {
        this.d = threadFactory;
    }

    public final void addObserver(FileAlterationObserver fileAlterationObserver) {
        if (fileAlterationObserver != null) {
            this.b.add(fileAlterationObserver);
        }
    }

    public final void removeObserver(FileAlterationObserver fileAlterationObserver) {
        if (fileAlterationObserver != null) {
            while (this.b.remove(fileAlterationObserver)) {
            }
        }
    }

    public final Iterable<FileAlterationObserver> getObservers() {
        return this.b;
    }

    public final synchronized void start() {
        if (this.e) {
            throw new IllegalStateException("Monitor is already running");
        }
        for (FileAlterationObserver fileAlterationObserver : this.b) {
            fileAlterationObserver.initialize();
        }
        this.e = true;
        this.c = this.d != null ? this.d.newThread(this) : new Thread(this);
        this.c.start();
    }

    public final synchronized void stop() {
        FileAlterationMonitor fileAlterationMonitor = this;
        fileAlterationMonitor.stop(fileAlterationMonitor.a);
    }

    public final synchronized void stop(long l2) {
        if (!this.e) {
            throw new IllegalStateException("Monitor is not running");
        }
        this.e = false;
        try {
            this.c.join(l2);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        for (FileAlterationObserver fileAlterationObserver : this.b) {
            fileAlterationObserver.destroy();
        }
    }

    @Override
    public final void run() {
        while (this.e) {
            for (FileAlterationObserver fileAlterationObserver : this.b) {
                fileAlterationObserver.checkAndNotify();
            }
            if (!this.e) break;
            try {
                Thread.sleep(this.a);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

