/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileEntry;

public class FileAlterationObserver
implements Serializable {
    private final List<FileAlterationListener> a = new CopyOnWriteArrayList<FileAlterationListener>();
    private final FileEntry b;
    private final FileFilter c;
    private final Comparator<File> d;

    public FileAlterationObserver(String string) {
        this(new File(string));
    }

    public FileAlterationObserver(String string, FileFilter fileFilter) {
        this(new File(string), fileFilter);
    }

    public FileAlterationObserver(String string, FileFilter fileFilter, IOCase iOCase) {
        this(new File(string), fileFilter, iOCase);
    }

    public FileAlterationObserver(File file) {
        this(file, null);
    }

    public FileAlterationObserver(File file, FileFilter fileFilter) {
        this(file, fileFilter, null);
    }

    public FileAlterationObserver(File file, FileFilter fileFilter, IOCase iOCase) {
        this(new FileEntry(file), fileFilter, iOCase);
    }

    protected FileAlterationObserver(FileEntry fileEntry, FileFilter fileFilter, IOCase iOCase) {
        if (fileEntry == null) {
            throw new IllegalArgumentException("Root entry is missing");
        }
        if (fileEntry.getFile() == null) {
            throw new IllegalArgumentException("Root directory is missing");
        }
        this.b = fileEntry;
        this.c = fileFilter;
        if (iOCase == null || iOCase.equals(IOCase.SYSTEM)) {
            this.d = NameFileComparator.NAME_SYSTEM_COMPARATOR;
            return;
        }
        if (iOCase.equals(IOCase.INSENSITIVE)) {
            this.d = NameFileComparator.NAME_INSENSITIVE_COMPARATOR;
            return;
        }
        this.d = NameFileComparator.NAME_COMPARATOR;
    }

    public File getDirectory() {
        return this.b.getFile();
    }

    public FileFilter getFileFilter() {
        return this.c;
    }

    public void addListener(FileAlterationListener fileAlterationListener) {
        if (fileAlterationListener != null) {
            this.a.add(fileAlterationListener);
        }
    }

    public void removeListener(FileAlterationListener fileAlterationListener) {
        if (fileAlterationListener != null) {
            while (this.a.remove(fileAlterationListener)) {
            }
        }
    }

    public Iterable<FileAlterationListener> getListeners() {
        return this.a;
    }

    public void initialize() {
        this.b.refresh(this.b.getFile());
        FileAlterationObserver fileAlterationObserver = this;
        FileEntry[] fileEntryArray = fileAlterationObserver.a(fileAlterationObserver.b.getFile(), this.b);
        this.b.setChildren(fileEntryArray);
    }

    public void destroy() {
    }

    public void checkAndNotify() {
        for (FileAlterationListener fileAlterationListener : this.a) {
            fileAlterationListener.onStart(this);
        }
        File file = this.b.getFile();
        if (file.exists()) {
            FileAlterationObserver fileAlterationObserver = this;
            fileAlterationObserver.a(fileAlterationObserver.b, this.b.getChildren(), this.a(file));
        } else if (this.b.isExists()) {
            FileAlterationObserver fileAlterationObserver = this;
            fileAlterationObserver.a(fileAlterationObserver.b, this.b.getChildren(), FileUtils.EMPTY_FILE_ARRAY);
        }
        for (FileAlterationListener fileAlterationListener : this.a) {
            fileAlterationListener.onStop(this);
        }
    }

    private void a(FileEntry fileEntry, FileEntry[] fileEntryArray, File[] fileArray) {
        int n2 = 0;
        FileEntry[] fileEntryArray2 = fileArray.length > 0 ? new FileEntry[fileArray.length] : FileEntry.a;
        for (FileEntry fileEntry2 : fileEntryArray) {
            while (n2 < fileArray.length && this.d.compare(fileEntry2.getFile(), fileArray[n2]) > 0) {
                fileEntryArray2[n2] = this.a(fileEntry, fileArray[n2]);
                this.a(fileEntryArray2[n2]);
                ++n2;
            }
            if (n2 < fileArray.length && this.d.compare(fileEntry2.getFile(), fileArray[n2]) == 0) {
                this.b(fileEntry2, fileArray[n2]);
                FileEntry fileEntry3 = fileEntry2;
                this.a(fileEntry3, fileEntry3.getChildren(), this.a(fileArray[n2]));
                fileEntryArray2[n2] = fileEntry2;
                ++n2;
                continue;
            }
            FileEntry fileEntry4 = fileEntry2;
            this.a(fileEntry4, fileEntry4.getChildren(), FileUtils.EMPTY_FILE_ARRAY);
            this.b(fileEntry2);
        }
        while (n2 < fileArray.length) {
            fileEntryArray2[n2] = this.a(fileEntry, fileArray[n2]);
            this.a(fileEntryArray2[n2]);
            ++n2;
        }
        fileEntry.setChildren(fileEntryArray2);
    }

    private FileEntry a(FileEntry fileEntry, File fileEntryArray) {
        fileEntry = fileEntry.newChildInstance((File)fileEntryArray);
        fileEntry.refresh((File)fileEntryArray);
        fileEntryArray = this.a((File)fileEntryArray, fileEntry);
        fileEntry.setChildren(fileEntryArray);
        return fileEntry;
    }

    private FileEntry[] a(File fileArray, FileEntry fileEntry) {
        FileEntry[] fileEntryArray = (fileArray = this.a((File)fileArray)).length > 0 ? new FileEntry[fileArray.length] : FileEntry.a;
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            fileEntryArray[i2] = this.a(fileEntry, fileArray[i2]);
        }
        return fileEntryArray;
    }

    private void a(FileEntry fileEntry) {
        FileEntry[] fileEntryArray;
        FileEntry[] fileEntryArray2 = this.a.iterator();
        while (fileEntryArray2.hasNext()) {
            fileEntryArray = fileEntryArray2.next();
            if (fileEntry.isDirectory()) {
                fileEntryArray.onDirectoryCreate(fileEntry.getFile());
                continue;
            }
            fileEntryArray.onFileCreate(fileEntry.getFile());
        }
        fileEntryArray = fileEntryArray2 = fileEntry.getChildren();
        int n2 = fileEntryArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FileEntry fileEntry2 = fileEntryArray[i2];
            this.a(fileEntry2);
        }
    }

    private void b(FileEntry fileEntry, File file) {
        if (fileEntry.refresh(file)) {
            for (FileAlterationListener fileAlterationListener : this.a) {
                if (fileEntry.isDirectory()) {
                    fileAlterationListener.onDirectoryChange(file);
                    continue;
                }
                fileAlterationListener.onFileChange(file);
            }
        }
    }

    private void b(FileEntry fileEntry) {
        for (FileAlterationListener fileAlterationListener : this.a) {
            if (fileEntry.isDirectory()) {
                fileAlterationListener.onDirectoryDelete(fileEntry.getFile());
                continue;
            }
            fileAlterationListener.onFileDelete(fileEntry.getFile());
        }
    }

    private File[] a(File file) {
        File[] fileArray = null;
        if (file.isDirectory()) {
            File[] fileArray2 = fileArray = this.c == null ? file.listFiles() : file.listFiles(this.c);
        }
        if (fileArray == null) {
            fileArray = FileUtils.EMPTY_FILE_ARRAY;
        }
        if (this.d != null && fileArray.length > 1) {
            Arrays.sort(fileArray, this.d);
        }
        return fileArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("[file='");
        stringBuilder.append(this.getDirectory().getPath());
        stringBuilder.append('\'');
        if (this.c != null) {
            stringBuilder.append(", ");
            stringBuilder.append(this.c.toString());
        }
        stringBuilder.append(", listeners=");
        stringBuilder.append(this.a.size());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

