/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.input.ClosedInputStream;

public class ByteArrayOutputStream
extends OutputStream {
    private static final byte[] a = new byte[0];
    private final List<byte[]> b = new ArrayList<byte[]>();
    private int c;
    private int d;
    private byte[] e;
    private int f;
    private boolean g = true;

    public ByteArrayOutputStream() {
        this(1024);
    }

    public ByteArrayOutputStream(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            this.a(n2);
            return;
        }
    }

    private void a(int n2) {
        if (this.c < this.b.size() - 1) {
            this.d += this.e.length;
            ++this.c;
            this.e = this.b.get(this.c);
            return;
        }
        if (this.e == null) {
            this.d = 0;
        } else {
            n2 = Math.max(this.e.length << 1, n2 - this.d);
            this.d += this.e.length;
        }
        ++this.c;
        this.e = new byte[n2];
        this.b.add(this.e);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            int n4 = this.f + n3;
            int n5 = n3;
            int n6 = this.f - this.d;
            while (n5 > 0) {
                int n7 = Math.min(n5, this.e.length - n6);
                System.arraycopy(byArray, n2 + n3 - n5, this.e, n6, n7);
                if ((n5 -= n7) <= 0) continue;
                this.a(n4);
                n6 = 0;
            }
            this.f = n4;
            return;
        }
    }

    @Override
    public synchronized void write(int n2) {
        int n3 = this.f - this.d;
        if (n3 == this.e.length) {
            ByteArrayOutputStream byteArrayOutputStream = this;
            byteArrayOutputStream.a(byteArrayOutputStream.f + 1);
            n3 = 0;
        }
        this.e[n3] = (byte)n2;
        ++this.f;
    }

    public synchronized int write(InputStream inputStream) {
        int n2 = 0;
        int n3 = this.f - this.d;
        int n4 = inputStream.read(this.e, n3, this.e.length - n3);
        while (n4 != -1) {
            n2 += n4;
            this.f += n4;
            if ((n3 += n4) == this.e.length) {
                ByteArrayOutputStream byteArrayOutputStream = this;
                byteArrayOutputStream.a(byteArrayOutputStream.e.length);
                n3 = 0;
            }
            n4 = inputStream.read(this.e, n3, this.e.length - n3);
        }
        return n2;
    }

    public synchronized int size() {
        return this.f;
    }

    @Override
    public void close() {
    }

    public synchronized void reset() {
        this.f = 0;
        this.d = 0;
        this.c = 0;
        if (this.g) {
            this.e = this.b.get(this.c);
            return;
        }
        this.e = null;
        int n2 = this.b.get(0).length;
        this.b.clear();
        this.a(n2);
        this.g = true;
    }

    public synchronized void writeTo(OutputStream outputStream) {
        int n2 = this.f;
        for (byte[] byArray : this.b) {
            int n3 = Math.min(byArray.length, n2);
            outputStream.write(byArray, 0, n3);
            if ((n2 -= n3) != 0) continue;
        }
    }

    public static InputStream toBufferedInputStream(InputStream inputStream) {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream, 1024);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        byteArrayOutputStream.write(inputStream);
        return byteArrayOutputStream.toInputStream();
    }

    public synchronized InputStream toInputStream() {
        int n2 = this.f;
        if (n2 == 0) {
            return new ClosedInputStream();
        }
        ArrayList<ByteArrayInputStream> arrayList = new ArrayList<ByteArrayInputStream>(this.b.size());
        for (byte[] byArray : this.b) {
            int n3 = Math.min(byArray.length, n2);
            arrayList.add(new ByteArrayInputStream(byArray, 0, n3));
            if ((n2 -= n3) != 0) continue;
        }
        this.g = false;
        return new SequenceInputStream(Collections.enumeration(arrayList));
    }

    public synchronized byte[] toByteArray() {
        int n2 = this.f;
        if (n2 == 0) {
            return a;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (byte[] byArray2 : this.b) {
            int n4 = Math.min(byArray2.length, n2);
            System.arraycopy(byArray2, 0, byArray, n3, n4);
            n3 += n4;
            if ((n2 -= n4) != 0) continue;
        }
        return byArray;
    }

    @Deprecated
    public String toString() {
        return new String(this.toByteArray(), Charset.defaultCharset());
    }

    public String toString(String string) {
        return new String(this.toByteArray(), string);
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), charset);
    }
}

