/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.FilterOutputStream;
import java.io.OutputStream;

public class ChunkedOutputStream
extends FilterOutputStream {
    private final int a;

    public ChunkedOutputStream(OutputStream outputStream, int n2) {
        super(outputStream);
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.a = n2;
    }

    public ChunkedOutputStream(OutputStream outputStream) {
        this(outputStream, 4096);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = Math.min(n3, this.a);
            this.out.write(byArray, n2, n4);
            n3 -= n4;
            n2 += n4;
        }
    }
}

