/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;

public class DeferredFileOutputStream
extends ThresholdingOutputStream {
    private ByteArrayOutputStream a;
    private OutputStream b;
    private File c;
    private final String d;
    private final String e;
    private final File f;
    private boolean g = false;

    public DeferredFileOutputStream(int n2, File file) {
        this(n2, file, null, null, null, 1024);
    }

    public DeferredFileOutputStream(int n2, int n3, File file) {
        this(n2, file, null, null, null, n3);
        if (n3 < 0) {
            throw new IllegalArgumentException("Initial buffer size must be atleast 0.");
        }
    }

    public DeferredFileOutputStream(int n2, String string, String string2, File file) {
        this(n2, null, string, string2, file, 1024);
        if (string == null) {
            throw new IllegalArgumentException("Temporary file prefix is missing");
        }
    }

    public DeferredFileOutputStream(int n2, int n3, String string, String string2, File file) {
        this(n2, null, string, string2, file, n3);
        if (string == null) {
            throw new IllegalArgumentException("Temporary file prefix is missing");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Initial buffer size must be atleast 0.");
        }
    }

    private DeferredFileOutputStream(int n2, File file, String string, String string2, File file2, int n3) {
        super(n2);
        this.c = file;
        this.d = string;
        this.e = string2;
        this.f = file2;
        this.a = new ByteArrayOutputStream(n3);
        this.b = this.a;
    }

    @Override
    protected OutputStream getStream() {
        return this.b;
    }

    @Override
    protected void thresholdReached() {
        if (this.d != null) {
            this.c = File.createTempFile(this.d, this.e, this.f);
        }
        FileUtils.forceMkdirParent(this.c);
        FileOutputStream fileOutputStream = new FileOutputStream(this.c);
        try {
            this.a.writeTo(fileOutputStream);
        }
        catch (IOException iOException) {
            fileOutputStream.close();
            throw iOException;
        }
        this.b = fileOutputStream;
        this.a = null;
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    public byte[] getData() {
        if (this.a != null) {
            return this.a.toByteArray();
        }
        return null;
    }

    public File getFile() {
        return this.c;
    }

    @Override
    public void close() {
        super.close();
        this.g = true;
    }

    public void writeTo(OutputStream object) {
        if (!this.g) {
            throw new IOException("Stream not closed");
        }
        if (this.isInMemory()) {
            this.a.writeTo((OutputStream)object);
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(this.c);
        Throwable throwable = null;
        try {
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)object);
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (throwable != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    fileInputStream.close();
                }
                throw throwable3;
            }
        }
        fileInputStream.close();
        return;
    }
}

