/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.io.FileUtils;

public class FileWriterWithEncoding
extends Writer {
    private final Writer a;

    public FileWriterWithEncoding(String string, String string2) {
        this(new File(string), string2, false);
    }

    public FileWriterWithEncoding(String string, String string2, boolean bl2) {
        this(new File(string), string2, bl2);
    }

    public FileWriterWithEncoding(String string, Charset charset) {
        this(new File(string), charset, false);
    }

    public FileWriterWithEncoding(String string, Charset charset, boolean bl2) {
        this(new File(string), charset, bl2);
    }

    public FileWriterWithEncoding(String string, CharsetEncoder charsetEncoder) {
        this(new File(string), charsetEncoder, false);
    }

    public FileWriterWithEncoding(String string, CharsetEncoder charsetEncoder, boolean bl2) {
        this(new File(string), charsetEncoder, bl2);
    }

    public FileWriterWithEncoding(File file, String string) {
        this(file, string, false);
    }

    public FileWriterWithEncoding(File file, String string, boolean bl2) {
        this.a = FileWriterWithEncoding.a(file, string, bl2);
    }

    public FileWriterWithEncoding(File file, Charset charset) {
        this(file, charset, false);
    }

    public FileWriterWithEncoding(File file, Charset charset, boolean bl2) {
        this.a = FileWriterWithEncoding.a(file, charset, bl2);
    }

    public FileWriterWithEncoding(File file, CharsetEncoder charsetEncoder) {
        this(file, charsetEncoder, false);
    }

    public FileWriterWithEncoding(File file, CharsetEncoder charsetEncoder, boolean bl2) {
        this.a = FileWriterWithEncoding.a(file, charsetEncoder, bl2);
    }

    private static Writer a(File file, Object object, boolean bl2) {
        if (file == null) {
            throw new NullPointerException("File is missing");
        }
        if (object == null) {
            throw new NullPointerException("Encoding is missing");
        }
        FileOutputStream fileOutputStream = null;
        boolean bl3 = file.exists();
        try {
            fileOutputStream = new FileOutputStream(file, bl2);
            if (object instanceof Charset) {
                return new OutputStreamWriter((OutputStream)fileOutputStream, (Charset)object);
            }
            if (object instanceof CharsetEncoder) {
                return new OutputStreamWriter((OutputStream)fileOutputStream, (CharsetEncoder)object);
            }
            return new OutputStreamWriter((OutputStream)fileOutputStream, (String)object);
        }
        catch (IOException | RuntimeException exception) {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                exception.addSuppressed(iOException);
            }
            if (!bl3) {
                FileUtils.deleteQuietly(file);
            }
            throw exception;
        }
    }

    @Override
    public void write(int n2) {
        this.a.write(n2);
    }

    @Override
    public void write(char[] cArray) {
        this.a.write(cArray);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) {
        this.a.write(cArray, n2, n3);
    }

    @Override
    public void write(String string) {
        this.a.write(string);
    }

    @Override
    public void write(String string, int n2, int n3) {
        this.a.write(string, n2, n3);
    }

    @Override
    public void flush() {
        this.a.flush();
    }

    @Override
    public void close() {
        this.a.close();
    }
}

