/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;

public class LockableFileWriter
extends Writer {
    private final Writer a;
    private final File b;

    public LockableFileWriter(String string) {
        this(string, false, null);
    }

    public LockableFileWriter(String string, boolean bl2) {
        this(string, bl2, null);
    }

    public LockableFileWriter(String string, boolean bl2, String string2) {
        this(new File(string), bl2, string2);
    }

    public LockableFileWriter(File file) {
        this(file, false, null);
    }

    public LockableFileWriter(File file, boolean bl2) {
        this(file, bl2, null);
    }

    @Deprecated
    public LockableFileWriter(File file, boolean bl2, String string) {
        this(file, Charset.defaultCharset(), bl2, string);
    }

    public LockableFileWriter(File file, Charset charset) {
        this(file, charset, false, null);
    }

    public LockableFileWriter(File file, String string) {
        this(file, string, false, null);
    }

    public LockableFileWriter(File file, Charset charset, boolean bl2, String clazz) {
        file = file.getAbsoluteFile();
        if (file.getParentFile() != null) {
            FileUtils.forceMkdir(file.getParentFile());
        }
        if (file.isDirectory()) {
            throw new IOException("File specified is a directory");
        }
        if (clazz == null) {
            clazz = System.getProperty("java.io.tmpdir");
        }
        clazz = new File((String)((Object)clazz));
        FileUtils.forceMkdir((File)((Object)clazz));
        Class<LockableFileWriter> clazz2 = clazz;
        if (!((File)((Object)clazz2)).exists()) {
            throw new IOException("Could not find lockDir: " + ((File)((Object)clazz2)).getAbsolutePath());
        }
        if (!((File)((Object)clazz2)).canWrite()) {
            throw new IOException("Could not write to lockDir: " + ((File)((Object)clazz2)).getAbsolutePath());
        }
        this.b = new File((File)((Object)clazz), file.getName() + ".lck");
        clazz2 = this;
        clazz = LockableFileWriter.class;
        synchronized (LockableFileWriter.class) {
            if (!((LockableFileWriter)((Object)clazz2)).b.createNewFile()) {
                throw new IOException("Can't write file, lock " + ((LockableFileWriter)((Object)clazz2)).b.getAbsolutePath() + " exists");
            }
            ((LockableFileWriter)((Object)clazz2)).b.deleteOnExit();
            // ** MonitorExit[var4_5] (shouldn't be in output)
            this.a = this.a(file, charset, bl2);
            return;
        }
    }

    public LockableFileWriter(File file, String string, boolean bl2, String string2) {
        this(file, Charsets.toCharset(string), bl2, string2);
    }

    private Writer a(File file, Charset charset, boolean bl2) {
        boolean bl3 = file.exists();
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath(), bl2), Charsets.toCharset(charset));
        }
        catch (IOException | RuntimeException exception) {
            FileUtils.deleteQuietly(this.b);
            if (!bl3) {
                FileUtils.deleteQuietly(file);
            }
            throw exception;
        }
    }

    @Override
    public void close() {
        try {
            this.a.close();
            return;
        }
        finally {
            this.b.delete();
        }
    }

    @Override
    public void write(int n2) {
        this.a.write(n2);
    }

    @Override
    public void write(char[] cArray) {
        this.a.write(cArray);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) {
        this.a.write(cArray, n2, n3);
    }

    @Override
    public void write(String string) {
        this.a.write(string);
    }

    @Override
    public void write(String string, int n2, int n3) {
        this.a.write(string, n2, n3);
    }

    @Override
    public void flush() {
        this.a.flush();
    }
}

