/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;

public abstract class ThresholdingOutputStream
extends OutputStream {
    private final int a;
    private long b;
    private boolean c;

    public ThresholdingOutputStream(int n2) {
        this.a = n2;
    }

    @Override
    public void write(int n2) {
        this.checkThreshold(1);
        this.getStream().write(n2);
        ++this.b;
    }

    @Override
    public void write(byte[] byArray) {
        this.checkThreshold(byArray.length);
        this.getStream().write(byArray);
        this.b += (long)byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.checkThreshold(n3);
        this.getStream().write(byArray, n2, n3);
        this.b += (long)n3;
    }

    @Override
    public void flush() {
        this.getStream().flush();
    }

    @Override
    public void close() {
        try {
            this.flush();
        }
        catch (IOException iOException) {}
        this.getStream().close();
    }

    public int getThreshold() {
        return this.a;
    }

    public long getByteCount() {
        return this.b;
    }

    public boolean isThresholdExceeded() {
        return this.b > (long)this.a;
    }

    protected void checkThreshold(int n2) {
        if (!this.c && this.b + (long)n2 > (long)this.a) {
            this.c = true;
            this.thresholdReached();
        }
    }

    protected void resetByteCount() {
        this.c = false;
        this.b = 0L;
    }

    protected void setByteCount(long l2) {
        this.b = l2;
    }

    protected abstract OutputStream getStream();

    protected abstract void thresholdReached();
}

