/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class WriterOutputStream
extends OutputStream {
    private final Writer a;
    private final CharsetDecoder b;
    private final boolean c;
    private final ByteBuffer d = ByteBuffer.allocate(128);
    private final CharBuffer e;

    public WriterOutputStream(Writer writer, CharsetDecoder charsetDecoder) {
        this(writer, charsetDecoder, 1024, false);
    }

    public WriterOutputStream(Writer writer, CharsetDecoder charsetDecoder, int n2, boolean bl2) {
        Object object = charsetDecoder.charset();
        if ("UTF-16".equals(((Charset)object).name())) {
            byte[] byArray = "v\u00e9s".getBytes((Charset)object);
            object = ((Charset)object).newDecoder();
            ByteBuffer byteBuffer = ByteBuffer.allocate(16);
            CharBuffer charBuffer = CharBuffer.allocate(3);
            int n3 = byArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                byteBuffer.put(byArray[i2]);
                byteBuffer.flip();
                try {
                    ((CharsetDecoder)object).decode(byteBuffer, charBuffer, i2 == n3 - 1);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new UnsupportedOperationException("UTF-16 requested when runninng on an IBM JDK with broken UTF-16 support. Please find a JDK that supports UTF-16 if you intend to use UF-16 with WriterOutputStream");
                }
                byteBuffer.compact();
            }
            charBuffer.rewind();
            if (!"v\u00e9s".equals(charBuffer.toString())) {
                throw new UnsupportedOperationException("UTF-16 requested when runninng on an IBM JDK with broken UTF-16 support. Please find a JDK that supports UTF-16 if you intend to use UF-16 with WriterOutputStream");
            }
        }
        this.a = writer;
        this.b = charsetDecoder;
        this.c = bl2;
        this.e = CharBuffer.allocate(n2);
    }

    public WriterOutputStream(Writer writer, Charset charset, int n2, boolean bl2) {
        this(writer, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?"), n2, bl2);
    }

    public WriterOutputStream(Writer writer, Charset charset) {
        this(writer, charset, 1024, false);
    }

    public WriterOutputStream(Writer writer, String string, int n2, boolean bl2) {
        this(writer, Charset.forName(string), n2, bl2);
    }

    public WriterOutputStream(Writer writer, String string) {
        this(writer, string, 1024, false);
    }

    @Deprecated
    public WriterOutputStream(Writer writer) {
        this(writer, Charset.defaultCharset(), 1024, false);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = Math.min(n3, this.d.remaining());
            this.d.put(byArray, n2, n4);
            this.a(false);
            n3 -= n4;
            n2 += n4;
        }
        if (this.c) {
            this.a();
        }
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n2) {
        this.write(new byte[]{(byte)n2}, 0, 1);
    }

    @Override
    public void flush() {
        this.a();
        this.a.flush();
    }

    @Override
    public void close() {
        this.a(true);
        this.a();
        this.a.close();
    }

    private void a(boolean bl2) {
        CoderResult coderResult;
        this.d.flip();
        while ((coderResult = this.b.decode(this.d, this.e, bl2)).isOverflow()) {
            this.a();
        }
        if (!coderResult.isUnderflow()) {
            throw new IOException("Unexpected coder result");
        }
        this.d.compact();
    }

    private void a() {
        if (this.e.position() > 0) {
            this.a.write(this.e.array(), 0, this.e.position());
            this.e.rewind();
        }
    }
}

