/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.serialization.ClassNameMatcher;
import org.apache.commons.io.serialization.a;
import org.apache.commons.io.serialization.b;
import org.apache.commons.io.serialization.c;

public class ValidatingObjectInputStream
extends ObjectInputStream {
    private final List<ClassNameMatcher> a = new ArrayList<ClassNameMatcher>();
    private final List<ClassNameMatcher> b = new ArrayList<ClassNameMatcher>();

    public ValidatingObjectInputStream(InputStream inputStream) {
        super(inputStream);
    }

    protected void invalidClassNameFound(String string) {
        throw new InvalidClassException("Class name not accepted: " + string);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) {
        String string = objectStreamClass.getName();
        ValidatingObjectInputStream validatingObjectInputStream = this;
        for (ClassNameMatcher object : validatingObjectInputStream.b) {
            if (!object.matches(string)) continue;
            validatingObjectInputStream.invalidClassNameFound(string);
        }
        boolean bl2 = false;
        for (ClassNameMatcher classNameMatcher : validatingObjectInputStream.a) {
            if (!classNameMatcher.matches(string)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            validatingObjectInputStream.invalidClassNameFound(string);
        }
        return super.resolveClass(objectStreamClass);
    }

    public ValidatingObjectInputStream accept(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            this.a.add(new a(clazz.getName()));
        }
        return this;
    }

    public ValidatingObjectInputStream reject(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            this.b.add(new a(clazz.getName()));
        }
        return this;
    }

    public ValidatingObjectInputStream accept(String ... stringArray) {
        for (String string : stringArray) {
            this.a.add(new c(string));
        }
        return this;
    }

    public ValidatingObjectInputStream reject(String ... stringArray) {
        for (String string : stringArray) {
            this.b.add(new c(string));
        }
        return this;
    }

    public ValidatingObjectInputStream accept(Pattern pattern) {
        this.a.add(new b(pattern));
        return this;
    }

    public ValidatingObjectInputStream reject(Pattern pattern) {
        this.b.add(new b(pattern));
        return this;
    }

    public ValidatingObjectInputStream accept(ClassNameMatcher classNameMatcher) {
        this.a.add(classNameMatcher);
        return this;
    }

    public ValidatingObjectInputStream reject(ClassNameMatcher classNameMatcher) {
        this.b.add(classNameMatcher);
        return this;
    }
}

