/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AnnotationUtils {
    private static final 1 a = new ToStringStyle(){
        {
            this.setDefaultFullDetail(true);
            this.setArrayContentDetail(true);
            this.setUseClassName(true);
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
            this.setContentStart("(");
            this.setContentEnd(")");
            this.setFieldSeparator(", ");
            this.setArrayStart("[");
            this.setArrayEnd("]");
        }

        @Override
        protected final String getShortClassName(Class<?> object) {
            for (Class<?> clazz : ClassUtils.getAllInterfaces(object)) {
                if (!Annotation.class.isAssignableFrom(clazz)) continue;
                return "@" + clazz.getName();
            }
            return "";
        }

        @Override
        protected final void appendDetail(StringBuffer stringBuffer, String string, Object object) {
            if (object instanceof Annotation) {
                object = AnnotationUtils.toString((Annotation)object);
            }
            super.appendDetail(stringBuffer, string, object);
        }
    };

    public static boolean equals(Annotation annotation, Annotation annotation2) {
        if (annotation == annotation2) {
            return true;
        }
        if (annotation == null || annotation2 == null) {
            return false;
        }
        Method[] methodArray = annotation.annotationType();
        Class<? extends Annotation> clazz = annotation2.annotationType();
        Validate.notNull(methodArray, "Annotation %s with null annotationType()", annotation);
        Validate.notNull(clazz, "Annotation %s with null annotationType()", annotation2);
        if (!methodArray.equals(clazz)) {
            return false;
        }
        try {
            for (Method method : methodArray.getDeclaredMethods()) {
                boolean bl2;
                block17: {
                    if (method.getParameterTypes().length != 0 || !AnnotationUtils.isValidAnnotationMemberType(method.getReturnType())) continue;
                    Annotation[] annotationArray = method.invoke((Object)annotation, new Object[0]);
                    Object object = method.invoke((Object)annotation2, new Object[0]);
                    Class<?> clazz2 = method.getReturnType();
                    if (annotationArray == object) {
                        bl2 = true;
                    } else if (annotationArray == null || object == null) {
                        bl2 = false;
                    } else if (clazz2.isArray()) {
                        Class<?> clazz3 = clazz2.getComponentType();
                        if (clazz3.isAnnotation()) {
                            Annotation[] annotationArray2 = annotationArray;
                            annotationArray = (Annotation[])object;
                            Annotation[] annotationArray3 = annotationArray2;
                            if (annotationArray2.length != annotationArray.length) {
                                bl2 = false;
                            } else {
                                for (int i2 = 0; i2 < annotationArray3.length; ++i2) {
                                    if (AnnotationUtils.equals(annotationArray3[i2], annotationArray[i2])) continue;
                                    bl2 = false;
                                    break block17;
                                }
                                bl2 = true;
                            }
                        } else {
                            bl2 = clazz3.equals(Byte.TYPE) ? Arrays.equals((byte[])annotationArray, (byte[])object) : (clazz3.equals(Short.TYPE) ? Arrays.equals((short[])annotationArray, (short[])object) : (clazz3.equals(Integer.TYPE) ? Arrays.equals((int[])annotationArray, (int[])object) : (clazz3.equals(Character.TYPE) ? Arrays.equals((char[])annotationArray, (char[])object) : (clazz3.equals(Long.TYPE) ? Arrays.equals((long[])annotationArray, (long[])object) : (clazz3.equals(Float.TYPE) ? Arrays.equals((float[])annotationArray, (float[])object) : (clazz3.equals(Double.TYPE) ? Arrays.equals((double[])annotationArray, (double[])object) : (clazz3.equals(Boolean.TYPE) ? Arrays.equals((boolean[])annotationArray, (boolean[])object) : Arrays.equals(annotationArray, (Object[])object))))))));
                        }
                    } else {
                        bl2 = clazz2.isAnnotation() ? AnnotationUtils.equals((Annotation)annotationArray, (Annotation)object) : annotationArray.equals(object);
                    }
                }
                if (bl2) continue;
                return false;
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
        return true;
    }

    public static int hashCode(Annotation annotation) {
        int n2 = 0;
        Method[] methodArray = annotation.annotationType();
        for (Method method : methodArray.getDeclaredMethods()) {
            Object object;
            try {
                int n3;
                object = method.invoke((Object)annotation, new Object[0]);
                if (object == null) {
                    throw new IllegalStateException(String.format("Annotation method %s returned null", method));
                }
                Object object2 = object;
                String string2 = method.getName();
                int n32 = string2.hashCode() * 127;
                if (object2.getClass().isArray()) {
                    Object object3 = object2;
                    Class<?> clazz = object2.getClass().getComponentType();
                    n3 = n32 ^ (clazz.equals(Byte.TYPE) ? Arrays.hashCode((byte[])object3) : (clazz.equals(Short.TYPE) ? Arrays.hashCode((short[])object3) : (clazz.equals(Integer.TYPE) ? Arrays.hashCode((int[])object3) : (clazz.equals(Character.TYPE) ? Arrays.hashCode((char[])object3) : (clazz.equals(Long.TYPE) ? Arrays.hashCode((long[])object3) : (clazz.equals(Float.TYPE) ? Arrays.hashCode((float[])object3) : (clazz.equals(Double.TYPE) ? Arrays.hashCode((double[])object3) : (clazz.equals(Boolean.TYPE) ? Arrays.hashCode((boolean[])object3) : Arrays.hashCode((Object[])object3)))))))));
                } else {
                    n3 = object2 instanceof Annotation ? n32 ^ AnnotationUtils.hashCode((Annotation)object2) : n32 ^ object2.hashCode();
                }
                n2 += n3;
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return n2;
    }

    public static String toString(Annotation object) {
        ToStringBuilder toStringBuilder = new ToStringBuilder(object, a);
        for (Method method : object.annotationType().getDeclaredMethods()) {
            if (method.getParameterTypes().length > 0) continue;
            try {
                toStringBuilder.append(method.getName(), method.invoke(object, new Object[0]));
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return toStringBuilder.build();
    }

    public static boolean isValidAnnotationMemberType(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz.isPrimitive() || clazz.isEnum() || clazz.isAnnotation() || String.class.equals(clazz) || Class.class.equals(clazz);
    }
}

