/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

public class BitField {
    private final int a;
    private final int b;

    public BitField(int n2) {
        this.a = n2;
        this.b = n2 == 0 ? 0 : Integer.numberOfTrailingZeros(n2);
    }

    public int getValue(int n2) {
        return this.getRawValue(n2) >> this.b;
    }

    public short getShortValue(short s2) {
        return (short)this.getValue(s2);
    }

    public int getRawValue(int n2) {
        return n2 & this.a;
    }

    public short getShortRawValue(short s2) {
        return (short)this.getRawValue(s2);
    }

    public boolean isSet(int n2) {
        return (n2 & this.a) != 0;
    }

    public boolean isAllSet(int n2) {
        return (n2 & this.a) == this.a;
    }

    public int setValue(int n2, int n3) {
        return n2 & ~this.a | n3 << this.b & this.a;
    }

    public short setShortValue(short s2, short s3) {
        return (short)this.setValue(s2, s3);
    }

    public int clear(int n2) {
        return n2 & ~this.a;
    }

    public short clearShort(short s2) {
        return (short)this.clear(s2);
    }

    public byte clearByte(byte by) {
        return (byte)this.clear(by);
    }

    public int set(int n2) {
        return n2 | this.a;
    }

    public short setShort(short s2) {
        return (short)this.set(s2);
    }

    public byte setByte(byte by) {
        return (byte)this.set(by);
    }

    public int setBoolean(int n2, boolean bl2) {
        if (bl2) {
            return this.set(n2);
        }
        return this.clear(n2);
    }

    public short setShortBoolean(short s2, boolean bl2) {
        if (bl2) {
            return this.setShort(s2);
        }
        return this.clearShort(s2);
    }

    public byte setByteBoolean(byte by, boolean bl2) {
        if (bl2) {
            return this.setByte(by);
        }
        return this.clearByte(by);
    }
}

