/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.a;

public class CharSet
implements Serializable {
    public static final CharSet EMPTY = new CharSet(new String[]{null});
    public static final CharSet ASCII_ALPHA = new CharSet("a-zA-Z");
    public static final CharSet ASCII_ALPHA_LOWER = new CharSet("a-z");
    public static final CharSet ASCII_ALPHA_UPPER = new CharSet("A-Z");
    public static final CharSet ASCII_NUMERIC = new CharSet("0-9");
    protected static final Map<String, CharSet> COMMON = Collections.synchronizedMap(new HashMap());
    private final Set<a> a = Collections.synchronizedSet(new HashSet());

    public static CharSet getInstance(String ... stringArray) {
        CharSet charSet;
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 1 && (charSet = COMMON.get(stringArray[0])) != null) {
            return charSet;
        }
        return new CharSet(stringArray);
    }

    protected CharSet(String ... stringArray) {
        for (String string : stringArray) {
            this.add(string);
        }
    }

    protected void add(String string) {
        if (string == null) {
            return;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n2 - n3;
            if (n4 >= 4 && string.charAt(n3) == '^' && string.charAt(n3 + 2) == '-') {
                this.a.add(org.apache.commons.lang3.a.b(string.charAt(n3 + 1), string.charAt(n3 + 3)));
                n3 += 4;
                continue;
            }
            if (n4 >= 3 && string.charAt(n3 + 1) == '-') {
                this.a.add(org.apache.commons.lang3.a.a(string.charAt(n3), string.charAt(n3 + 2)));
                n3 += 3;
                continue;
            }
            if (n4 >= 2 && string.charAt(n3) == '^') {
                this.a.add(org.apache.commons.lang3.a.b(string.charAt(n3 + 1)));
                n3 += 2;
                continue;
            }
            this.a.add(org.apache.commons.lang3.a.a(string.charAt(n3)));
            ++n3;
        }
    }

    public boolean contains(char c2) {
        Set<a> set = this.a;
        synchronized (set) {
            for (a a2 : this.a) {
                if (!a2.c(c2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CharSet)) {
            return false;
        }
        object = (CharSet)object;
        return this.a.equals(((CharSet)object).a);
    }

    public int hashCode() {
        return 89 + this.a.hashCode();
    }

    public String toString() {
        return this.a.toString();
    }

    static {
        COMMON.put(null, EMPTY);
        COMMON.put("", EMPTY);
        COMMON.put("a-zA-Z", ASCII_ALPHA);
        COMMON.put("A-Za-z", ASCII_ALPHA);
        COMMON.put("a-z", ASCII_ALPHA_LOWER);
        COMMON.put("A-Z", ASCII_ALPHA_UPPER);
        COMMON.put("0-9", ASCII_NUMERIC);
    }
}

