/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class EnumUtils {
    private static <E extends Enum<E>> Class<E> a(Class<E> clazz) {
        Validate.notNull(clazz, "EnumClass must be defined.", new Object[0]);
        Validate.isTrue(clazz.isEnum(), "%s does not seem to be an Enum type", clazz);
        return clazz;
    }

    private static <E extends Enum<E>> Class<E> b(Class<E> clazz) {
        Enum[] enumArray = (Enum[])EnumUtils.a(clazz).getEnumConstants();
        Validate.isTrue(enumArray.length <= 64, "Cannot store %s %s values in %s bits", enumArray.length, clazz.getSimpleName(), 64);
        return clazz;
    }

    @SafeVarargs
    public static <E extends Enum<E>> long generateBitVector(Class<E> clazz, E ... EArray) {
        Validate.noNullElements(EArray);
        return EnumUtils.generateBitVector(clazz, Arrays.asList(EArray));
    }

    public static <E extends Enum<E>> long generateBitVector(Class<E> object, Iterable<? extends E> object2) {
        EnumUtils.b(object);
        Validate.notNull(object2);
        long l2 = 0L;
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (Enum)object.next();
            Validate.notNull(object2, "null elements not permitted", new Object[0]);
            l2 |= 1L << ((Enum)object2).ordinal();
        }
        return l2;
    }

    @SafeVarargs
    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> object, E ... object2) {
        EnumUtils.a(object);
        Validate.noNullElements(object2);
        Object object3 = EnumSet.noneOf(object);
        Collections.addAll(object3, object2);
        object = new long[(((Enum[])((Class)object).getEnumConstants()).length - 1) / 64 + 1];
        object2 = ((AbstractCollection)object3).iterator();
        while (object2.hasNext()) {
            object3 = (Enum)object2.next();
            Object object4 = object;
            int n2 = ((Enum)object3).ordinal() / 64;
            object4[n2] = object4[n2] | 1L << ((Enum)object3).ordinal() % 64;
        }
        ArrayUtils.reverse((long[])object);
        return object;
    }

    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> object3, Iterable<? extends E> object2) {
        Object object;
        EnumUtils.a(object3);
        Validate.notNull(object);
        EnumSet<Enum> enumSet = EnumSet.noneOf(object3);
        object = object.iterator();
        while (object.hasNext()) {
            Enum enum_ = (Enum)object.next();
            Validate.notNull(enum_, "null elements not permitted", new Object[0]);
            enumSet.add(enum_);
        }
        object = new long[(((Enum[])((Class)object3).getEnumConstants()).length - 1) / 64 + 1];
        for (Enum enum_ : enumSet) {
            Object object4 = object;
            int n2 = enum_.ordinal() / 64;
            object4[n2] = object4[n2] | 1L << enum_.ordinal() % 64;
        }
        ArrayUtils.reverse((long[])object);
        return object;
    }

    public static <E extends Enum<E>> E getEnum(Class<E> clazz, String string) {
        return EnumUtils.getEnum(clazz, string, null);
    }

    public static <E extends Enum<E>> E getEnum(Class<E> clazz, String string, E e2) {
        if (string == null) {
            return e2;
        }
        try {
            return Enum.valueOf(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return e2;
        }
    }

    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> clazz, String string) {
        return EnumUtils.getEnumIgnoreCase(clazz, string, null);
    }

    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> enumArray, String string, E e2) {
        if (string == null || !enumArray.isEnum()) {
            return e2;
        }
        for (Enum enum_ : (Enum[])enumArray.getEnumConstants()) {
            if (!enum_.name().equalsIgnoreCase(string)) continue;
            return (E)enum_;
        }
        return e2;
    }

    public static <E extends Enum<E>> List<E> getEnumList(Class<E> clazz) {
        return new ArrayList<E>(Arrays.asList(clazz.getEnumConstants()));
    }

    public static <E extends Enum<E>> Map<String, E> getEnumMap(Class<E> enumArray) {
        LinkedHashMap<String, Enum> linkedHashMap = new LinkedHashMap<String, Enum>();
        for (Enum enum_ : (Enum[])enumArray.getEnumConstants()) {
            linkedHashMap.put(enum_.name(), enum_);
        }
        return linkedHashMap;
    }

    public static <E extends Enum<E>> boolean isValidEnum(Class<E> clazz, String string) {
        return EnumUtils.getEnum(clazz, string) != null;
    }

    public static <E extends Enum<E>> boolean isValidEnumIgnoreCase(Class<E> clazz, String string) {
        return EnumUtils.getEnumIgnoreCase(clazz, string) != null;
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVector(Class<E> clazz, long l2) {
        EnumUtils.b(clazz).getEnumConstants();
        return EnumUtils.processBitVectors(clazz, l2);
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVectors(Class<E> enumArray, long ... lArray) {
        EnumSet<Enum> enumSet = EnumSet.noneOf(EnumUtils.a(enumArray));
        lArray = ArrayUtils.clone(Validate.notNull(lArray));
        ArrayUtils.reverse(lArray);
        for (Enum enum_ : (Enum[])enumArray.getEnumConstants()) {
            int n2 = enum_.ordinal() / 64;
            if (n2 >= lArray.length || (lArray[n2] & 1L << enum_.ordinal() % 64) == 0L) continue;
            enumSet.add(enum_);
        }
        return enumSet;
    }
}

