/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang3.Validate;

public final class Range<T>
implements Serializable {
    private final Comparator<T> a;
    private transient int b;
    private final T c;
    private final T d;
    private transient String e;

    public static <T extends Comparable<T>> Range<T> between(T t2, T t3) {
        return Range.between(t2, t3, null);
    }

    public static <T> Range<T> between(T t2, T t3, Comparator<T> comparator) {
        return new Range<T>(t2, t3, comparator);
    }

    public static <T extends Comparable<T>> Range<T> is(T t2) {
        T t3 = t2;
        return Range.between(t3, t3, null);
    }

    public static <T> Range<T> is(T t2, Comparator<T> comparator) {
        T t3 = t2;
        return Range.between(t3, t3, comparator);
    }

    private Range(T t2, T t3, Comparator<T> comparator) {
        if (t2 == null || t3 == null) {
            throw new IllegalArgumentException("Elements in a range must not be null: element1=" + t2 + ", element2=" + t3);
        }
        this.a = comparator == null ? org.apache.commons.lang3.Range$a.a : comparator;
        if (this.a.compare(t2, t3) <= 0) {
            this.d = t2;
            this.c = t3;
            return;
        }
        this.d = t3;
        this.c = t2;
    }

    public final boolean contains(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.a.compare(t2, this.d) >= 0 && this.a.compare(t2, this.c) <= 0;
    }

    public final boolean containsRange(Range<T> range) {
        if (range == null) {
            return false;
        }
        return this.contains(range.d) && this.contains(range.c);
    }

    public final int elementCompareTo(T t2) {
        Validate.notNull(t2, "element", new Object[0]);
        if (this.isAfter(t2)) {
            return -1;
        }
        if (this.isBefore(t2)) {
            return 1;
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        object = (Range)object;
        return this.d.equals(((Range)object).d) && this.c.equals(((Range)object).c);
    }

    public final Comparator<T> getComparator() {
        return this.a;
    }

    public final T getMaximum() {
        return this.c;
    }

    public final T getMinimum() {
        return this.d;
    }

    public final int hashCode() {
        int n2 = this.b;
        if (this.b == 0) {
            n2 = 629 + this.getClass().hashCode();
            n2 = n2 * 37 + this.d.hashCode();
            this.b = n2 = n2 * 37 + this.c.hashCode();
        }
        return n2;
    }

    public final Range<T> intersectionWith(Range<T> range) {
        if (!this.isOverlappedBy(range)) {
            throw new IllegalArgumentException(String.format("Cannot calculate intersection with non-overlapping range %s", range));
        }
        if (this.equals(range)) {
            return this;
        }
        T t2 = this.getComparator().compare(this.d, range.d) < 0 ? range.d : this.d;
        range = this.getComparator().compare(this.c, range.c) < 0 ? this.c : range.c;
        return Range.between(t2, range, this.getComparator());
    }

    public final boolean isAfter(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.a.compare(t2, this.d) < 0;
    }

    public final boolean isAfterRange(Range<T> range) {
        if (range == null) {
            return false;
        }
        return this.isAfter(range.c);
    }

    public final boolean isBefore(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.a.compare(t2, this.c) > 0;
    }

    public final boolean isBeforeRange(Range<T> range) {
        if (range == null) {
            return false;
        }
        return this.isBefore(range.d);
    }

    public final boolean isEndedBy(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.a.compare(t2, this.c) == 0;
    }

    public final boolean isNaturalOrdering() {
        return this.a == org.apache.commons.lang3.Range$a.a;
    }

    public final boolean isOverlappedBy(Range<T> range) {
        if (range == null) {
            return false;
        }
        return range.contains(this.d) || range.contains(this.c) || this.contains(range.d);
    }

    public final boolean isStartedBy(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.a.compare(t2, this.d) == 0;
    }

    public final T fit(T t2) {
        Validate.notNull(t2, "element", new Object[0]);
        if (this.isAfter(t2)) {
            return this.d;
        }
        if (this.isBefore(t2)) {
            return this.c;
        }
        return t2;
    }

    public final String toString() {
        if (this.e == null) {
            this.e = "[" + this.d + ".." + this.c + "]";
        }
        return this.e;
    }

    public final String toString(String string) {
        return String.format(string, this.d, this.c, this.a);
    }

    /*
     * Exception performing whole class analysis.
     */
    private static final class a
    extends Enum<a>
    implements Comparator {
        public final int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    }
}

