/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.Validate;

public class SerializationUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T clone(T object) {
        if (object == null) {
            return null;
        }
        Object object2 = SerializationUtils.serialize((Serializable)object);
        object2 = new ByteArrayInputStream((byte[])object2);
        try {
            Serializable serializable;
            object = new a((InputStream)object2, object.getClass().getClassLoader());
            object2 = null;
            try {
                serializable = (Serializable)((ObjectInputStream)object).readObject();
            }
            catch (Throwable throwable) {
                try {
                    Throwable throwable2 = throwable;
                    object2 = throwable;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (object2 == null) {
                        ((ObjectInputStream)object).close();
                        throw throwable3;
                    }
                    try {
                        ((ObjectInputStream)object).close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        ((Throwable)object2).addSuppressed(throwable4);
                        throw throwable3;
                    }
                }
            }
            ((ObjectInputStream)object).close();
            return (T)serializable;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SerializationException("ClassNotFoundException while reading cloned object data", classNotFoundException);
        }
        catch (IOException iOException) {
            throw new SerializationException("IOException while reading or closing cloned object data", iOException);
        }
    }

    public static <T> T deserialize(byte[] byArray) {
        Validate.notNull(byArray, "objectData", new Object[0]);
        return SerializationUtils.deserialize(new ByteArrayInputStream(byArray));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(InputStream inputStream) {
        Validate.notNull(inputStream, "inputStream", new Object[0]);
        try {
            Object object;
            inputStream = new ObjectInputStream(inputStream);
            Throwable throwable = null;
            try {
                object = ((ObjectInputStream)inputStream).readObject();
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        ((ObjectInputStream)inputStream).close();
                        throw throwable4;
                    }
                    try {
                        ((ObjectInputStream)inputStream).close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw throwable4;
                    }
                }
            }
            ((ObjectInputStream)inputStream).close();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new SerializationException(exception);
        }
    }

    public static <T extends Serializable> T roundtrip(T t2) {
        return (T)((Serializable)SerializationUtils.deserialize(SerializationUtils.serialize(t2)));
    }

    public static byte[] serialize(Serializable serializable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        SerializationUtils.serialize(serializable, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void serialize(Serializable serializable, OutputStream outputStream) {
        Validate.notNull(outputStream, "outputStream", new Object[0]);
        try {
            outputStream = new ObjectOutputStream(outputStream);
            Throwable throwable = null;
            try {
                ((ObjectOutputStream)outputStream).writeObject(serializable);
            }
            catch (Throwable throwable2) {
                try {
                    serializable = throwable2;
                    throwable = throwable2;
                    throw serializable;
                }
                catch (Throwable throwable3) {
                    if (throwable != null) {
                        try {
                            ((ObjectOutputStream)outputStream).close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ((ObjectOutputStream)outputStream).close();
                    }
                    throw throwable3;
                }
            }
            ((ObjectOutputStream)outputStream).close();
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    static final class a
    extends ObjectInputStream {
        private static final Map<String, Class<?>> a = new HashMap();
        private final ClassLoader b;

        a(InputStream inputStream, ClassLoader classLoader) {
            super(inputStream);
            this.b = classLoader;
        }

        @Override
        protected final Class<?> resolveClass(ObjectStreamClass clazz) {
            clazz = ((ObjectStreamClass)((Object)clazz)).getName();
            try {
                return Class.forName((String)((Object)clazz), false, this.b);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    return Class.forName((String)((Object)clazz), false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    clazz = a.get(clazz);
                    if (clazz != null) {
                        return clazz;
                    }
                    throw classNotFoundException2;
                }
            }
        }

        static {
            a.put("byte", Byte.TYPE);
            a.put("short", Short.TYPE);
            a.put("int", Integer.TYPE);
            a.put("long", Long.TYPE);
            a.put("float", Float.TYPE);
            a.put("double", Double.TYPE);
            a.put("boolean", Boolean.TYPE);
            a.put("char", Character.TYPE);
            a.put("void", Void.TYPE);
        }
    }
}

