/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.CharSequenceUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.b;
import org.apache.commons.lang3.function.ToBooleanBiFunction;

public class StringUtils {
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String LF = "\n";
    public static final String CR = "\r";
    public static final int INDEX_NOT_FOUND = -1;
    private static final Pattern a = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");

    public static String abbreviate(String string, int n2) {
        return StringUtils.abbreviate(string, "...", 0, n2);
    }

    public static String abbreviate(String string, int n2, int n3) {
        return StringUtils.abbreviate(string, "...", n2, n3);
    }

    public static String abbreviate(String string, String string2, int n2) {
        return StringUtils.abbreviate(string, string2, 0, n2);
    }

    public static String abbreviate(String string, String string2, int n2, int n3) {
        if (StringUtils.isNotEmpty(string) && EMPTY.equals(string2) && n3 > 0) {
            return StringUtils.substring(string, 0, n3);
        }
        if (StringUtils.isAnyEmpty(string, string2)) {
            return string;
        }
        int n4 = string2.length();
        int n5 = n4 + 1;
        int n6 = n4;
        int n7 = n6 + n6 + 1;
        if (n3 < n5) {
            throw new IllegalArgumentException(String.format("Minimum abbreviation width is %d", n5));
        }
        int n8 = string.length();
        if (n8 <= n3) {
            return string;
        }
        if (n2 > n8) {
            n2 = n8;
        }
        if (n8 - n2 < n3 - n4) {
            n2 = n8 - (n3 - n4);
        }
        if (n2 <= n5) {
            return string.substring(0, n3 - n4) + string2;
        }
        if (n3 < n7) {
            throw new IllegalArgumentException(String.format("Minimum abbreviation width with offset is %d", n7));
        }
        if (n2 + n3 - n4 < n8) {
            return string2 + StringUtils.abbreviate(string.substring(n2), string2, n3 - n4);
        }
        return string2 + string.substring(n8 - (n3 - n4));
    }

    public static String abbreviateMiddle(String string, String string2, int n2) {
        if (StringUtils.isAnyEmpty(string, string2) || n2 >= string.length() || n2 < string2.length() + 2) {
            return string;
        }
        int n3 = (n2 -= string2.length()) / 2 + n2 % 2;
        n2 = string.length() - n2 / 2;
        return string.substring(0, n3) + string2 + string.substring(n2);
    }

    private static String a(String string, CharSequence charSequence, boolean bl2, CharSequence ... charSequenceArray) {
        if (string == null || StringUtils.isEmpty(charSequence) || StringUtils.a((CharSequence)string, charSequence, bl2)) {
            return string;
        }
        if (ArrayUtils.isNotEmpty(charSequenceArray)) {
            for (CharSequence charSequence2 : charSequenceArray) {
                if (!StringUtils.a((CharSequence)string, charSequence2, bl2)) continue;
                return string;
            }
        }
        return string + charSequence.toString();
    }

    public static String appendIfMissing(String string, CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StringUtils.a(string, charSequence, false, charSequenceArray);
    }

    public static String appendIfMissingIgnoreCase(String string, CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StringUtils.a(string, charSequence, true, charSequenceArray);
    }

    public static String capitalize(String string) {
        int n2;
        int n3 = StringUtils.length(string);
        if (n3 == 0) {
            return string;
        }
        int n4 = string.codePointAt(0);
        if (n4 == (n2 = Character.toTitleCase(n4))) {
            return string;
        }
        int[] nArray = new int[n3];
        int n5 = 0;
        ++n5;
        nArray[0] = n2;
        for (n4 = Character.charCount(n4); n4 < n3; n4 += Character.charCount(n2)) {
            n2 = string.codePointAt(n4);
            nArray[n5++] = n2;
        }
        return new String(nArray, 0, n5);
    }

    public static String center(String string, int n2) {
        return StringUtils.center(string, n2, ' ');
    }

    public static String center(String string, int n2, char c2) {
        if (string == null || n2 <= 0) {
            return string;
        }
        int n3 = string.length();
        int n4 = n2 - n3;
        if (n4 <= 0) {
            return string;
        }
        string = StringUtils.leftPad(string, n3 + n4 / 2, c2);
        string = StringUtils.rightPad(string, n2, c2);
        return string;
    }

    public static String center(String string, int n2, String string2) {
        int n3;
        int n4;
        if (string == null || n2 <= 0) {
            return string;
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = SPACE;
        }
        if ((n4 = n2 - (n3 = string.length())) <= 0) {
            return string;
        }
        string = StringUtils.leftPad(string, n3 + n4 / 2, string2);
        string = StringUtils.rightPad(string, n2, string2);
        return string;
    }

    public static String chomp(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (string.length() == 1) {
            char c2 = string.charAt(0);
            if (c2 == '\r' || c2 == '\n') {
                return EMPTY;
            }
            return string;
        }
        int n2 = string.length() - 1;
        char c3 = string.charAt(n2);
        if (c3 == '\n') {
            if (string.charAt(n2 - 1) == '\r') {
                --n2;
            }
        } else if (c3 != '\r') {
            ++n2;
        }
        return string.substring(0, n2);
    }

    @Deprecated
    public static String chomp(String string, String string2) {
        return StringUtils.removeEnd(string, string2);
    }

    public static String chop(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 < 2) {
            return EMPTY;
        }
        String string2 = string.substring(0, --n2);
        char c2 = string.charAt(n2);
        if (c2 == '\n' && string2.charAt(n2 - 1) == '\r') {
            return string2.substring(0, n2 - 1);
        }
        return string2;
    }

    public static int compare(String string, String string2) {
        return StringUtils.compare(string, string2, true);
    }

    public static int compare(String string, String string2, boolean bl2) {
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            if (bl2) {
                return -1;
            }
            return 1;
        }
        if (string2 == null) {
            if (bl2) {
                return 1;
            }
            return -1;
        }
        return string.compareTo(string2);
    }

    public static int compareIgnoreCase(String string, String string2) {
        return StringUtils.compareIgnoreCase(string, string2, true);
    }

    public static int compareIgnoreCase(String string, String string2, boolean bl2) {
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            if (bl2) {
                return -1;
            }
            return 1;
        }
        if (string2 == null) {
            if (bl2) {
                return 1;
            }
            return -1;
        }
        return string.compareToIgnoreCase(string2);
    }

    public static boolean contains(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        return CharSequenceUtils.a(charSequence, charSequence2, 0) >= 0;
    }

    public static boolean contains(CharSequence charSequence, int n2) {
        if (StringUtils.isEmpty(charSequence)) {
            return false;
        }
        return CharSequenceUtils.a(charSequence, n2, 0) >= 0;
    }

    public static boolean containsAny(CharSequence charSequence, char ... cArray) {
        if (StringUtils.isEmpty(charSequence) || ArrayUtils.isEmpty(cArray)) {
            return false;
        }
        int n2 = charSequence.length();
        int n3 = cArray.length;
        int n4 = n2 - 1;
        int n5 = n3 - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            for (int i3 = 0; i3 < n3; ++i3) {
                if (cArray[i3] != c2) continue;
                if (Character.isHighSurrogate(c2)) {
                    if (i3 == n5) {
                        return true;
                    }
                    if (i2 >= n4 || cArray[i3 + 1] != charSequence.charAt(i2 + 1)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence2 == null) {
            return false;
        }
        return StringUtils.containsAny(charSequence, CharSequenceUtils.toCharArray(charSequence2));
    }

    public static boolean containsAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StringUtils.a(StringUtils::contains, charSequence, charSequenceArray);
    }

    private static boolean a(ToBooleanBiFunction<CharSequence, CharSequence> toBooleanBiFunction, CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (StringUtils.isEmpty(charSequence) || ArrayUtils.isEmpty(charSequenceArray)) {
            return false;
        }
        for (CharSequence charSequence2 : charSequenceArray) {
            if (!toBooleanBiFunction.applyAsBoolean(charSequence, charSequence2)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyIgnoreCase(CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StringUtils.a(StringUtils::containsIgnoreCase, charSequence, charSequenceArray);
    }

    public static boolean containsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        int n2 = charSequence2.length();
        int n3 = charSequence.length() - n2;
        for (int i2 = 0; i2 <= n3; ++i2) {
            if (!CharSequenceUtils.a(charSequence, true, i2, charSequence2, 0, n2)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNone(CharSequence charSequence, char ... cArray) {
        if (charSequence == null || cArray == null) {
            return true;
        }
        int n2 = charSequence.length();
        int n3 = n2 - 1;
        int n4 = cArray.length;
        int n5 = n4 - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            for (int i3 = 0; i3 < n4; ++i3) {
                if (cArray[i3] != c2) continue;
                if (Character.isHighSurrogate(c2)) {
                    if (i3 == n5) {
                        return false;
                    }
                    if (i2 >= n3 || cArray[i3 + 1] != charSequence.charAt(i2 + 1)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean containsNone(CharSequence charSequence, String string) {
        if (string == null) {
            return true;
        }
        return StringUtils.containsNone(charSequence, string.toCharArray());
    }

    public static boolean containsOnly(CharSequence charSequence, char ... cArray) {
        if (cArray == null || charSequence == null) {
            return false;
        }
        if (charSequence.length() == 0) {
            return true;
        }
        if (cArray.length == 0) {
            return false;
        }
        return StringUtils.indexOfAnyBut(charSequence, cArray) == -1;
    }

    public static boolean containsOnly(CharSequence charSequence, String string) {
        if (charSequence == null || string == null) {
            return false;
        }
        return StringUtils.containsOnly(charSequence, string.toCharArray());
    }

    public static boolean containsWhitespace(CharSequence charSequence) {
        if (StringUtils.isEmpty(charSequence)) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Character.isWhitespace(charSequence.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static int countMatches(CharSequence charSequence, char c2) {
        if (StringUtils.isEmpty(charSequence)) {
            return 0;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (c2 != charSequence.charAt(i2)) continue;
            ++n2;
        }
        return n2;
    }

    public static int countMatches(CharSequence charSequence, CharSequence charSequence2) {
        if (StringUtils.isEmpty(charSequence) || StringUtils.isEmpty(charSequence2)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while ((n3 = CharSequenceUtils.a(charSequence, charSequence2, n3)) != -1) {
            ++n2;
            n3 += charSequence2.length();
        }
        return n2;
    }

    public static <T extends CharSequence> T defaultIfBlank(T t2, T t3) {
        if (StringUtils.isBlank(t2)) {
            return t3;
        }
        return t2;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T t2, T t3) {
        if (StringUtils.isEmpty(t2)) {
            return t3;
        }
        return t2;
    }

    public static String defaultString(String string) {
        return StringUtils.defaultString(string, EMPTY);
    }

    public static String defaultString(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string;
    }

    public static String deleteWhitespace(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            cArray[n3++] = string.charAt(i2);
        }
        if (n3 == n2) {
            return string;
        }
        if (n3 == 0) {
            return EMPTY;
        }
        return new String(cArray, 0, n3);
    }

    public static String difference(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n2 = StringUtils.indexOfDifference((CharSequence)string, (CharSequence)string2);
        if (n2 == -1) {
            return EMPTY;
        }
        return string2.substring(n2);
    }

    public static boolean endsWith(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtils.a(charSequence, charSequence2, false);
    }

    private static boolean a(CharSequence charSequence, CharSequence charSequence2, boolean bl2) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == charSequence2;
        }
        if (charSequence2.length() > charSequence.length()) {
            return false;
        }
        int n2 = charSequence.length() - charSequence2.length();
        return CharSequenceUtils.a(charSequence, bl2, n2, charSequence2, 0, charSequence2.length());
    }

    public static boolean endsWithAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (StringUtils.isEmpty(charSequence) || ArrayUtils.isEmpty(charSequenceArray)) {
            return false;
        }
        for (CharSequence charSequence2 : charSequenceArray) {
            if (!StringUtils.endsWith(charSequence, charSequence2)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtils.a(charSequence, charSequence2, true);
    }

    public static boolean equals(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == charSequence2) {
            return true;
        }
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        if (charSequence instanceof String && charSequence2 instanceof String) {
            return charSequence.equals(charSequence2);
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (charSequence.charAt(i2) == charSequence2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (ArrayUtils.isNotEmpty(charSequenceArray)) {
            for (CharSequence charSequence2 : charSequenceArray) {
                if (!StringUtils.equals(charSequence, charSequence2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equalsAnyIgnoreCase(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (ArrayUtils.isNotEmpty(charSequenceArray)) {
            for (CharSequence charSequence2 : charSequenceArray) {
                if (!StringUtils.equalsIgnoreCase(charSequence, charSequence2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equalsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == charSequence2) {
            return true;
        }
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        return CharSequenceUtils.a(charSequence, true, 0, charSequence2, 0, charSequence.length());
    }

    @SafeVarargs
    public static <T extends CharSequence> T firstNonBlank(T ... TArray) {
        if (TArray != null) {
            for (T t2 : TArray) {
                if (!StringUtils.isNotBlank(t2)) continue;
                return t2;
            }
        }
        return null;
    }

    @SafeVarargs
    public static <T extends CharSequence> T firstNonEmpty(T ... TArray) {
        if (TArray != null) {
            for (T t2 : TArray) {
                if (!StringUtils.isNotEmpty(t2)) continue;
                return t2;
            }
        }
        return null;
    }

    public static byte[] getBytes(String string, Charset charset) {
        if (string == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        return string.getBytes(b.a(charset));
    }

    public static byte[] getBytes(String string, String string2) {
        if (string == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        return string.getBytes((string = string2) == null ? Charset.defaultCharset().name() : string);
    }

    public static String getCommonPrefix(String ... stringArray) {
        if (ArrayUtils.isEmpty(stringArray)) {
            return EMPTY;
        }
        int n2 = StringUtils.indexOfDifference(stringArray);
        if (n2 == -1) {
            if (stringArray[0] == null) {
                return EMPTY;
            }
            return stringArray[0];
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return stringArray[0].substring(0, n2);
    }

    public static String getDigits(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (!Character.isDigit(c2)) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static int getFuzzyDistance(CharSequence charSequence, CharSequence charSequence2, Locale locale) {
        if (charSequence == null || charSequence2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null");
        }
        charSequence = charSequence.toString().toLowerCase(locale);
        charSequence2 = charSequence2.toString().toLowerCase(locale);
        int n2 = 0;
        int n3 = 0;
        int n4 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < ((String)charSequence2).length(); ++i2) {
            char c2 = ((String)charSequence2).charAt(i2);
            boolean bl2 = false;
            while (n3 < ((String)charSequence).length() && !bl2) {
                char c3 = ((String)charSequence).charAt(n3);
                if (c2 == c3) {
                    ++n2;
                    if (n4 + 1 == n3) {
                        n2 += 2;
                    }
                    n4 = n3;
                    bl2 = true;
                }
                ++n3;
            }
        }
        return n2;
    }

    public static <T extends CharSequence> T getIfBlank(T t2, Supplier<T> supplier) {
        if (StringUtils.isBlank(t2)) {
            if (supplier == null) {
                return null;
            }
            return (T)((CharSequence)supplier.get());
        }
        return t2;
    }

    public static <T extends CharSequence> T getIfEmpty(T t2, Supplier<T> supplier) {
        if (StringUtils.isEmpty(t2)) {
            if (supplier == null) {
                return null;
            }
            return (T)((CharSequence)supplier.get());
        }
        return t2;
    }

    @Deprecated
    public static double getJaroWinklerDistance(CharSequence charSequence, CharSequence charSequence2) {
        double d2;
        int n2;
        int n3;
        CharSequence charSequence3;
        CharSequence charSequence4;
        if (charSequence == null || charSequence2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        CharSequence charSequence5 = charSequence2;
        Object object = charSequence;
        if (object.length() > charSequence5.length()) {
            charSequence4 = object;
            charSequence3 = charSequence5;
        } else {
            charSequence4 = charSequence5;
            charSequence3 = object;
        }
        int n4 = Math.max(charSequence4.length() / 2 - 1, 0);
        int[] nArray = new int[charSequence3.length()];
        Arrays.fill(nArray, -1);
        boolean[] blArray = new boolean[charSequence4.length()];
        int n5 = 0;
        block0: for (int i2 = 0; i2 < charSequence3.length(); ++i2) {
            char c2 = charSequence3.charAt(i2);
            n3 = Math.min(i2 + n4 + 1, charSequence4.length());
            for (n2 = Math.max(i2 - n4, 0); n2 < n3; ++n2) {
                if (blArray[n2] || c2 != charSequence4.charAt(n2)) continue;
                nArray[i2] = n2;
                blArray[n2] = true;
                ++n5;
                continue block0;
            }
        }
        char[] cArray = new char[n5];
        char[] cArray2 = new char[n5];
        n3 = 0;
        for (n2 = 0; n2 < charSequence3.length(); ++n2) {
            if (nArray[n2] == -1) continue;
            cArray[n3] = charSequence3.charAt(n2);
            ++n3;
        }
        n3 = 0;
        for (n2 = 0; n2 < charSequence4.length(); ++n2) {
            if (!blArray[n2]) continue;
            cArray2[n3] = charSequence4.charAt(n2);
            ++n3;
        }
        n2 = 0;
        for (n3 = 0; n3 < cArray.length; ++n3) {
            if (cArray[n3] == cArray2[n3]) continue;
            ++n2;
        }
        n3 = 0;
        for (n4 = 0; n4 < charSequence3.length() && object.charAt(n4) == charSequence5.charAt(n4); ++n4) {
            ++n3;
        }
        int[] nArray2 = new int[]{n5, n2 / 2, n3, charSequence4.length()};
        object = nArray2;
        double d3 = nArray2[0];
        if (d3 == 0.0) {
            return 0.0;
        }
        double d4 = (d3 / (double)charSequence.length() + d3 / (double)charSequence2.length() + (d3 - (double)object[1]) / d3) / 3.0;
        double d5 = d2 < 0.7 ? d4 : d4 + Math.min(0.1, 1.0 / (double)object[3]) * (double)object[2] * (1.0 - d4);
        return (double)Math.round(d5 * 100.0) / 100.0;
    }

    @Deprecated
    public static int getLevenshteinDistance(CharSequence charSequence, CharSequence charSequence2) {
        Object object;
        if (charSequence == null || charSequence2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n2 = charSequence.length();
        int n3 = charSequence2.length();
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        if (n2 > n3) {
            object = charSequence;
            charSequence = charSequence2;
            charSequence2 = object;
            n2 = n3;
            n3 = charSequence2.length();
        }
        object = new int[n2 + 1];
        int n4 = 0;
        while (n4 <= n2) {
            int n5 = n4++;
            object[n5] = n5;
        }
        for (int i2 = 1; i2 <= n3; ++i2) {
            Object object2 = object[0];
            char c2 = charSequence2.charAt(i2 - 1);
            object[0] = i2;
            for (n4 = 1; n4 <= n2; ++n4) {
                Object object3 = object[n4];
                boolean bl2 = charSequence.charAt(n4 - 1) != c2;
                object[n4] = Math.min(Math.min((int)(object[n4 - 1] + true), (int)(object[n4] + true)), (int)(object2 + bl2));
                object2 = object3;
            }
        }
        return (int)object[n2];
    }

    @Deprecated
    public static int getLevenshteinDistance(CharSequence charSequence, CharSequence charSequence2, int n2) {
        Object object;
        if (charSequence == null || charSequence2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n3 = charSequence.length();
        int n4 = charSequence2.length();
        if (n3 == 0) {
            if (n4 <= n2) {
                return n4;
            }
            return -1;
        }
        if (n4 == 0) {
            if (n3 <= n2) {
                return n3;
            }
            return -1;
        }
        if (Math.abs(n3 - n4) > n2) {
            return -1;
        }
        if (n3 > n4) {
            object = charSequence;
            charSequence = charSequence2;
            charSequence2 = object;
            n3 = n4;
            n4 = charSequence2.length();
        }
        object = new int[n3 + 1];
        Object object2 = new int[n3 + 1];
        int n5 = Math.min(n3, n2) + 1;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = n6++;
            object[n7] = n7;
        }
        Arrays.fill((int[])object, n5, ((Object)object).length, Integer.MAX_VALUE);
        Arrays.fill(object2, Integer.MAX_VALUE);
        for (n6 = 1; n6 <= n4; ++n6) {
            int n8;
            n5 = charSequence2.charAt(n6 - 1);
            object2[0] = n6;
            int n9 = Math.max(1, n6 - n2);
            int n10 = n8 = n6 > Integer.MAX_VALUE - n2 ? n3 : Math.min(n3, n6 + n2);
            if (n9 > n8) {
                return -1;
            }
            if (n9 > 1) {
                object2[n9 - 1] = Integer.MAX_VALUE;
            }
            while (n9 <= n8) {
                object2[n9] = charSequence.charAt(n9 - 1) == n5 ? (int)object[n9 - 1] : 1 + Math.min(Math.min(object2[n9 - 1], (int)object[n9]), (int)object[n9 - 1]);
                ++n9;
            }
            Object object3 = object;
            object = object2;
            object2 = object3;
        }
        if (object[n3] <= n2) {
            return (int)object[n3];
        }
        return -1;
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        return CharSequenceUtils.a(charSequence, charSequence2, 0);
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n2) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        return CharSequenceUtils.a(charSequence, charSequence2, n2);
    }

    public static int indexOf(CharSequence charSequence, int n2) {
        if (StringUtils.isEmpty(charSequence)) {
            return -1;
        }
        return CharSequenceUtils.a(charSequence, n2, 0);
    }

    public static int indexOf(CharSequence charSequence, int n2, int n3) {
        if (StringUtils.isEmpty(charSequence)) {
            return -1;
        }
        return CharSequenceUtils.a(charSequence, n2, n3);
    }

    public static int indexOfAny(CharSequence charSequence, char ... cArray) {
        if (StringUtils.isEmpty(charSequence) || ArrayUtils.isEmpty(cArray)) {
            return -1;
        }
        int n2 = charSequence.length();
        int n3 = n2 - 1;
        int n4 = cArray.length;
        int n5 = n4 - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            for (int i3 = 0; i3 < n4; ++i3) {
                if (cArray[i3] != c2) continue;
                if (i2 < n3 && i3 < n5 && Character.isHighSurrogate(c2)) {
                    if (cArray[i3 + 1] != charSequence.charAt(i2 + 1)) continue;
                    return i2;
                }
                return i2;
            }
        }
        return -1;
    }

    public static int indexOfAny(CharSequence charSequence, CharSequence ... object) {
        if (charSequence == null || object == null) {
            return -1;
        }
        int n2 = Integer.MAX_VALUE;
        CharSequence[] charSequenceArray = object;
        int n3 = ((CharSequence[])object).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            object = charSequenceArray[i2];
            if (object == null || (n4 = CharSequenceUtils.a(charSequence, (CharSequence)object, 0)) == -1 || n4 >= n2) continue;
            n2 = n4;
        }
        if (n2 == Integer.MAX_VALUE) {
            return -1;
        }
        return n2;
    }

    public static int indexOfAny(CharSequence charSequence, String string) {
        if (StringUtils.isEmpty(charSequence) || StringUtils.isEmpty(string)) {
            return -1;
        }
        return StringUtils.indexOfAny(charSequence, string.toCharArray());
    }

    public static int indexOfAnyBut(CharSequence charSequence, char ... cArray) {
        if (StringUtils.isEmpty(charSequence) || ArrayUtils.isEmpty(cArray)) {
            return -1;
        }
        int n2 = charSequence.length();
        int n3 = n2 - 1;
        int n4 = cArray.length;
        int n5 = n4 - 1;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            for (int i3 = 0; i3 < n4; ++i3) {
                if (cArray[i3] == c2 && (i2 >= n3 || i3 >= n5 || !Character.isHighSurrogate(c2) || cArray[i3 + 1] == charSequence.charAt(i2 + 1))) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int indexOfAnyBut(CharSequence charSequence, CharSequence charSequence2) {
        if (StringUtils.isEmpty(charSequence) || StringUtils.isEmpty(charSequence2)) {
            return -1;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2;
            char c2 = charSequence.charAt(i2);
            boolean bl3 = bl2 = CharSequenceUtils.a(charSequence2, c2, 0) >= 0;
            if (i2 + 1 < n2 && Character.isHighSurrogate(c2)) {
                c2 = charSequence.charAt(i2 + 1);
                if (!bl2 || CharSequenceUtils.a(charSequence2, c2, 0) >= 0) continue;
                return i2;
            }
            if (bl2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOfDifference(CharSequence ... charSequenceArray) {
        int n2;
        if (ArrayUtils.getLength(charSequenceArray) <= 1) {
            return -1;
        }
        boolean bl2 = false;
        boolean bl3 = true;
        int n3 = charSequenceArray.length;
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        CharSequence[] charSequenceArray2 = charSequenceArray;
        int n6 = charSequenceArray.length;
        for (n2 = 0; n2 < n6; ++n2) {
            CharSequence charSequence = charSequenceArray2[n2];
            if (charSequence == null) {
                bl2 = true;
                n4 = 0;
                continue;
            }
            bl3 = false;
            n4 = Math.min(charSequence.length(), n4);
            n5 = Math.max(charSequence.length(), n5);
        }
        if (bl3 || n5 == 0 && !bl2) {
            return -1;
        }
        if (n4 == 0) {
            return 0;
        }
        int n7 = -1;
        for (n6 = 0; n6 < n4; ++n6) {
            n2 = charSequenceArray[0].charAt(n6);
            for (int i2 = 1; i2 < n3; ++i2) {
                if (charSequenceArray[i2].charAt(n6) == n2) continue;
                n7 = n6;
                break;
            }
            if (n7 != -1) break;
        }
        if (n7 == -1 && n4 != n5) {
            return n4;
        }
        return n7;
    }

    public static int indexOfDifference(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        if (charSequence == charSequence2) {
            return -1;
        }
        if (charSequence == null || charSequence2 == null) {
            return 0;
        }
        for (n2 = 0; n2 < charSequence.length() && n2 < charSequence2.length() && charSequence.charAt(n2) == charSequence2.charAt(n2); ++n2) {
        }
        if (n2 < charSequence2.length() || n2 < charSequence.length()) {
            return n2;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtils.indexOfIgnoreCase(charSequence, charSequence2, 0);
    }

    public static int indexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2, int n2) {
        int n3;
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > (n3 = charSequence.length() - charSequence2.length() + 1)) {
            return -1;
        }
        if (charSequence2.length() == 0) {
            return n2;
        }
        while (n2 < n3) {
            if (CharSequenceUtils.a(charSequence, true, n2, charSequence2, 0, charSequence2.length())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static boolean isAllBlank(CharSequence ... charSequenceArray) {
        if (ArrayUtils.isEmpty(charSequenceArray)) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtils.isNotBlank(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllEmpty(CharSequence ... charSequenceArray) {
        if (ArrayUtils.isEmpty(charSequenceArray)) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtils.isNotEmpty(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllLowerCase(CharSequence charSequence) {
        if (StringUtils.isEmpty(charSequence)) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLowerCase(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUpperCase(CharSequence charSequence) {
        if (StringUtils.isEmpty(charSequence)) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isUpperCase(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(CharSequence charSequence) {
        if (StringUtils.isEmpty(charSequence)) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLetter(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(CharSequence charSequence) {
        if (StringUtils.isEmpty(charSequence)) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLetterOrDigit(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 == ' ' || Character.isLetterOrDigit(c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaSpace(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 == ' ' || Character.isLetter(c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyBlank(CharSequence ... charSequenceArray) {
        if (ArrayUtils.isEmpty(charSequenceArray)) {
            return false;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtils.isBlank(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyEmpty(CharSequence ... charSequenceArray) {
        if (ArrayUtils.isEmpty(charSequenceArray)) {
            return false;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtils.isEmpty(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAsciiPrintable(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (CharUtils.isAsciiPrintable(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(CharSequence charSequence) {
        int n2 = StringUtils.length(charSequence);
        if (n2 == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isMixedCase(CharSequence charSequence) {
        if (StringUtils.isEmpty(charSequence) || charSequence.length() == 1) {
            return false;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (bl2 && bl3) {
                return true;
            }
            if (Character.isUpperCase(charSequence.charAt(i2))) {
                bl2 = true;
                continue;
            }
            if (!Character.isLowerCase(charSequence.charAt(i2))) continue;
            bl3 = true;
        }
        return bl2 && bl3;
    }

    public static boolean isNoneBlank(CharSequence ... charSequenceArray) {
        return !StringUtils.isAnyBlank(charSequenceArray);
    }

    public static boolean isNoneEmpty(CharSequence ... charSequenceArray) {
        return !StringUtils.isAnyEmpty(charSequenceArray);
    }

    public static boolean isNotBlank(CharSequence charSequence) {
        return !StringUtils.isBlank(charSequence);
    }

    public static boolean isNotEmpty(CharSequence charSequence) {
        return !StringUtils.isEmpty(charSequence);
    }

    public static boolean isNumeric(CharSequence charSequence) {
        if (StringUtils.isEmpty(charSequence)) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isDigit(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericSpace(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 == ' ' || Character.isDigit(c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static String join(boolean[] blArray, char c2) {
        if (blArray == null) {
            return null;
        }
        return StringUtils.join(blArray, c2, 0, blArray.length);
    }

    public static String join(boolean[] blArray, char c2, int n2, int n3) {
        if (blArray == null) {
            return null;
        }
        if (n3 - n2 <= 0) {
            return EMPTY;
        }
        StringJoiner stringJoiner = StringUtils.a(c2);
        while (n2 < n3) {
            stringJoiner.add(String.valueOf(blArray[n2]));
            ++n2;
        }
        return stringJoiner.toString();
    }

    public static String join(byte[] byArray, char c2) {
        if (byArray == null) {
            return null;
        }
        return StringUtils.join(byArray, c2, 0, byArray.length);
    }

    public static String join(byte[] byArray, char c2, int n2, int n3) {
        if (byArray == null) {
            return null;
        }
        if (n3 - n2 <= 0) {
            return EMPTY;
        }
        StringJoiner stringJoiner = StringUtils.a(c2);
        while (n2 < n3) {
            stringJoiner.add(String.valueOf(byArray[n2]));
            ++n2;
        }
        return stringJoiner.toString();
    }

    public static String join(char[] cArray, char c2) {
        if (cArray == null) {
            return null;
        }
        return StringUtils.join(cArray, c2, 0, cArray.length);
    }

    public static String join(char[] cArray, char c2, int n2, int n3) {
        if (cArray == null) {
            return null;
        }
        if (n3 - n2 <= 0) {
            return EMPTY;
        }
        StringJoiner stringJoiner = StringUtils.a(c2);
        while (n2 < n3) {
            stringJoiner.add(String.valueOf(cArray[n2]));
            ++n2;
        }
        return stringJoiner.toString();
    }

    public static String join(double[] dArray, char c2) {
        if (dArray == null) {
            return null;
        }
        return StringUtils.join(dArray, c2, 0, dArray.length);
    }

    public static String join(double[] dArray, char c2, int n2, int n3) {
        if (dArray == null) {
            return null;
        }
        if (n3 - n2 <= 0) {
            return EMPTY;
        }
        StringJoiner stringJoiner = StringUtils.a(c2);
        while (n2 < n3) {
            stringJoiner.add(String.valueOf(dArray[n2]));
            ++n2;
        }
        return stringJoiner.toString();
    }

    public static String join(float[] fArray, char c2) {
        if (fArray == null) {
            return null;
        }
        return StringUtils.join(fArray, c2, 0, fArray.length);
    }

    public static String join(float[] fArray, char c2, int n2, int n3) {
        if (fArray == null) {
            return null;
        }
        if (n3 - n2 <= 0) {
            return EMPTY;
        }
        StringJoiner stringJoiner = StringUtils.a(c2);
        while (n2 < n3) {
            stringJoiner.add(String.valueOf(fArray[n2]));
            ++n2;
        }
        return stringJoiner.toString();
    }

    public static String join(int[] nArray, char c2) {
        if (nArray == null) {
            return null;
        }
        return StringUtils.join(nArray, c2, 0, nArray.length);
    }

    public static String join(int[] nArray, char c2, int n2, int n3) {
        if (nArray == null) {
            return null;
        }
        if (n3 - n2 <= 0) {
            return EMPTY;
        }
        StringJoiner stringJoiner = StringUtils.a(c2);
        while (n2 < n3) {
            stringJoiner.add(String.valueOf(nArray[n2]));
            ++n2;
        }
        return stringJoiner.toString();
    }

    public static String join(Iterable<?> iterable, char c2) {
        if (iterable == null) {
            return null;
        }
        return StringUtils.join(iterable.iterator(), c2);
    }

    public static String join(Iterable<?> iterable, String string) {
        if (iterable == null) {
            return null;
        }
        return StringUtils.join(iterable.iterator(), string);
    }

    public static String join(Iterator<?> iterator, char c2) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object obj = iterator.next();
        if (!iterator.hasNext()) {
            iterator = obj;
            return Objects.toString(iterator, EMPTY);
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (obj != null) {
            stringBuilder.append(obj);
        }
        while (iterator.hasNext()) {
            stringBuilder.append(c2);
            obj = iterator.next();
            if (obj == null) continue;
            stringBuilder.append(obj);
        }
        return stringBuilder.toString();
    }

    public static String join(Iterator<?> iterator, String string) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object obj = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.toString(obj, EMPTY);
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (obj != null) {
            stringBuilder.append(obj);
        }
        while (iterator.hasNext()) {
            if (string != null) {
                stringBuilder.append(string);
            }
            if ((obj = iterator.next()) == null) continue;
            stringBuilder.append(obj);
        }
        return stringBuilder.toString();
    }

    public static String join(List<?> list, char c2, int n2, int n3) {
        if (list == null) {
            return null;
        }
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return EMPTY;
        }
        list = list.subList(n2, n3);
        return StringUtils.join(list.iterator(), c2);
    }

    public static String join(List<?> list, String string, int n2, int n3) {
        if (list == null) {
            return null;
        }
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return EMPTY;
        }
        list = list.subList(n2, n3);
        return StringUtils.join(list.iterator(), string);
    }

    public static String join(long[] lArray, char c2) {
        if (lArray == null) {
            return null;
        }
        return StringUtils.join(lArray, c2, 0, lArray.length);
    }

    public static String join(long[] lArray, char c2, int n2, int n3) {
        if (lArray == null) {
            return null;
        }
        if (n3 - n2 <= 0) {
            return EMPTY;
        }
        StringJoiner stringJoiner = StringUtils.a(c2);
        while (n2 < n3) {
            stringJoiner.add(String.valueOf(lArray[n2]));
            ++n2;
        }
        return stringJoiner.toString();
    }

    public static String join(Object[] objectArray, char c2) {
        if (objectArray == null) {
            return null;
        }
        return StringUtils.join(objectArray, c2, 0, objectArray.length);
    }

    public static String join(Object[] objectArray, char c2, int n2, int n3) {
        if (objectArray == null) {
            return null;
        }
        if (n3 - n2 <= 0) {
            return EMPTY;
        }
        StringJoiner stringJoiner = StringUtils.a(c2);
        while (n2 < n3) {
            Object object = objectArray[n2];
            stringJoiner.add(Objects.toString(object, EMPTY));
            ++n2;
        }
        return stringJoiner.toString();
    }

    public static String join(Object[] objectArray, String string) {
        if (objectArray == null) {
            return null;
        }
        return StringUtils.join(objectArray, string, 0, objectArray.length);
    }

    public static String join(Object[] objectArray, String object, int n2, int n3) {
        if (objectArray == null) {
            return null;
        }
        if (n3 - n2 <= 0) {
            return EMPTY;
        }
        Object object2 = object;
        object = new StringJoiner(Objects.toString(object2, EMPTY));
        while (n2 < n3) {
            object2 = objectArray[n2];
            ((StringJoiner)object).add(Objects.toString(object2, EMPTY));
            ++n2;
        }
        return ((StringJoiner)object).toString();
    }

    public static String join(short[] sArray, char c2) {
        if (sArray == null) {
            return null;
        }
        return StringUtils.join(sArray, c2, 0, sArray.length);
    }

    public static String join(short[] sArray, char c2, int n2, int n3) {
        if (sArray == null) {
            return null;
        }
        if (n3 - n2 <= 0) {
            return EMPTY;
        }
        StringJoiner stringJoiner = StringUtils.a(c2);
        while (n2 < n3) {
            stringJoiner.add(String.valueOf(sArray[n2]));
            ++n2;
        }
        return stringJoiner.toString();
    }

    @SafeVarargs
    public static <T> String join(T ... TArray) {
        return StringUtils.join((Object[])TArray, null);
    }

    public static String joinWith(String string, Object ... objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Object varargs must not be null");
        }
        return StringUtils.join(objectArray, string);
    }

    public static int lastIndexOf(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null) {
            return -1;
        }
        return CharSequenceUtils.b(charSequence, charSequence2, charSequence.length());
    }

    public static int lastIndexOf(CharSequence charSequence, CharSequence charSequence2, int n2) {
        return CharSequenceUtils.b(charSequence, charSequence2, n2);
    }

    public static int lastIndexOf(CharSequence charSequence, int n2) {
        if (StringUtils.isEmpty(charSequence)) {
            return -1;
        }
        return CharSequenceUtils.b(charSequence, n2, charSequence.length());
    }

    public static int lastIndexOf(CharSequence charSequence, int n2, int n3) {
        if (StringUtils.isEmpty(charSequence)) {
            return -1;
        }
        return CharSequenceUtils.b(charSequence, n2, n3);
    }

    public static int lastIndexOfAny(CharSequence charSequence, CharSequence ... object) {
        if (charSequence == null || object == null) {
            return -1;
        }
        int n2 = -1;
        CharSequence[] charSequenceArray = object;
        int n3 = ((CharSequence[])object).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            object = charSequenceArray[i2];
            if (object == null || (n4 = CharSequenceUtils.b(charSequence, (CharSequence)object, charSequence.length())) <= n2) continue;
            n2 = n4;
        }
        return n2;
    }

    public static int lastIndexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        return StringUtils.lastIndexOfIgnoreCase(charSequence, charSequence2, charSequence.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2, int n2) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        int n3 = charSequence2.length();
        int n4 = charSequence.length();
        if (n2 > n4 - n3) {
            n2 = n4 - n3;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n3 == 0) {
            return n2;
        }
        while (n2 >= 0) {
            if (CharSequenceUtils.a(charSequence, true, n2, charSequence2, 0, n3)) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public static int lastOrdinalIndexOf(CharSequence charSequence, CharSequence charSequence2, int n2) {
        return StringUtils.a(charSequence, charSequence2, n2, true);
    }

    public static String left(String string, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 0) {
            return EMPTY;
        }
        if (string.length() <= n2) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static String leftPad(String string, int n2) {
        return StringUtils.leftPad(string, n2, ' ');
    }

    public static String leftPad(String string, int n2, char c2) {
        if (string == null) {
            return null;
        }
        int n3 = n2 - string.length();
        if (n3 <= 0) {
            return string;
        }
        if (n3 > 8192) {
            return StringUtils.leftPad(string, n2, String.valueOf(c2));
        }
        return StringUtils.repeat(c2, n3).concat(string);
    }

    public static String leftPad(String string, int n2, String object) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)object)) {
            object = SPACE;
        }
        int n3 = ((String)object).length();
        int n4 = string.length();
        if ((n4 = n2 - n4) <= 0) {
            return string;
        }
        if (n3 == 1 && n4 <= 8192) {
            return StringUtils.leftPad(string, n2, ((String)object).charAt(0));
        }
        if (n4 == n3) {
            return ((String)object).concat(string);
        }
        if (n4 < n3) {
            return ((String)object).substring(0, n4).concat(string);
        }
        char[] cArray = new char[n4];
        object = ((String)object).toCharArray();
        for (int i2 = 0; i2 < n4; ++i2) {
            cArray[i2] = (char)object[i2 % n3];
        }
        return new String(cArray).concat(string);
    }

    public static int length(CharSequence charSequence) {
        if (charSequence == null) {
            return 0;
        }
        return charSequence.length();
    }

    public static String lowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static String lowerCase(String string, Locale locale) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase(LocaleUtils.toLocale(locale));
    }

    public static String mid(String string, int n2, int n3) {
        if (string == null) {
            return null;
        }
        if (n3 < 0 || n2 > string.length()) {
            return EMPTY;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (string.length() <= n2 + n3) {
            return string.substring(n2);
        }
        int n4 = n2;
        return string.substring(n4, n4 + n3);
    }

    private static StringJoiner a(char c2) {
        return new StringJoiner(String.valueOf(c2));
    }

    public static String normalizeSpace(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            boolean bl3 = Character.isWhitespace(c2);
            if (bl3) {
                if (n4 == 0 && !bl2) {
                    cArray[n3++] = SPACE.charAt(0);
                }
                ++n4;
                continue;
            }
            bl2 = false;
            cArray[n3++] = c2 == '\u00a0' ? 32 : (int)c2;
            n4 = 0;
        }
        if (bl2) {
            return EMPTY;
        }
        return new String(cArray, 0, n3 - (n4 > 0 ? 1 : 0)).trim();
    }

    public static int ordinalIndexOf(CharSequence charSequence, CharSequence charSequence2, int n2) {
        return StringUtils.a(charSequence, charSequence2, n2, false);
    }

    private static int a(CharSequence charSequence, CharSequence charSequence2, int n2, boolean bl2) {
        if (charSequence == null || charSequence2 == null || n2 <= 0) {
            return -1;
        }
        if (charSequence2.length() == 0) {
            if (bl2) {
                return charSequence.length();
            }
            return 0;
        }
        int n3 = 0;
        int n4 = bl2 ? charSequence.length() : -1;
        do {
            if ((n4 = bl2 ? CharSequenceUtils.b(charSequence, charSequence2, n4 - 1) : CharSequenceUtils.a(charSequence, charSequence2, n4 + 1)) >= 0) continue;
            return n4;
        } while (++n3 < n2);
        return n4;
    }

    public static String overlay(String string, String string2, int n2, int n3) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = EMPTY;
        }
        int n4 = string.length();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        if (n2 > n3) {
            n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        return string.substring(0, n2) + string2 + string.substring(n3);
    }

    private static String b(String string, CharSequence charSequence, boolean bl2, CharSequence ... charSequenceArray) {
        if (string == null || StringUtils.isEmpty(charSequence) || StringUtils.b(string, charSequence, bl2)) {
            return string;
        }
        if (ArrayUtils.isNotEmpty(charSequenceArray)) {
            for (CharSequence charSequence2 : charSequenceArray) {
                if (!StringUtils.b(string, charSequence2, bl2)) continue;
                return string;
            }
        }
        return charSequence.toString() + string;
    }

    public static String prependIfMissing(String string, CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StringUtils.b(string, charSequence, false, charSequenceArray);
    }

    public static String prependIfMissingIgnoreCase(String string, CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StringUtils.b(string, charSequence, true, charSequenceArray);
    }

    public static String remove(String object, char c2) {
        if (StringUtils.isEmpty((CharSequence)object) || ((String)object).indexOf(c2) == -1) {
            return object;
        }
        object = ((String)object).toCharArray();
        int n2 = 0;
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            if (object[i2] == c2) continue;
            object[n2++] = object[i2];
        }
        return new String((char[])object, 0, n2);
    }

    public static String remove(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        return StringUtils.replace(string, string2, EMPTY, -1);
    }

    @Deprecated
    public static String removeAll(String string, String string2) {
        return RegExUtils.removeAll(string, string2);
    }

    public static String removeEnd(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String removeEndIgnoreCase(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (StringUtils.endsWithIgnoreCase(string, string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    @Deprecated
    public static String removeFirst(String string, String string2) {
        return StringUtils.replaceFirst(string, string2, EMPTY);
    }

    public static String removeIgnoreCase(String string, String string2) {
        return StringUtils.replaceIgnoreCase(string, string2, EMPTY, -1);
    }

    @Deprecated
    public static String removePattern(String string, String string2) {
        return RegExUtils.removePattern(string, string2);
    }

    public static String removeStart(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static String removeStartIgnoreCase(String string, String string2) {
        if (string != null && StringUtils.startsWithIgnoreCase(string, string2)) {
            return string.substring(StringUtils.length(string2));
        }
        return string;
    }

    public static String repeat(char c2, int n2) {
        if (n2 <= 0) {
            return EMPTY;
        }
        char[] cArray = new char[n2];
        Arrays.fill(cArray, c2);
        return new String(cArray);
    }

    public static String repeat(String string, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 <= 0) {
            return EMPTY;
        }
        int n3 = string.length();
        if (n2 == 1 || n3 == 0) {
            return string;
        }
        if (n3 == 1 && n2 <= 8192) {
            return StringUtils.repeat(string.charAt(0), n2);
        }
        int n4 = n3 * n2;
        switch (n3) {
            case 1: {
                return StringUtils.repeat(string.charAt(0), n2);
            }
            case 2: {
                n3 = string.charAt(0);
                char c2 = string.charAt(1);
                char[] cArray = new char[n4];
                for (int i2 = (n2 << 1) - 2; i2 >= 0; --i2) {
                    cArray[i2] = n3;
                    cArray[i2 + 1] = c2;
                    --i2;
                }
                return new String(cArray);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(n4);
        for (n3 = 0; n3 < n2; ++n3) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String repeat(String string, String string2, int n2) {
        if (string == null || string2 == null) {
            return StringUtils.repeat(string, n2);
        }
        string = StringUtils.repeat(string + string2, n2);
        return StringUtils.removeEnd(string, string2);
    }

    public static String replace(String string, String string2, String string3) {
        return StringUtils.replace(string, string2, string3, -1);
    }

    public static String replace(String string, String string2, String string3, int n2) {
        return StringUtils.a(string, string2, string3, n2, false);
    }

    private static String a(String string, String string2, String string3, int n2, boolean bl2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2) || string3 == null || n2 == 0) {
            return string;
        }
        if (bl2) {
            string2 = string2.toLowerCase();
        }
        int n3 = 0;
        int n4 = bl2 ? StringUtils.indexOfIgnoreCase(string, string2, 0) : StringUtils.indexOf((CharSequence)string, string2, 0);
        if (n4 == -1) {
            return string;
        }
        int n5 = string2.length();
        int n6 = Math.max(string3.length() - n5, 0);
        StringBuilder stringBuilder = new StringBuilder(string.length() + (n6 *= n2 < 0 ? 16 : Math.min(n2, 64)));
        while (n4 != -1) {
            stringBuilder.append(string, n3, n4).append(string3);
            n3 = n4 + n5;
            if (--n2 == 0) break;
            n4 = bl2 ? StringUtils.indexOfIgnoreCase(string, string2, n3) : StringUtils.indexOf((CharSequence)string, string2, n3);
        }
        stringBuilder.append(string, n3, string.length());
        return stringBuilder.toString();
    }

    @Deprecated
    public static String replaceAll(String string, String string2, String string3) {
        return RegExUtils.replaceAll(string, string2, string3);
    }

    public static String replaceChars(String string, char c2, char c3) {
        if (string == null) {
            return null;
        }
        return string.replace(c2, c3);
    }

    public static String replaceChars(String string, String string2, String string3) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (string3 == null) {
            string3 = EMPTY;
        }
        boolean bl2 = false;
        int n2 = string3.length();
        int n3 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            int n4 = string2.indexOf(c2);
            if (n4 >= 0) {
                bl2 = true;
                if (n4 >= n2) continue;
                stringBuilder.append(string3.charAt(n4));
                continue;
            }
            stringBuilder.append(c2);
        }
        if (bl2) {
            return stringBuilder.toString();
        }
        return string;
    }

    public static String replaceEach(String string, String[] stringArray, String[] stringArray2) {
        return StringUtils.a(string, stringArray, stringArray2, false, 0);
    }

    private static String a(String object, String[] stringArray, String[] stringArray2, boolean bl2, int n2) {
        while (true) {
            int n3;
            int n4;
            int n5;
            Object object2;
            Object object3;
            if (n2 < 0) {
                object3 = new HashSet<String>(Arrays.asList(stringArray));
                object2 = new HashSet<String>(Arrays.asList(stringArray2));
                object3.retainAll((Collection<?>)object2);
                if (!object3.isEmpty()) {
                    throw new IllegalStateException("Aborting to protect against StackOverflowError - output of one loop is the input of another");
                }
            }
            if (StringUtils.isEmpty((CharSequence)object) || ArrayUtils.isEmpty(stringArray) || ArrayUtils.isEmpty(stringArray2) || ArrayUtils.isNotEmpty(stringArray) && n2 == -1) {
                return object;
            }
            int n6 = stringArray.length;
            int n7 = stringArray2.length;
            if (n6 != n7) {
                throw new IllegalArgumentException("Search and Replace array lengths don't match: " + n6 + " vs " + n7);
            }
            object2 = new boolean[n6];
            int n8 = -1;
            int n9 = -1;
            for (n5 = 0; n5 < n6; ++n5) {
                if (object2[n5] != false || StringUtils.isEmpty(stringArray[n5]) || stringArray2[n5] == null) continue;
                n4 = ((String)object).indexOf(stringArray[n5]);
                if (n4 == -1) {
                    object2[n5] = true;
                    continue;
                }
                if (n8 != -1 && n4 >= n8) continue;
                n8 = n4;
                n9 = n5;
            }
            if (n8 == -1) {
                return object;
            }
            n5 = 0;
            n4 = 0;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2] == null || stringArray2[i2] == null || (n3 = stringArray2[i2].length() - stringArray[i2].length()) <= 0) continue;
                n4 += 3 * n3;
            }
            n4 = Math.min(n4, ((String)object).length() / 5);
            StringBuilder stringBuilder = new StringBuilder(((String)object).length() + n4);
            while (n8 != -1) {
                for (n3 = n5; n3 < n8; ++n3) {
                    stringBuilder.append(((String)object).charAt(n3));
                }
                stringBuilder.append(stringArray2[n9]);
                n5 = n8 + stringArray[n9].length();
                n8 = -1;
                n9 = -1;
                for (n3 = 0; n3 < n6; ++n3) {
                    if (object2[n3] != false || stringArray[n3] == null || stringArray[n3].isEmpty() || stringArray2[n3] == null) continue;
                    n4 = ((String)object).indexOf(stringArray[n3], n5);
                    if (n4 == -1) {
                        object2[n3] = true;
                        continue;
                    }
                    if (n8 != -1 && n4 >= n8) continue;
                    n8 = n4;
                    n9 = n3;
                }
            }
            n3 = ((String)object).length();
            for (n6 = n5; n6 < n3; ++n6) {
                stringBuilder.append(((String)object).charAt(n6));
            }
            object3 = stringBuilder.toString();
            if (!bl2) {
                return object3;
            }
            --n2;
            object = object3;
        }
    }

    public static String replaceEachRepeatedly(String string, String[] stringArray, String[] stringArray2) {
        int n2 = stringArray == null ? 0 : stringArray.length;
        return StringUtils.a(string, stringArray, stringArray2, true, n2);
    }

    @Deprecated
    public static String replaceFirst(String string, String string2, String string3) {
        return RegExUtils.replaceFirst(string, string2, string3);
    }

    public static String replaceIgnoreCase(String string, String string2, String string3) {
        return StringUtils.replaceIgnoreCase(string, string2, string3, -1);
    }

    public static String replaceIgnoreCase(String string, String string2, String string3, int n2) {
        return StringUtils.a(string, string2, string3, n2, true);
    }

    public static String replaceOnce(String string, String string2, String string3) {
        return StringUtils.replace(string, string2, string3, 1);
    }

    public static String replaceOnceIgnoreCase(String string, String string2, String string3) {
        return StringUtils.replaceIgnoreCase(string, string2, string3, 1);
    }

    @Deprecated
    public static String replacePattern(String string, String string2, String string3) {
        return RegExUtils.replacePattern(string, string2, string3);
    }

    public static String reverse(String string) {
        if (string == null) {
            return null;
        }
        return new StringBuilder(string).reverse().toString();
    }

    public static String reverseDelimited(String objectArray, char c2) {
        if (objectArray == null) {
            return null;
        }
        objectArray = StringUtils.split((String)objectArray, c2);
        ArrayUtils.reverse(objectArray);
        return StringUtils.join(objectArray, c2);
    }

    public static String right(String string, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 0) {
            return EMPTY;
        }
        if (string.length() <= n2) {
            return string;
        }
        String string2 = string;
        return string2.substring(string2.length() - n2);
    }

    public static String rightPad(String string, int n2) {
        return StringUtils.rightPad(string, n2, ' ');
    }

    public static String rightPad(String string, int n2, char c2) {
        if (string == null) {
            return null;
        }
        int n3 = n2 - string.length();
        if (n3 <= 0) {
            return string;
        }
        if (n3 > 8192) {
            return StringUtils.rightPad(string, n2, String.valueOf(c2));
        }
        return string.concat(StringUtils.repeat(c2, n3));
    }

    public static String rightPad(String string, int n2, String object) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)object)) {
            object = SPACE;
        }
        int n3 = ((String)object).length();
        int n4 = string.length();
        if ((n4 = n2 - n4) <= 0) {
            return string;
        }
        if (n3 == 1 && n4 <= 8192) {
            return StringUtils.rightPad(string, n2, ((String)object).charAt(0));
        }
        if (n4 == n3) {
            return string.concat((String)object);
        }
        if (n4 < n3) {
            return string.concat(((String)object).substring(0, n4));
        }
        char[] cArray = new char[n4];
        object = ((String)object).toCharArray();
        for (int i2 = 0; i2 < n4; ++i2) {
            cArray[i2] = (char)object[i2 % n3];
        }
        return string.concat(new String(cArray));
    }

    public static String rotate(String string, int n2) {
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        if (n2 == 0 || n3 == 0 || n2 % n3 == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n3);
        n2 = -(n2 % n3);
        stringBuilder.append(StringUtils.substring(string, n2));
        stringBuilder.append(StringUtils.substring(string, 0, n2));
        return stringBuilder.toString();
    }

    public static String[] split(String string) {
        return StringUtils.split(string, null, -1);
    }

    public static String[] split(String string, char c2) {
        return StringUtils.a(string, c2, false);
    }

    public static String[] split(String string, String string2) {
        return StringUtils.b(string, string2, -1, false);
    }

    public static String[] split(String string, String string2, int n2) {
        return StringUtils.b(string, string2, n2, false);
    }

    public static String[] splitByCharacterType(String string) {
        return StringUtils.a(string, false);
    }

    private static String[] a(String object, boolean bl2) {
        if (object == null) {
            return null;
        }
        if (((String)object).isEmpty()) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        object = ((String)object).toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = Character.getType((char)object[0]);
        for (int i2 = 1; i2 < ((Object)object).length; ++i2) {
            int n4 = Character.getType((char)object[i2]);
            if (n4 == n3) continue;
            if (bl2 && n4 == 2 && n3 == 1) {
                n3 = i2 - 1;
                if (n3 != n2) {
                    arrayList.add(new String((char[])object, n2, n3 - n2));
                    n2 = n3;
                }
            } else {
                arrayList.add(new String((char[])object, n2, i2 - n2));
                n2 = i2;
            }
            n3 = n4;
        }
        arrayList.add(new String((char[])object, n2, ((Object)object).length - n2));
        return arrayList.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String[] splitByCharacterTypeCamelCase(String string) {
        return StringUtils.a(string, true);
    }

    public static String[] splitByWholeSeparator(String string, String string2) {
        return StringUtils.a(string, string2, -1, false);
    }

    public static String[] splitByWholeSeparator(String string, String string2, int n2) {
        return StringUtils.a(string, string2, n2, false);
    }

    public static String[] splitByWholeSeparatorPreserveAllTokens(String string, String string2) {
        return StringUtils.a(string, string2, -1, true);
    }

    public static String[] splitByWholeSeparatorPreserveAllTokens(String string, String string2, int n2) {
        return StringUtils.a(string, string2, n2, true);
    }

    private static String[] a(String string, String string2, int n2, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (string2 == null || EMPTY.equals(string2)) {
            return StringUtils.b(string, null, n2, bl2);
        }
        int n4 = string2.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            n7 = string.indexOf(string2, n6);
            if (n7 >= 0) {
                if (n7 > n6) {
                    if (++n5 == n2) {
                        n7 = n3;
                        arrayList.add(string.substring(n6));
                        continue;
                    }
                    arrayList.add(string.substring(n6, n7));
                    n6 = n7 + n4;
                    continue;
                }
                if (bl2) {
                    if (++n5 == n2) {
                        n7 = n3;
                        arrayList.add(string.substring(n6));
                    } else {
                        arrayList.add(EMPTY);
                    }
                }
                n6 = n7 + n4;
                continue;
            }
            arrayList.add(string.substring(n6));
            n7 = n3;
        }
        return arrayList.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String[] splitPreserveAllTokens(String string) {
        return StringUtils.b(string, null, -1, true);
    }

    public static String[] splitPreserveAllTokens(String string, char c2) {
        return StringUtils.a(string, c2, true);
    }

    public static String[] splitPreserveAllTokens(String string, String string2) {
        return StringUtils.b(string, string2, -1, true);
    }

    public static String[] splitPreserveAllTokens(String string, String string2, int n2) {
        return StringUtils.b(string, string2, n2, true);
    }

    private static String[] a(String string, char c2, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        while (n3 < n2) {
            if (string.charAt(n3) == c2) {
                if (bl3 || bl2) {
                    arrayList.add(string.substring(n4, n3));
                    bl3 = false;
                    bl4 = true;
                }
                n4 = ++n3;
                continue;
            }
            bl4 = false;
            bl3 = true;
            ++n3;
        }
        if (bl3 || bl2 && bl4) {
            arrayList.add(string.substring(n4, n3));
        }
        return arrayList.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private static String[] b(String string, String string2, int n2, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (string2 == null) {
            while (n5 < n3) {
                if (Character.isWhitespace(string.charAt(n5))) {
                    if (bl3 || bl2) {
                        bl4 = true;
                        if (n4++ == n2) {
                            n5 = n3;
                            bl4 = false;
                        }
                        arrayList.add(string.substring(n6, n5));
                        bl3 = false;
                    }
                    n6 = ++n5;
                    continue;
                }
                bl4 = false;
                bl3 = true;
                ++n5;
            }
        } else if (string2.length() == 1) {
            char c2 = string2.charAt(0);
            while (n5 < n3) {
                if (string.charAt(n5) == c2) {
                    if (bl3 || bl2) {
                        bl4 = true;
                        if (n4++ == n2) {
                            n5 = n3;
                            bl4 = false;
                        }
                        arrayList.add(string.substring(n6, n5));
                        bl3 = false;
                    }
                    n6 = ++n5;
                    continue;
                }
                bl4 = false;
                bl3 = true;
                ++n5;
            }
        } else {
            while (n5 < n3) {
                if (string2.indexOf(string.charAt(n5)) >= 0) {
                    if (bl3 || bl2) {
                        bl4 = true;
                        if (n4++ == n2) {
                            n5 = n3;
                            bl4 = false;
                        }
                        arrayList.add(string.substring(n6, n5));
                        bl3 = false;
                    }
                    n6 = ++n5;
                    continue;
                }
                bl4 = false;
                bl3 = true;
                ++n5;
            }
        }
        if (bl3 || bl2 && bl4) {
            arrayList.add(string.substring(n6, n5));
        }
        return arrayList.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtils.b(charSequence, charSequence2, false);
    }

    private static boolean b(CharSequence charSequence, CharSequence charSequence2, boolean bl2) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == charSequence2;
        }
        int n2 = charSequence2.length();
        if (n2 > charSequence.length()) {
            return false;
        }
        return CharSequenceUtils.a(charSequence, bl2, 0, charSequence2, 0, n2);
    }

    public static boolean startsWithAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (StringUtils.isEmpty(charSequence) || ArrayUtils.isEmpty(charSequenceArray)) {
            return false;
        }
        for (CharSequence charSequence2 : charSequenceArray) {
            if (!StringUtils.startsWith(charSequence, charSequence2)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtils.b(charSequence, charSequence2, true);
    }

    public static String strip(String string) {
        return StringUtils.strip(string, null);
    }

    public static String strip(String string, String string2) {
        string = StringUtils.stripStart(string, string2);
        return StringUtils.stripEnd(string, string2);
    }

    public static String stripAccents(String charSequence) {
        if (charSequence == null) {
            return null;
        }
        charSequence = new StringBuilder(Normalizer.normalize(charSequence, Normalizer.Form.NFD));
        StringBuilder stringBuilder = charSequence;
        for (int i2 = 0; i2 < stringBuilder.length(); ++i2) {
            if (stringBuilder.charAt(i2) == '\u0141') {
                stringBuilder.setCharAt(i2, 'L');
                continue;
            }
            if (stringBuilder.charAt(i2) != '\u0142') continue;
            stringBuilder.setCharAt(i2, 'l');
        }
        return a.matcher(charSequence).replaceAll(EMPTY);
    }

    public static String[] stripAll(String ... stringArray) {
        return StringUtils.stripAll(stringArray, null);
    }

    public static String[] stripAll(String[] stringArray, String string) {
        int n2 = ArrayUtils.getLength(stringArray);
        if (n2 == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray2[i2] = StringUtils.strip(stringArray[i2], string);
        }
        return stringArray2;
    }

    public static String stripEnd(String string, String string2) {
        int n2 = StringUtils.length(string);
        if (n2 == 0) {
            return string;
        }
        if (string2 == null) {
            while (n2 != 0 && Character.isWhitespace(string.charAt(n2 - 1))) {
                --n2;
            }
        } else {
            if (string2.isEmpty()) {
                return string;
            }
            while (n2 != 0 && string2.indexOf(string.charAt(n2 - 1)) != -1) {
                --n2;
            }
        }
        return string.substring(0, n2);
    }

    public static String stripStart(String string, String string2) {
        int n2;
        int n3 = StringUtils.length(string);
        if (n3 == 0) {
            return string;
        }
        if (string2 == null) {
            for (n2 = 0; n2 != n3 && Character.isWhitespace(string.charAt(n2)); ++n2) {
            }
        } else {
            if (string2.isEmpty()) {
                return string;
            }
            while (n2 != n3 && string2.indexOf(string.charAt(n2)) != -1) {
                ++n2;
            }
        }
        return string.substring(n2);
    }

    public static String stripToEmpty(String string) {
        if (string == null) {
            return EMPTY;
        }
        return StringUtils.strip(string, null);
    }

    public static String stripToNull(String string) {
        if (string == null) {
            return null;
        }
        if ((string = StringUtils.strip(string, null)).isEmpty()) {
            return null;
        }
        return string;
    }

    public static String substring(String string, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = string.length() + n2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > string.length()) {
            return EMPTY;
        }
        return string.substring(n2);
    }

    public static String substring(String string, int n2, int n3) {
        if (string == null) {
            return null;
        }
        if (n3 < 0) {
            n3 = string.length() + n3;
        }
        if (n2 < 0) {
            n2 = string.length() + n2;
        }
        if (n3 > string.length()) {
            n3 = string.length();
        }
        if (n2 > n3) {
            return EMPTY;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return string.substring(n2, n3);
    }

    public static String substringAfter(String string, int n2) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if ((n2 = string.indexOf(n2)) == -1) {
            return EMPTY;
        }
        return string.substring(n2 + 1);
    }

    public static String substringAfter(String string, String string2) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (string2 == null) {
            return EMPTY;
        }
        int n2 = string.indexOf(string2);
        if (n2 == -1) {
            return EMPTY;
        }
        return string.substring(n2 + string2.length());
    }

    public static String substringAfterLast(String string, int n2) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if ((n2 = string.lastIndexOf(n2)) == -1 || n2 == string.length() - 1) {
            return EMPTY;
        }
        return string.substring(n2 + 1);
    }

    public static String substringAfterLast(String string, String string2) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (StringUtils.isEmpty(string2)) {
            return EMPTY;
        }
        int n2 = string.lastIndexOf(string2);
        if (n2 == -1 || n2 == string.length() - string2.length()) {
            return EMPTY;
        }
        return string.substring(n2 + string2.length());
    }

    public static String substringBefore(String string, int n2) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if ((n2 = string.indexOf(n2)) == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static String substringBefore(String string, String string2) {
        if (StringUtils.isEmpty(string) || string2 == null) {
            return string;
        }
        if (string2.isEmpty()) {
            return EMPTY;
        }
        int n2 = string.indexOf(string2);
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static String substringBeforeLast(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        int n2 = string.lastIndexOf(string2);
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static String substringBetween(String string, String string2) {
        String string3 = string2;
        return StringUtils.substringBetween(string, string3, string3);
    }

    public static String substringBetween(String string, String string2, String string3) {
        int n2;
        if (!ObjectUtils.allNotNull(string, string2, string3)) {
            return null;
        }
        int n3 = string.indexOf(string2);
        if (n3 != -1 && (n2 = string.indexOf(string3, n3 + string2.length())) != -1) {
            return string.substring(n3 + string2.length(), n2);
        }
        return null;
    }

    public static String[] substringsBetween(String string, String string2, String string3) {
        int n2;
        if (string == null || StringUtils.isEmpty(string2) || StringUtils.isEmpty(string3)) {
            return null;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int n4 = string3.length();
        int n5 = string2.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n6 = 0;
        while (n6 < n3 - n4 && (n6 = string.indexOf(string2, n6)) >= 0 && (n2 = string.indexOf(string3, n6 += n5)) >= 0) {
            arrayList.add(string.substring(n6, n2));
            n6 = n2 + n4;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String swapCase(String string) {
        int n2;
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        int n3 = string.length();
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (Character.isUpperCase(n2) || Character.isTitleCase(n2)) {
                n2 = Character.toLowerCase(n2);
            } else if (Character.isLowerCase(n2)) {
                n2 = Character.toUpperCase(n2);
            }
            nArray[n4++] = n2;
        }
        return new String(nArray, 0, n4);
    }

    public static int[] toCodePoints(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        if (charSequence.length() == 0) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        charSequence = charSequence.toString();
        int[] nArray = new int[((String)charSequence).codePointCount(0, ((String)charSequence).length())];
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = ((String)charSequence).codePointAt(n2);
            n2 += Character.charCount(nArray[i2]);
        }
        return nArray;
    }

    public static String toEncodedString(byte[] byArray, Charset charset) {
        return new String(byArray, b.a(charset));
    }

    public static String toRootLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase(Locale.ROOT);
    }

    public static String toRootUpperCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase(Locale.ROOT);
    }

    @Deprecated
    public static String toString(byte[] object, String string) {
        byte[] byArray = object;
        String string2 = string;
        object = string2;
        return new String(byArray, string2 == null ? Charset.defaultCharset() : Charset.forName((String)object));
    }

    public static String trim(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public static String trimToEmpty(String string) {
        if (string == null) {
            return EMPTY;
        }
        return string.trim();
    }

    public static String trimToNull(String string) {
        if (StringUtils.isEmpty(string = StringUtils.trim(string))) {
            return null;
        }
        return string;
    }

    public static String truncate(String string, int n2) {
        return StringUtils.truncate(string, 0, n2);
    }

    public static String truncate(String string, int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("maxWith cannot be negative");
        }
        if (string == null) {
            return null;
        }
        if (n2 > string.length()) {
            return EMPTY;
        }
        if (string.length() > n3) {
            n3 = Math.min(n2 + n3, string.length());
            return string.substring(n2, n3);
        }
        return string.substring(n2);
    }

    public static String uncapitalize(String string) {
        int n2;
        int n3 = StringUtils.length(string);
        if (n3 == 0) {
            return string;
        }
        int n4 = string.codePointAt(0);
        if (n4 == (n2 = Character.toLowerCase(n4))) {
            return string;
        }
        int[] nArray = new int[n3];
        int n5 = 0;
        ++n5;
        nArray[0] = n2;
        for (n4 = Character.charCount(n4); n4 < n3; n4 += Character.charCount(n2)) {
            n2 = string.codePointAt(n4);
            nArray[n5++] = n2;
        }
        return new String(nArray, 0, n5);
    }

    public static String unwrap(String string, char c2) {
        if (StringUtils.isEmpty(string) || c2 == '\u0000' || string.length() == 1) {
            return string;
        }
        if (string.charAt(0) == c2) {
            String string2 = string;
            if (string2.charAt(string2.length() - 1) == c2) {
                c2 = (char)(string.length() - 1);
                return string.substring(1, c2);
            }
        }
        return string;
    }

    public static String unwrap(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2) || string.length() < 2 * string2.length()) {
            return string;
        }
        if (StringUtils.startsWith(string, string2) && StringUtils.endsWith(string, string2)) {
            int n2 = string.indexOf(string2);
            int n3 = string.lastIndexOf(string2);
            int n4 = string2.length();
            if (n2 != -1 && n3 != -1) {
                return string.substring(n2 + n4, n3);
            }
        }
        return string;
    }

    public static String upperCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase();
    }

    public static String upperCase(String string, Locale locale) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase(LocaleUtils.toLocale(locale));
    }

    public static String valueOf(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return String.valueOf(cArray);
    }

    public static String wrap(String string, char c2) {
        if (StringUtils.isEmpty(string) || c2 == '\u0000') {
            return string;
        }
        return c2 + string + c2;
    }

    public static String wrap(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        return string2.concat(string).concat(string2);
    }

    public static String wrapIfMissing(String string, char c2) {
        boolean bl2;
        if (StringUtils.isEmpty(string) || c2 == '\u0000') {
            return string;
        }
        boolean bl3 = string.charAt(0) != c2;
        String string2 = string;
        boolean bl4 = bl2 = string2.charAt(string2.length() - 1) != c2;
        if (!bl3 && !bl2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        if (bl3) {
            stringBuilder.append(c2);
        }
        stringBuilder.append(string);
        if (bl2) {
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String wrapIfMissing(String string, String string2) {
        boolean bl2;
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        boolean bl3 = !string.startsWith(string2);
        boolean bl4 = bl2 = !string.endsWith(string2);
        if (!bl3 && !bl2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + string2.length());
        if (bl3) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(string);
        if (bl2) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }
}

