/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.File;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;

public class SystemUtils {
    public static final String AWT_TOOLKIT = SystemUtils.b("awt.toolkit");
    public static final String FILE_ENCODING = SystemUtils.b("file.encoding");
    @Deprecated
    public static final String FILE_SEPARATOR = SystemUtils.b("file.separator");
    public static final String JAVA_AWT_FONTS = SystemUtils.b("java.awt.fonts");
    public static final String JAVA_AWT_GRAPHICSENV = SystemUtils.b("java.awt.graphicsenv");
    public static final String JAVA_AWT_HEADLESS = SystemUtils.b("java.awt.headless");
    public static final String JAVA_AWT_PRINTERJOB = SystemUtils.b("java.awt.printerjob");
    public static final String JAVA_CLASS_PATH = SystemUtils.b("java.class.path");
    public static final String JAVA_CLASS_VERSION = SystemUtils.b("java.class.version");
    public static final String JAVA_COMPILER = SystemUtils.b("java.compiler");
    public static final String JAVA_ENDORSED_DIRS = SystemUtils.b("java.endorsed.dirs");
    public static final String JAVA_EXT_DIRS = SystemUtils.b("java.ext.dirs");
    public static final String JAVA_HOME = SystemUtils.b("java.home");
    public static final String JAVA_IO_TMPDIR = SystemUtils.b("java.io.tmpdir");
    public static final String JAVA_LIBRARY_PATH = SystemUtils.b("java.library.path");
    public static final String JAVA_RUNTIME_NAME = SystemUtils.b("java.runtime.name");
    public static final String JAVA_RUNTIME_VERSION = SystemUtils.b("java.runtime.version");
    public static final String JAVA_SPECIFICATION_NAME = SystemUtils.b("java.specification.name");
    public static final String JAVA_SPECIFICATION_VENDOR = SystemUtils.b("java.specification.vendor");
    public static final String JAVA_SPECIFICATION_VERSION = SystemUtils.b("java.specification.version");
    private static final JavaVersion a = JavaVersion.a(JAVA_SPECIFICATION_VERSION);
    public static final String JAVA_UTIL_PREFS_PREFERENCES_FACTORY = SystemUtils.b("java.util.prefs.PreferencesFactory");
    public static final String JAVA_VENDOR = SystemUtils.b("java.vendor");
    public static final String JAVA_VENDOR_URL = SystemUtils.b("java.vendor.url");
    public static final String JAVA_VERSION = SystemUtils.b("java.version");
    public static final String JAVA_VM_INFO = SystemUtils.b("java.vm.info");
    public static final String JAVA_VM_NAME = SystemUtils.b("java.vm.name");
    public static final String JAVA_VM_SPECIFICATION_NAME = SystemUtils.b("java.vm.specification.name");
    public static final String JAVA_VM_SPECIFICATION_VENDOR = SystemUtils.b("java.vm.specification.vendor");
    public static final String JAVA_VM_SPECIFICATION_VERSION = SystemUtils.b("java.vm.specification.version");
    public static final String JAVA_VM_VENDOR = SystemUtils.b("java.vm.vendor");
    public static final String JAVA_VM_VERSION = SystemUtils.b("java.vm.version");
    @Deprecated
    public static final String LINE_SEPARATOR = SystemUtils.b("line.separator");
    public static final String OS_ARCH = SystemUtils.b("os.arch");
    public static final String OS_NAME = SystemUtils.b("os.name");
    public static final String OS_VERSION = SystemUtils.b("os.version");
    @Deprecated
    public static final String PATH_SEPARATOR = SystemUtils.b("path.separator");
    public static final String USER_COUNTRY = SystemUtils.b("user.country") == null ? SystemUtils.b("user.region") : SystemUtils.b("user.country");
    public static final String USER_DIR = SystemUtils.b("user.dir");
    public static final String USER_HOME = SystemUtils.b("user.home");
    public static final String USER_LANGUAGE = SystemUtils.b("user.language");
    public static final String USER_NAME = SystemUtils.b("user.name");
    public static final String USER_TIMEZONE = SystemUtils.b("user.timezone");
    public static final boolean IS_JAVA_1_1 = SystemUtils.a("1.1");
    public static final boolean IS_JAVA_1_2 = SystemUtils.a("1.2");
    public static final boolean IS_JAVA_1_3 = SystemUtils.a("1.3");
    public static final boolean IS_JAVA_1_4 = SystemUtils.a("1.4");
    public static final boolean IS_JAVA_1_5 = SystemUtils.a("1.5");
    public static final boolean IS_JAVA_1_6 = SystemUtils.a("1.6");
    public static final boolean IS_JAVA_1_7 = SystemUtils.a("1.7");
    public static final boolean IS_JAVA_1_8 = SystemUtils.a("1.8");
    @Deprecated
    public static final boolean IS_JAVA_1_9 = SystemUtils.a("9");
    public static final boolean IS_JAVA_9 = SystemUtils.a("9");
    public static final boolean IS_JAVA_10 = SystemUtils.a("10");
    public static final boolean IS_JAVA_11 = SystemUtils.a("11");
    public static final boolean IS_JAVA_12 = SystemUtils.a("12");
    public static final boolean IS_JAVA_13 = SystemUtils.a("13");
    public static final boolean IS_JAVA_14 = SystemUtils.a("14");
    public static final boolean IS_JAVA_15 = SystemUtils.a("15");
    public static final boolean IS_OS_AIX;
    public static final boolean IS_OS_HP_UX;
    public static final boolean IS_OS_400;
    public static final boolean IS_OS_IRIX;
    public static final boolean IS_OS_LINUX;
    public static final boolean IS_OS_MAC;
    public static final boolean IS_OS_MAC_OSX;
    public static final boolean IS_OS_MAC_OSX_CHEETAH;
    public static final boolean IS_OS_MAC_OSX_PUMA;
    public static final boolean IS_OS_MAC_OSX_JAGUAR;
    public static final boolean IS_OS_MAC_OSX_PANTHER;
    public static final boolean IS_OS_MAC_OSX_TIGER;
    public static final boolean IS_OS_MAC_OSX_LEOPARD;
    public static final boolean IS_OS_MAC_OSX_SNOW_LEOPARD;
    public static final boolean IS_OS_MAC_OSX_LION;
    public static final boolean IS_OS_MAC_OSX_MOUNTAIN_LION;
    public static final boolean IS_OS_MAC_OSX_MAVERICKS;
    public static final boolean IS_OS_MAC_OSX_YOSEMITE;
    public static final boolean IS_OS_MAC_OSX_EL_CAPITAN;
    public static final boolean IS_OS_MAC_OSX_SIERRA;
    public static final boolean IS_OS_MAC_OSX_HIGH_SIERRA;
    public static final boolean IS_OS_MAC_OSX_MOJAVE;
    public static final boolean IS_OS_MAC_OSX_CATALINA;
    public static final boolean IS_OS_MAC_OSX_BIG_SUR;
    public static final boolean IS_OS_FREE_BSD;
    public static final boolean IS_OS_OPEN_BSD;
    public static final boolean IS_OS_NET_BSD;
    public static final boolean IS_OS_OS2;
    public static final boolean IS_OS_SOLARIS;
    public static final boolean IS_OS_SUN_OS;
    public static final boolean IS_OS_UNIX;
    public static final boolean IS_OS_WINDOWS;
    public static final boolean IS_OS_WINDOWS_2000;
    public static final boolean IS_OS_WINDOWS_2003;
    public static final boolean IS_OS_WINDOWS_2008;
    public static final boolean IS_OS_WINDOWS_2012;
    public static final boolean IS_OS_WINDOWS_95;
    public static final boolean IS_OS_WINDOWS_98;
    public static final boolean IS_OS_WINDOWS_ME;
    public static final boolean IS_OS_WINDOWS_NT;
    public static final boolean IS_OS_WINDOWS_XP;
    public static final boolean IS_OS_WINDOWS_VISTA;
    public static final boolean IS_OS_WINDOWS_7;
    public static final boolean IS_OS_WINDOWS_8;
    public static final boolean IS_OS_WINDOWS_10;
    public static final boolean IS_OS_ZOS;

    public static String getEnvironmentVariable(String string, String string2) {
        try {
            string = System.getenv(string);
            if (string == null) {
                return string2;
            }
            return string;
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    public static String getHostName() {
        if (IS_OS_WINDOWS) {
            return System.getenv("COMPUTERNAME");
        }
        return System.getenv("HOSTNAME");
    }

    public static File getJavaHome() {
        return new File(System.getProperty("java.home"));
    }

    public static File getJavaIoTmpDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    private static boolean a(String string) {
        String string2 = string;
        string = JAVA_SPECIFICATION_VERSION;
        if (string == null) {
            return false;
        }
        return string.startsWith(string2);
    }

    private static boolean a(String object, String stringArray) {
        String[] stringArray2 = stringArray;
        String[] stringArray3 = object;
        stringArray = OS_VERSION;
        object = OS_NAME;
        if (object == null || stringArray == null) {
            return false;
        }
        if (SystemUtils.b((String)object, (String)stringArray3)) {
            boolean bl2;
            block6: {
                String[] stringArray4 = stringArray;
                stringArray = stringArray2;
                object = stringArray4;
                if (StringUtils.isEmpty((CharSequence)stringArray4)) {
                    bl2 = false;
                } else {
                    stringArray = stringArray.split("\\.");
                    object = object.split("\\.");
                    for (int i2 = 0; i2 < Math.min(stringArray.length, ((String[])object).length); ++i2) {
                        if (stringArray[i2].equals(object[i2])) continue;
                        bl2 = false;
                        break block6;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return true;
            }
        }
        return false;
    }

    private static String b(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static String getUserName(String string) {
        return System.getProperty("user.name", string);
    }

    public static boolean isJavaAwtHeadless() {
        return Boolean.TRUE.toString().equals(JAVA_AWT_HEADLESS);
    }

    public static boolean isJavaVersionAtLeast(JavaVersion javaVersion) {
        return a.atLeast(javaVersion);
    }

    public static boolean isJavaVersionAtMost(JavaVersion javaVersion) {
        return a.atMost(javaVersion);
    }

    private static boolean b(String string, String string2) {
        if (string == null) {
            return false;
        }
        return string.startsWith(string2);
    }

    static {
        String string = "AIX";
        IS_OS_AIX = SystemUtils.b(OS_NAME, string);
        string = "HP-UX";
        IS_OS_HP_UX = SystemUtils.b(OS_NAME, string);
        string = "OS/400";
        IS_OS_400 = SystemUtils.b(OS_NAME, string);
        string = "Irix";
        IS_OS_IRIX = SystemUtils.b(OS_NAME, string);
        string = "Linux";
        IS_OS_LINUX = SystemUtils.b(OS_NAME, string) || SystemUtils.b(OS_NAME, string = "LINUX");
        string = "Mac";
        IS_OS_MAC = SystemUtils.b(OS_NAME, string);
        string = "Mac OS X";
        IS_OS_MAC_OSX = SystemUtils.b(OS_NAME, string);
        IS_OS_MAC_OSX_CHEETAH = SystemUtils.a("Mac OS X", "10.0");
        IS_OS_MAC_OSX_PUMA = SystemUtils.a("Mac OS X", "10.1");
        IS_OS_MAC_OSX_JAGUAR = SystemUtils.a("Mac OS X", "10.2");
        IS_OS_MAC_OSX_PANTHER = SystemUtils.a("Mac OS X", "10.3");
        IS_OS_MAC_OSX_TIGER = SystemUtils.a("Mac OS X", "10.4");
        IS_OS_MAC_OSX_LEOPARD = SystemUtils.a("Mac OS X", "10.5");
        IS_OS_MAC_OSX_SNOW_LEOPARD = SystemUtils.a("Mac OS X", "10.6");
        IS_OS_MAC_OSX_LION = SystemUtils.a("Mac OS X", "10.7");
        IS_OS_MAC_OSX_MOUNTAIN_LION = SystemUtils.a("Mac OS X", "10.8");
        IS_OS_MAC_OSX_MAVERICKS = SystemUtils.a("Mac OS X", "10.9");
        IS_OS_MAC_OSX_YOSEMITE = SystemUtils.a("Mac OS X", "10.10");
        IS_OS_MAC_OSX_EL_CAPITAN = SystemUtils.a("Mac OS X", "10.11");
        IS_OS_MAC_OSX_SIERRA = SystemUtils.a("Mac OS X", "10.12");
        IS_OS_MAC_OSX_HIGH_SIERRA = SystemUtils.a("Mac OS X", "10.13");
        IS_OS_MAC_OSX_MOJAVE = SystemUtils.a("Mac OS X", "10.14");
        IS_OS_MAC_OSX_CATALINA = SystemUtils.a("Mac OS X", "10.15");
        IS_OS_MAC_OSX_BIG_SUR = SystemUtils.a("Mac OS X", "10.16");
        string = "FreeBSD";
        IS_OS_FREE_BSD = SystemUtils.b(OS_NAME, string);
        string = "OpenBSD";
        IS_OS_OPEN_BSD = SystemUtils.b(OS_NAME, string);
        string = "NetBSD";
        IS_OS_NET_BSD = SystemUtils.b(OS_NAME, string);
        string = "OS/2";
        IS_OS_OS2 = SystemUtils.b(OS_NAME, string);
        string = "Solaris";
        IS_OS_SOLARIS = SystemUtils.b(OS_NAME, string);
        string = "SunOS";
        IS_OS_SUN_OS = SystemUtils.b(OS_NAME, string);
        IS_OS_UNIX = IS_OS_AIX || IS_OS_HP_UX || IS_OS_IRIX || IS_OS_LINUX || IS_OS_MAC_OSX || IS_OS_SOLARIS || IS_OS_SUN_OS || IS_OS_FREE_BSD || IS_OS_OPEN_BSD || IS_OS_NET_BSD;
        string = "Windows";
        IS_OS_WINDOWS = SystemUtils.b(OS_NAME, string);
        string = "Windows 2000";
        IS_OS_WINDOWS_2000 = SystemUtils.b(OS_NAME, string);
        string = "Windows 2003";
        IS_OS_WINDOWS_2003 = SystemUtils.b(OS_NAME, string);
        string = "Windows Server 2008";
        IS_OS_WINDOWS_2008 = SystemUtils.b(OS_NAME, string);
        string = "Windows Server 2012";
        IS_OS_WINDOWS_2012 = SystemUtils.b(OS_NAME, string);
        string = "Windows 95";
        IS_OS_WINDOWS_95 = SystemUtils.b(OS_NAME, string);
        string = "Windows 98";
        IS_OS_WINDOWS_98 = SystemUtils.b(OS_NAME, string);
        string = "Windows Me";
        IS_OS_WINDOWS_ME = SystemUtils.b(OS_NAME, string);
        string = "Windows NT";
        IS_OS_WINDOWS_NT = SystemUtils.b(OS_NAME, string);
        string = "Windows XP";
        IS_OS_WINDOWS_XP = SystemUtils.b(OS_NAME, string);
        string = "Windows Vista";
        IS_OS_WINDOWS_VISTA = SystemUtils.b(OS_NAME, string);
        string = "Windows 7";
        IS_OS_WINDOWS_7 = SystemUtils.b(OS_NAME, string);
        string = "Windows 8";
        IS_OS_WINDOWS_8 = SystemUtils.b(OS_NAME, string);
        string = "Windows 10";
        IS_OS_WINDOWS_10 = SystemUtils.b(OS_NAME, string);
        string = "z/OS";
        IS_OS_ZOS = SystemUtils.b(OS_NAME, string);
    }
}

