/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DurationUtils;

public class ThreadUtils {
    public static final a ALWAYS_TRUE_PREDICATE = new a(0);

    public static Thread findThreadById(long l2) {
        Collection<Thread> collection = ThreadUtils.findThreads(new ThreadIdPredicate(l2));
        if (collection.isEmpty()) {
            return null;
        }
        return collection.iterator().next();
    }

    public static Thread findThreadById(long l2, String string) {
        Validate.notNull(string, "threadGroupName", new Object[0]);
        Thread thread = ThreadUtils.findThreadById(l2);
        if (thread != null && thread.getThreadGroup() != null && thread.getThreadGroup().getName().equals(string)) {
            return thread;
        }
        return null;
    }

    public static Thread findThreadById(long l2, ThreadGroup threadGroup) {
        Validate.notNull(threadGroup, "threadGroup", new Object[0]);
        Thread thread = ThreadUtils.findThreadById(l2);
        if (thread != null && threadGroup.equals(thread.getThreadGroup())) {
            return thread;
        }
        return null;
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadGroup object, boolean n2, ThreadGroupPredicate threadGroupPredicate) {
        int n3;
        ThreadGroup[] threadGroupArray;
        Validate.notNull(object, "group", new Object[0]);
        Validate.notNull(threadGroupPredicate, "predicate", new Object[0]);
        int n4 = ((ThreadGroup)object).activeGroupCount();
        do {
            n3 = n4;
        } while ((n4 = ((ThreadGroup)object).enumerate(threadGroupArray = new ThreadGroup[n3 + n3 / 2 + 1], n2 != 0)) >= threadGroupArray.length);
        object = new ArrayList(n4);
        for (n2 = 0; n2 < n4; ++n2) {
            if (!threadGroupPredicate.test(threadGroupArray[n2])) continue;
            object.add(threadGroupArray[n2]);
        }
        return Collections.unmodifiableCollection(object);
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadGroupPredicate threadGroupPredicate) {
        return ThreadUtils.findThreadGroups(ThreadUtils.getSystemThreadGroup(), true, threadGroupPredicate);
    }

    public static Collection<ThreadGroup> findThreadGroupsByName(String string) {
        return ThreadUtils.findThreadGroups(new NamePredicate(string));
    }

    public static Collection<Thread> findThreads(ThreadGroup object, boolean n2, ThreadPredicate threadPredicate) {
        int n3;
        Thread[] threadArray;
        Validate.notNull(object, "The group must not be null", new Object[0]);
        Validate.notNull(threadPredicate, "The predicate must not be null", new Object[0]);
        int n4 = ((ThreadGroup)object).activeCount();
        do {
            n3 = n4;
        } while ((n4 = ((ThreadGroup)object).enumerate(threadArray = new Thread[n3 + n3 / 2 + 1], n2 != 0)) >= threadArray.length);
        object = new ArrayList(n4);
        for (n2 = 0; n2 < n4; ++n2) {
            if (!threadPredicate.test(threadArray[n2])) continue;
            object.add(threadArray[n2]);
        }
        return Collections.unmodifiableCollection(object);
    }

    public static Collection<Thread> findThreads(ThreadPredicate threadPredicate) {
        return ThreadUtils.findThreads(ThreadUtils.getSystemThreadGroup(), true, threadPredicate);
    }

    public static Collection<Thread> findThreadsByName(String string) {
        return ThreadUtils.findThreads(new NamePredicate(string));
    }

    public static Collection<Thread> findThreadsByName(String object, String iterator) {
        Validate.notNull(object, "threadName", new Object[0]);
        Validate.notNull(iterator, "threadGroupName", new Object[0]);
        iterator = ThreadUtils.findThreadGroups(new NamePredicate((String)((Object)iterator)));
        if (iterator.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        object = new NamePredicate((String)object);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ThreadGroup threadGroup = (ThreadGroup)iterator.next();
            arrayList.addAll(ThreadUtils.findThreads(threadGroup, false, (ThreadPredicate)object));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public static Collection<Thread> findThreadsByName(String string, ThreadGroup threadGroup) {
        return ThreadUtils.findThreads(threadGroup, false, new NamePredicate(string));
    }

    public static Collection<ThreadGroup> getAllThreadGroups() {
        return ThreadUtils.findThreadGroups(ALWAYS_TRUE_PREDICATE);
    }

    public static Collection<Thread> getAllThreads() {
        return ThreadUtils.findThreads(ALWAYS_TRUE_PREDICATE);
    }

    public static ThreadGroup getSystemThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    public static void join(Thread thread, Duration duration) {
        DurationUtils.accept(thread::join, duration);
    }

    public static void sleep(Duration duration) {
        DurationUtils.accept(Thread::sleep, duration);
    }

    @FunctionalInterface
    public static interface ThreadPredicate {
        public boolean test(Thread var1);
    }

    public static class ThreadIdPredicate
    implements ThreadPredicate {
        private final long a;

        public ThreadIdPredicate(long l2) {
            if (l2 <= 0L) {
                throw new IllegalArgumentException("The thread id must be greater than zero");
            }
            this.a = l2;
        }

        @Override
        public boolean test(Thread thread) {
            return thread != null && thread.getId() == this.a;
        }
    }

    @FunctionalInterface
    public static interface ThreadGroupPredicate {
        public boolean test(ThreadGroup var1);
    }

    public static class NamePredicate
    implements ThreadGroupPredicate,
    ThreadPredicate {
        private final String a;

        public NamePredicate(String string) {
            Validate.notNull(string, "name", new Object[0]);
            this.a = string;
        }

        @Override
        public boolean test(Thread thread) {
            return thread != null && thread.getName().equals(this.a);
        }

        @Override
        public boolean test(ThreadGroup threadGroup) {
            return threadGroup != null && threadGroup.getName().equals(this.a);
        }
    }

    private static final class a
    implements ThreadGroupPredicate,
    ThreadPredicate {
        private a() {
        }

        @Override
        public final boolean test(Thread thread) {
            return true;
        }

        @Override
        public final boolean test(ThreadGroup threadGroup) {
            return true;
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

