/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Validate {
    public static void isTrue(boolean bl2, String string, long l2) {
        if (!bl2) {
            throw new IllegalArgumentException(String.format(string, l2));
        }
    }

    public static void isTrue(boolean bl2, String string, double d2) {
        if (!bl2) {
            throw new IllegalArgumentException(String.format(string, d2));
        }
    }

    public static void isTrue(boolean bl2, String string, Object ... objectArray) {
        if (!bl2) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    public static void isTrue(boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException("The validated expression is false");
        }
    }

    public static <T> T notNull(T t2) {
        return Validate.notNull(t2, "The validated object is null", new Object[0]);
    }

    public static <T> T notNull(T t2, String string, Object ... objectArray) {
        return Objects.requireNonNull(t2, () -> String.format(string, objectArray));
    }

    public static <T> T[] notEmpty(T[] TArray, String string, Object ... objectArray) {
        Objects.requireNonNull(TArray, () -> String.format(string, objectArray));
        if (TArray.length == 0) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
        return TArray;
    }

    public static <T> T[] notEmpty(T[] TArray) {
        return Validate.notEmpty(TArray, "The validated array is empty", new Object[0]);
    }

    public static <T extends Collection<?>> T notEmpty(T t2, String string, Object ... objectArray) {
        Objects.requireNonNull(t2, () -> String.format(string, objectArray));
        if (t2.isEmpty()) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
        return t2;
    }

    public static <T extends Collection<?>> T notEmpty(T t2) {
        return Validate.notEmpty(t2, "The validated collection is empty", new Object[0]);
    }

    public static <T extends Map<?, ?>> T notEmpty(T t2, String string, Object ... objectArray) {
        Objects.requireNonNull(t2, () -> String.format(string, objectArray));
        if (t2.isEmpty()) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
        return t2;
    }

    public static <T extends Map<?, ?>> T notEmpty(T t2) {
        return Validate.notEmpty(t2, "The validated map is empty", new Object[0]);
    }

    public static <T extends CharSequence> T notEmpty(T t2, String string, Object ... objectArray) {
        Objects.requireNonNull(t2, () -> String.format(string, objectArray));
        if (t2.length() == 0) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
        return t2;
    }

    public static <T extends CharSequence> T notEmpty(T t2) {
        return Validate.notEmpty(t2, "The validated character sequence is empty", new Object[0]);
    }

    public static <T extends CharSequence> T notBlank(T t2, String string, Object ... objectArray) {
        Objects.requireNonNull(t2, () -> String.format(string, objectArray));
        if (StringUtils.isBlank(t2)) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
        return t2;
    }

    public static <T extends CharSequence> T notBlank(T t2) {
        return Validate.notBlank(t2, "The validated character sequence is blank", new Object[0]);
    }

    public static <T> T[] noNullElements(T[] objectArray, String string, Object ... objectArray2) {
        Validate.notNull(objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] != null) continue;
            objectArray = ArrayUtils.add(objectArray2, Integer.valueOf(i2));
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
        return objectArray;
    }

    public static <T> T[] noNullElements(T[] TArray) {
        return Validate.noNullElements(TArray, "The validated array contains null element at index: %d", new Object[0]);
    }

    public static <T extends Iterable<?>> T noNullElements(T object, String string, Object ... objectArray) {
        Validate.notNull(object);
        int n2 = 0;
        Iterator<?> iterator = object.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() == null) {
                object = ArrayUtils.addAll(objectArray, n2);
                throw new IllegalArgumentException(String.format(string, object));
            }
            ++n2;
        }
        return object;
    }

    public static <T extends Iterable<?>> T noNullElements(T t2) {
        return Validate.noNullElements(t2, "The validated collection contains null element at index: %d", new Object[0]);
    }

    public static <T> T[] validIndex(T[] TArray, int n2, String string, Object ... objectArray) {
        Validate.notNull(TArray);
        if (n2 < 0 || n2 >= TArray.length) {
            throw new IndexOutOfBoundsException(String.format(string, objectArray));
        }
        return TArray;
    }

    public static <T> T[] validIndex(T[] TArray, int n2) {
        return Validate.validIndex(TArray, n2, "The validated array index is invalid: %d", new Object[]{n2});
    }

    public static <T extends Collection<?>> T validIndex(T t2, int n2, String string, Object ... objectArray) {
        Validate.notNull(t2);
        if (n2 < 0 || n2 >= t2.size()) {
            throw new IndexOutOfBoundsException(String.format(string, objectArray));
        }
        return t2;
    }

    public static <T extends Collection<?>> T validIndex(T t2, int n2) {
        return Validate.validIndex(t2, n2, "The validated collection index is invalid: %d", new Object[]{n2});
    }

    public static <T extends CharSequence> T validIndex(T t2, int n2, String string, Object ... objectArray) {
        Validate.notNull(t2);
        if (n2 < 0 || n2 >= t2.length()) {
            throw new IndexOutOfBoundsException(String.format(string, objectArray));
        }
        return t2;
    }

    public static <T extends CharSequence> T validIndex(T t2, int n2) {
        return Validate.validIndex(t2, n2, "The validated character sequence index is invalid: %d", n2);
    }

    public static void validState(boolean bl2) {
        if (!bl2) {
            throw new IllegalStateException("The validated state is false");
        }
    }

    public static void validState(boolean bl2, String string, Object ... objectArray) {
        if (!bl2) {
            throw new IllegalStateException(String.format(string, objectArray));
        }
    }

    public static void matchesPattern(CharSequence charSequence, String string) {
        if (!Pattern.matches(string, charSequence)) {
            throw new IllegalArgumentException(String.format("The string %s does not match the pattern %s", charSequence, string));
        }
    }

    public static void matchesPattern(CharSequence charSequence, String string, String string2, Object ... objectArray) {
        if (!Pattern.matches(string, charSequence)) {
            throw new IllegalArgumentException(String.format(string2, objectArray));
        }
    }

    public static void notNaN(double d2) {
        Validate.notNaN(d2, "The validated value is not a number", new Object[0]);
    }

    public static void notNaN(double d2, String string, Object ... objectArray) {
        if (Double.isNaN(d2)) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    public static void finite(double d2) {
        Validate.finite(d2, "The value is invalid: %f", d2);
    }

    public static void finite(double d2, String string, Object ... objectArray) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    public static <T> void inclusiveBetween(T t2, T t3, Comparable<T> comparable) {
        if (comparable.compareTo(t2) < 0 || comparable.compareTo(t3) > 0) {
            throw new IllegalArgumentException(String.format("The value %s is not in the specified inclusive range of %s to %s", comparable, t2, t3));
        }
    }

    public static <T> void inclusiveBetween(T t2, T t3, Comparable<T> comparable, String string, Object ... objectArray) {
        if (comparable.compareTo(t2) < 0 || comparable.compareTo(t3) > 0) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    public static void inclusiveBetween(long l2, long l3, long l4) {
        if (l4 < l2 || l4 > l3) {
            throw new IllegalArgumentException(String.format("The value %s is not in the specified inclusive range of %s to %s", l4, l2, l3));
        }
    }

    public static void inclusiveBetween(long l2, long l3, long l4, String string) {
        if (l4 < l2 || l4 > l3) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void inclusiveBetween(double d2, double d3, double d4) {
        if (d4 < d2 || d4 > d3) {
            throw new IllegalArgumentException(String.format("The value %s is not in the specified inclusive range of %s to %s", d4, d2, d3));
        }
    }

    public static void inclusiveBetween(double d2, double d3, double d4, String string) {
        if (d4 < d2 || d4 > d3) {
            throw new IllegalArgumentException(string);
        }
    }

    public static <T> void exclusiveBetween(T t2, T t3, Comparable<T> comparable) {
        if (comparable.compareTo(t2) <= 0 || comparable.compareTo(t3) >= 0) {
            throw new IllegalArgumentException(String.format("The value %s is not in the specified exclusive range of %s to %s", comparable, t2, t3));
        }
    }

    public static <T> void exclusiveBetween(T t2, T t3, Comparable<T> comparable, String string, Object ... objectArray) {
        if (comparable.compareTo(t2) <= 0 || comparable.compareTo(t3) >= 0) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    public static void exclusiveBetween(long l2, long l3, long l4) {
        if (l4 <= l2 || l4 >= l3) {
            throw new IllegalArgumentException(String.format("The value %s is not in the specified exclusive range of %s to %s", l4, l2, l3));
        }
    }

    public static void exclusiveBetween(long l2, long l3, long l4, String string) {
        if (l4 <= l2 || l4 >= l3) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void exclusiveBetween(double d2, double d3, double d4) {
        if (d4 <= d2 || d4 >= d3) {
            throw new IllegalArgumentException(String.format("The value %s is not in the specified exclusive range of %s to %s", d4, d2, d3));
        }
    }

    public static void exclusiveBetween(double d2, double d3, double d4, String string) {
        if (d4 <= d2 || d4 >= d3) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void isInstanceOf(Class<?> clazz, Object object) {
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException(String.format("Expected type: %s, actual: %s", clazz.getName(), object == null ? "null" : object.getClass().getName()));
        }
    }

    public static void isInstanceOf(Class<?> clazz, Object object, String string, Object ... objectArray) {
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    public static void isAssignableFrom(Class<?> clazz, Class<?> clazz2) {
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException(String.format("Cannot assign a %s to a %s", clazz2 == null ? "null" : clazz2.getName(), clazz.getName()));
        }
    }

    public static void isAssignableFrom(Class<?> clazz, Class<?> clazz2, String string, Object ... objectArray) {
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }
}

