/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.arch;

public class Processor {
    private final Arch a;
    private final Type b;

    public Processor(Arch arch, Type type) {
        this.a = arch;
        this.b = type;
    }

    public Arch getArch() {
        return this.a;
    }

    public Type getType() {
        return this.b;
    }

    public boolean is32Bit() {
        return Arch.BIT_32 == this.a;
    }

    public boolean is64Bit() {
        return Arch.BIT_64 == this.a;
    }

    public boolean isX86() {
        return Type.X86 == this.b;
    }

    public boolean isIA64() {
        return Type.IA_64 == this.b;
    }

    public boolean isPPC() {
        return Type.PPC == this.b;
    }

    public static enum Type {
        X86,
        IA_64,
        PPC,
        UNKNOWN;

    }

    public static enum Arch {
        BIT_32("32-bit"),
        BIT_64("64-bit"),
        UNKNOWN("Unknown");

        private final String a;

        private Arch(String string2) {
            this.a = string2;
        }

        public final String getLabel() {
            return this.a;
        }
    }
}

