/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DiffBuilder<T>
implements Builder<DiffResult<T>> {
    private final List<Diff<?>> a;
    private final boolean b;
    private final T c;
    private final T d;
    private final ToStringStyle e;

    public DiffBuilder(T t2, T t3, ToStringStyle toStringStyle, boolean bl2) {
        Validate.notNull(t2, "lhs", new Object[0]);
        Validate.notNull(t3, "rhs", new Object[0]);
        this.a = new ArrayList();
        this.c = t2;
        this.d = t3;
        this.e = toStringStyle;
        this.b = bl2 && (t2 == t3 || t2.equals(t3));
    }

    public DiffBuilder(T t2, T t3, ToStringStyle toStringStyle) {
        this(t2, t3, toStringStyle, true);
    }

    public DiffBuilder<T> append(String string, boolean bl2, boolean bl3) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (bl2 != bl3) {
            this.a.add(new Diff<Boolean>(this, string, bl2, bl3){
                private /* synthetic */ boolean a;
                private /* synthetic */ boolean b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = bl2;
                    this.b = bl3;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    1 var1_1 = this;
                    return var1_1.b;
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    1 var1_1 = this;
                    return var1_1.a;
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, boolean[] blArray, boolean[] blArray2) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (!Arrays.equals(blArray, blArray2)) {
            this.a.add(new Diff<Boolean[]>(this, string, blArray, blArray2){
                private /* synthetic */ boolean[] a;
                private /* synthetic */ boolean[] b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = blArray;
                    this.b = blArray2;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    11 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.b);
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    11 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.a);
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, byte by, byte by2) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (by != by2) {
            this.a.add(new Diff<Byte>(this, string, by, by2){
                private /* synthetic */ byte a;
                private /* synthetic */ byte b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = by;
                    this.b = by2;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    12 var1_1 = this;
                    return var1_1.b;
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    12 var1_1 = this;
                    return var1_1.a;
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, byte[] byArray, byte[] byArray2) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (!Arrays.equals(byArray, byArray2)) {
            this.a.add(new Diff<Byte[]>(this, string, byArray, byArray2){
                private /* synthetic */ byte[] a;
                private /* synthetic */ byte[] b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = byArray;
                    this.b = byArray2;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    13 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.b);
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    13 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.a);
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, char c2, char c3) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (c2 != c3) {
            this.a.add(new Diff<Character>(this, string, c2, c3){
                private /* synthetic */ char a;
                private /* synthetic */ char b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = c2;
                    this.b = c3;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    14 var1_1 = this;
                    return Character.valueOf(var1_1.b);
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    14 var1_1 = this;
                    return Character.valueOf(var1_1.a);
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, char[] cArray, char[] cArray2) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (!Arrays.equals(cArray, cArray2)) {
            this.a.add(new Diff<Character[]>(this, string, cArray, cArray2){
                private /* synthetic */ char[] a;
                private /* synthetic */ char[] b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = cArray;
                    this.b = cArray2;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    15 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.b);
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    15 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.a);
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, double d2, double d3) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (Double.doubleToLongBits(d2) != Double.doubleToLongBits(d3)) {
            this.a.add(new Diff<Double>(this, string, d2, d3){
                private /* synthetic */ double a;
                private /* synthetic */ double b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = d2;
                    this.b = d3;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    16 var1_1 = this;
                    return var1_1.b;
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    16 var1_1 = this;
                    return var1_1.a;
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, double[] dArray, double[] dArray2) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (!Arrays.equals(dArray, dArray2)) {
            this.a.add(new Diff<Double[]>(this, string, dArray, dArray2){
                private /* synthetic */ double[] a;
                private /* synthetic */ double[] b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = dArray;
                    this.b = dArray2;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    17 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.b);
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    17 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.a);
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, float f2, float f3) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (Float.floatToIntBits(f2) != Float.floatToIntBits(f3)) {
            this.a.add(new Diff<Float>(this, string, f2, f3){
                private /* synthetic */ float a;
                private /* synthetic */ float b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = f2;
                    this.b = f3;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    18 var1_1 = this;
                    return Float.valueOf(var1_1.b);
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    18 var1_1 = this;
                    return Float.valueOf(var1_1.a);
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, float[] fArray, float[] fArray2) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (!Arrays.equals(fArray, fArray2)) {
            this.a.add(new Diff<Float[]>(this, string, fArray, fArray2){
                private /* synthetic */ float[] a;
                private /* synthetic */ float[] b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = fArray;
                    this.b = fArray2;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    2 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.b);
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    2 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.a);
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, int n2, int n3) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (n2 != n3) {
            this.a.add(new Diff<Integer>(this, string, n2, n3){
                private /* synthetic */ int a;
                private /* synthetic */ int b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = n2;
                    this.b = n3;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    3 var1_1 = this;
                    return var1_1.b;
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    3 var1_1 = this;
                    return var1_1.a;
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, int[] nArray, int[] nArray2) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (!Arrays.equals(nArray, nArray2)) {
            this.a.add(new Diff<Integer[]>(this, string, nArray, nArray2){
                private /* synthetic */ int[] a;
                private /* synthetic */ int[] b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = nArray;
                    this.b = nArray2;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    4 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.b);
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    4 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.a);
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, long l2, long l3) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (l2 != l3) {
            this.a.add(new Diff<Long>(this, string, l2, l3){
                private /* synthetic */ long a;
                private /* synthetic */ long b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = l2;
                    this.b = l3;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    5 var1_1 = this;
                    return var1_1.b;
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    5 var1_1 = this;
                    return var1_1.a;
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, long[] lArray, long[] lArray2) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (!Arrays.equals(lArray, lArray2)) {
            this.a.add(new Diff<Long[]>(this, string, lArray, lArray2){
                private /* synthetic */ long[] a;
                private /* synthetic */ long[] b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = lArray;
                    this.b = lArray2;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    6 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.b);
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    6 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.a);
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, short s2, short s3) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (s2 != s3) {
            this.a.add(new Diff<Short>(this, string, s2, s3){
                private /* synthetic */ short a;
                private /* synthetic */ short b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = s2;
                    this.b = s3;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    7 var1_1 = this;
                    return var1_1.b;
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    7 var1_1 = this;
                    return var1_1.a;
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, short[] sArray, short[] sArray2) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (!Arrays.equals(sArray, sArray2)) {
            this.a.add(new Diff<Short[]>(this, string, sArray, sArray2){
                private /* synthetic */ short[] a;
                private /* synthetic */ short[] b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = sArray;
                    this.b = sArray2;
                    super(string);
                }

                @Override
                public final /* synthetic */ Object getRight() {
                    8 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.b);
                }

                @Override
                public final /* synthetic */ Object getLeft() {
                    8 var1_1 = this;
                    return ArrayUtils.toObject(var1_1.a);
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, Object object, Object object2) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (object == object2) {
            return this;
        }
        Object object3 = object != null ? object : object2;
        if (object3.getClass().isArray()) {
            if (object3 instanceof boolean[]) {
                return this.append(string, (boolean[])object, (boolean[])object2);
            }
            if (object3 instanceof byte[]) {
                return this.append(string, (byte[])object, (byte[])object2);
            }
            if (object3 instanceof char[]) {
                return this.append(string, (char[])object, (char[])object2);
            }
            if (object3 instanceof double[]) {
                return this.append(string, (double[])object, (double[])object2);
            }
            if (object3 instanceof float[]) {
                return this.append(string, (float[])object, (float[])object2);
            }
            if (object3 instanceof int[]) {
                return this.append(string, (int[])object, (int[])object2);
            }
            if (object3 instanceof long[]) {
                return this.append(string, (long[])object, (long[])object2);
            }
            if (object3 instanceof short[]) {
                return this.append(string, (short[])object, (short[])object2);
            }
            return this.append(string, (Object[])object, (Object[])object2);
        }
        if (object != null && object.equals(object2)) {
            return this;
        }
        this.a.add(new Diff<Object>(this, string, object, object2){
            private /* synthetic */ Object a;
            private /* synthetic */ Object b;
            private /* synthetic */ DiffBuilder c;
            {
                this.c = diffBuilder;
                this.a = object;
                this.b = object2;
                super(string);
            }

            @Override
            public final Object getLeft() {
                return this.a;
            }

            @Override
            public final Object getRight() {
                return this.b;
            }
        });
        return this;
    }

    public DiffBuilder<T> append(String string, Object[] objectArray, Object[] objectArray2) {
        DiffBuilder.a(string);
        if (this.b) {
            return this;
        }
        if (!Arrays.equals(objectArray, objectArray2)) {
            this.a.add(new Diff<Object[]>(this, string, objectArray, objectArray2){
                private /* synthetic */ Object[] a;
                private /* synthetic */ Object[] b;
                private /* synthetic */ DiffBuilder c;
                {
                    this.c = diffBuilder;
                    this.a = objectArray;
                    this.b = objectArray2;
                    super(string);
                }
            });
        }
        return this;
    }

    public DiffBuilder<T> append(String string, DiffResult<T> object) {
        DiffBuilder.a(string);
        Validate.notNull(object, "diffResult", new Object[0]);
        if (this.b) {
            return this;
        }
        for (Diff<?> diff : ((DiffResult)((Object)object)).getDiffs()) {
            this.append(string + "." + diff.getFieldName(), diff.getLeft(), diff.getRight());
        }
        return this;
    }

    @Override
    public DiffResult<T> build() {
        return new DiffResult<T>(this.c, this.d, this.a, this.e);
    }

    private static void a(String string) {
        Validate.notNull(string, "fieldName", new Object[0]);
    }
}

