/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DiffResult<T>
implements Iterable<Diff<?>> {
    public static final String OBJECTS_SAME_STRING = "";
    private final List<Diff<?>> a;
    private final T b;
    private final T c;
    private final ToStringStyle d;

    DiffResult(T t2, T t3, List<Diff<?>> list, ToStringStyle toStringStyle) {
        Validate.notNull(t2, "lhs", new Object[0]);
        Validate.notNull(t3, "rhs", new Object[0]);
        Validate.notNull(list, "diffList", new Object[0]);
        this.a = list;
        this.b = t2;
        this.c = t3;
        if (toStringStyle == null) {
            this.d = ToStringStyle.DEFAULT_STYLE;
            return;
        }
        this.d = toStringStyle;
    }

    public T getLeft() {
        return this.b;
    }

    public T getRight() {
        return this.c;
    }

    public List<Diff<?>> getDiffs() {
        return Collections.unmodifiableList(this.a);
    }

    public int getNumberOfDiffs() {
        return this.a.size();
    }

    public ToStringStyle getToStringStyle() {
        return this.d;
    }

    public String toString() {
        DiffResult diffResult = this;
        return diffResult.toString(diffResult.d);
    }

    public String toString(ToStringStyle object) {
        if (this.a.isEmpty()) {
            return OBJECTS_SAME_STRING;
        }
        ToStringBuilder toStringBuilder = new ToStringBuilder(this.b, (ToStringStyle)object);
        object = new ToStringBuilder(this.c, (ToStringStyle)object);
        for (Diff<?> diff : this.a) {
            toStringBuilder.append(diff.getFieldName(), diff.getLeft());
            ((ToStringBuilder)object).append(diff.getFieldName(), diff.getRight());
        }
        return String.format("%s %s %s", toStringBuilder.build(), "differs from", ((ToStringBuilder)object).build());
    }

    @Override
    public Iterator<Diff<?>> iterator() {
        return this.a.iterator();
    }
}

