/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ToStringStyle
implements Serializable {
    public static final ToStringStyle DEFAULT_STYLE = new a();
    public static final ToStringStyle MULTI_LINE_STYLE = new c();
    public static final ToStringStyle NO_FIELD_NAMES_STYLE = new e();
    public static final ToStringStyle SHORT_PREFIX_STYLE = new f();
    public static final ToStringStyle SIMPLE_STYLE = new g();
    public static final ToStringStyle NO_CLASS_NAME_STYLE = new d();
    public static final ToStringStyle JSON_STYLE = new b();
    private static final ThreadLocal<WeakHashMap<Object, Object>> a = new ThreadLocal();
    private boolean b = true;
    private boolean c = true;
    private boolean d;
    private boolean e = true;
    private String f = "[";
    private String g = "]";
    private String h = "=";
    private boolean i;
    private boolean j;
    private String k = ",";
    private String l = "{";
    private String m = ",";
    private boolean n = true;
    private String o = "}";
    private boolean p = true;
    private String q = "<null>";
    private String r = "<size=";
    private String s = ">";
    private String t = "<";
    private String u = ">";

    private static Map<Object, Object> a() {
        return a.get();
    }

    private static void a(Object object) {
        if (object != null) {
            Map<Object, Object> map = ToStringStyle.a();
            if (map == null) {
                a.set(new WeakHashMap());
            }
            ToStringStyle.a().put(object, null);
        }
    }

    private static void b(Object object) {
        Map<Object, Object> map;
        if (object != null && (map = ToStringStyle.a()) != null) {
            map.remove(object);
            if (map.isEmpty()) {
                a.remove();
            }
        }
    }

    protected ToStringStyle() {
    }

    public void appendSuper(StringBuffer stringBuffer, String string) {
        this.appendToString(stringBuffer, string);
    }

    public void appendToString(StringBuffer stringBuffer, String string) {
        int n2;
        int n3;
        if (string != null && (n3 = string.indexOf(this.f) + this.f.length()) != (n2 = string.lastIndexOf(this.g)) && n3 >= 0 && n2 >= 0) {
            if (this.i) {
                this.removeLastFieldSeparator(stringBuffer);
            }
            stringBuffer.append(string, n3, n2);
            this.appendFieldSeparator(stringBuffer);
        }
    }

    public void appendStart(StringBuffer stringBuffer, Object object) {
        if (object != null) {
            this.appendClassName(stringBuffer, object);
            this.appendIdentityHashCode(stringBuffer, object);
            this.appendContentStart(stringBuffer);
            if (this.i) {
                this.appendFieldSeparator(stringBuffer);
            }
        }
    }

    public void appendEnd(StringBuffer stringBuffer, Object object) {
        if (!this.j) {
            this.removeLastFieldSeparator(stringBuffer);
        }
        this.appendContentEnd(stringBuffer);
        ToStringStyle.b(object);
    }

    protected void removeLastFieldSeparator(StringBuffer stringBuffer) {
        if (StringUtils.endsWith(stringBuffer, this.k)) {
            StringBuffer stringBuffer2 = stringBuffer;
            stringBuffer2.setLength(stringBuffer2.length() - this.k.length());
        }
    }

    public void append(StringBuffer stringBuffer, String string, Object object, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string);
        if (object == null) {
            this.appendNullText(stringBuffer, string);
        } else {
            this.appendInternal(stringBuffer, string, object, this.isFullDetail(bl2));
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendInternal(StringBuffer stringBuffer, String string, Object object, boolean bl2) {
        Object object2 = object;
        Map<Object, Object> map = ToStringStyle.a();
        if (map != null && map.containsKey(object2) && !(object instanceof Number) && !(object instanceof Boolean) && !(object instanceof Character)) {
            this.appendCyclicObject(stringBuffer, string, object);
            return;
        }
        ToStringStyle.a(object);
        try {
            if (object instanceof Collection) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string, (Collection)object);
                } else {
                    this.appendSummarySize(stringBuffer, string, ((Collection)object).size());
                }
            } else if (object instanceof Map) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string, (Map)object);
                } else {
                    this.appendSummarySize(stringBuffer, string, ((Map)object).size());
                }
            } else if (object instanceof long[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string, (long[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (long[])object);
                }
            } else if (object instanceof int[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string, (int[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (int[])object);
                }
            } else if (object instanceof short[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string, (short[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (short[])object);
                }
            } else if (object instanceof byte[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string, (byte[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (byte[])object);
                }
            } else if (object instanceof char[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string, (char[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (char[])object);
                }
            } else if (object instanceof double[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string, (double[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (double[])object);
                }
            } else if (object instanceof float[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string, (float[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (float[])object);
                }
            } else if (object instanceof boolean[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string, (boolean[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (boolean[])object);
                }
            } else if (object.getClass().isArray()) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string, (Object[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (Object[])object);
                }
            } else if (bl2) {
                this.appendDetail(stringBuffer, string, object);
            } else {
                this.appendSummary(stringBuffer, string, object);
            }
            return;
        }
        finally {
            ToStringStyle.b(object);
        }
    }

    protected void appendCyclicObject(StringBuffer stringBuffer, String string, Object object) {
        ObjectUtils.identityToString(stringBuffer, object);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, Object object) {
        stringBuffer.append(object);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, Collection<?> collection) {
        stringBuffer.append(collection);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, Map<?, ?> map) {
        stringBuffer.append(map);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, Object object) {
        stringBuffer.append(this.t);
        stringBuffer.append(this.getShortClassName(object.getClass()));
        stringBuffer.append(this.u);
    }

    public void append(StringBuffer stringBuffer, String string, long l2) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, l2);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, long l2) {
        stringBuffer.append(l2);
    }

    public void append(StringBuffer stringBuffer, String string, int n2) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, n2);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, int n2) {
        stringBuffer.append(n2);
    }

    public void append(StringBuffer stringBuffer, String string, short s2) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, s2);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, short s2) {
        stringBuffer.append(s2);
    }

    public void append(StringBuffer stringBuffer, String string, byte by) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, by);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, byte by) {
        stringBuffer.append(by);
    }

    public void append(StringBuffer stringBuffer, String string, char c2) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, c2);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, char c2) {
        stringBuffer.append(c2);
    }

    public void append(StringBuffer stringBuffer, String string, double d2) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, d2);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, double d2) {
        stringBuffer.append(d2);
    }

    public void append(StringBuffer stringBuffer, String string, float f2) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, f2);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, float f2) {
        stringBuffer.append(f2);
    }

    public void append(StringBuffer stringBuffer, String string, boolean bl2) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, bl2);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, boolean bl2) {
        stringBuffer.append(bl2);
    }

    public void append(StringBuffer stringBuffer, String string, Object[] objectArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string);
        if (objectArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string, objectArray);
        } else {
            this.appendSummary(stringBuffer, string, objectArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, Object[] objectArray) {
        stringBuffer.append(this.l);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            this.appendDetail(stringBuffer, string, i2, object);
        }
        stringBuffer.append(this.o);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, int n2, Object object) {
        if (n2 > 0) {
            stringBuffer.append(this.m);
        }
        if (object == null) {
            this.appendNullText(stringBuffer, string);
            return;
        }
        this.appendInternal(stringBuffer, string, object, this.n);
    }

    protected void reflectionAppendArrayDetail(StringBuffer stringBuffer, String string, Object object) {
        stringBuffer.append(this.l);
        int n2 = Array.getLength(object);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = Array.get(object, i2);
            this.appendDetail(stringBuffer, string, i2, object2);
        }
        stringBuffer.append(this.o);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, Object[] objectArray) {
        this.appendSummarySize(stringBuffer, string, objectArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, long[] lArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string);
        if (lArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string, lArray);
        } else {
            this.appendSummary(stringBuffer, string, lArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, long[] lArray) {
        stringBuffer.append(this.l);
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.m);
            }
            this.appendDetail(stringBuffer, string, lArray[i2]);
        }
        stringBuffer.append(this.o);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, long[] lArray) {
        this.appendSummarySize(stringBuffer, string, lArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, int[] nArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string);
        if (nArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string, nArray);
        } else {
            this.appendSummary(stringBuffer, string, nArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, int[] nArray) {
        stringBuffer.append(this.l);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.m);
            }
            this.appendDetail(stringBuffer, string, nArray[i2]);
        }
        stringBuffer.append(this.o);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, int[] nArray) {
        this.appendSummarySize(stringBuffer, string, nArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, short[] sArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string);
        if (sArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string, sArray);
        } else {
            this.appendSummary(stringBuffer, string, sArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, short[] sArray) {
        stringBuffer.append(this.l);
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.m);
            }
            this.appendDetail(stringBuffer, string, sArray[i2]);
        }
        stringBuffer.append(this.o);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, short[] sArray) {
        this.appendSummarySize(stringBuffer, string, sArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, byte[] byArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string);
        if (byArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string, byArray);
        } else {
            this.appendSummary(stringBuffer, string, byArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, byte[] byArray) {
        stringBuffer.append(this.l);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.m);
            }
            this.appendDetail(stringBuffer, string, byArray[i2]);
        }
        stringBuffer.append(this.o);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, byte[] byArray) {
        this.appendSummarySize(stringBuffer, string, byArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, char[] cArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string);
        if (cArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string, cArray);
        } else {
            this.appendSummary(stringBuffer, string, cArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, char[] cArray) {
        stringBuffer.append(this.l);
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.m);
            }
            this.appendDetail(stringBuffer, string, cArray[i2]);
        }
        stringBuffer.append(this.o);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, char[] cArray) {
        this.appendSummarySize(stringBuffer, string, cArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, double[] dArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string);
        if (dArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string, dArray);
        } else {
            this.appendSummary(stringBuffer, string, dArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, double[] dArray) {
        stringBuffer.append(this.l);
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.m);
            }
            this.appendDetail(stringBuffer, string, dArray[i2]);
        }
        stringBuffer.append(this.o);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, double[] dArray) {
        this.appendSummarySize(stringBuffer, string, dArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, float[] fArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string);
        if (fArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string, fArray);
        } else {
            this.appendSummary(stringBuffer, string, fArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, float[] fArray) {
        stringBuffer.append(this.l);
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.m);
            }
            this.appendDetail(stringBuffer, string, fArray[i2]);
        }
        stringBuffer.append(this.o);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, float[] fArray) {
        this.appendSummarySize(stringBuffer, string, fArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, boolean[] blArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string);
        if (blArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string, blArray);
        } else {
            this.appendSummary(stringBuffer, string, blArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, boolean[] blArray) {
        stringBuffer.append(this.l);
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.m);
            }
            this.appendDetail(stringBuffer, string, blArray[i2]);
        }
        stringBuffer.append(this.o);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, boolean[] blArray) {
        this.appendSummarySize(stringBuffer, string, blArray.length);
    }

    protected void appendClassName(StringBuffer stringBuffer, Object object) {
        if (this.c && object != null) {
            ToStringStyle.a(object);
            if (this.d) {
                stringBuffer.append(this.getShortClassName(object.getClass()));
                return;
            }
            stringBuffer.append(object.getClass().getName());
        }
    }

    protected void appendIdentityHashCode(StringBuffer stringBuffer, Object object) {
        if (this.isUseIdentityHashCode() && object != null) {
            ToStringStyle.a(object);
            stringBuffer.append('@');
            stringBuffer.append(Integer.toHexString(System.identityHashCode(object)));
        }
    }

    protected void appendContentStart(StringBuffer stringBuffer) {
        stringBuffer.append(this.f);
    }

    protected void appendContentEnd(StringBuffer stringBuffer) {
        stringBuffer.append(this.g);
    }

    protected void appendNullText(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.q);
    }

    protected void appendFieldSeparator(StringBuffer stringBuffer) {
        stringBuffer.append(this.k);
    }

    protected void appendFieldStart(StringBuffer stringBuffer, String string) {
        if (this.b && string != null) {
            stringBuffer.append(string);
            stringBuffer.append(this.h);
        }
    }

    protected void appendFieldEnd(StringBuffer stringBuffer, String string) {
        this.appendFieldSeparator(stringBuffer);
    }

    protected void appendSummarySize(StringBuffer stringBuffer, String string, int n2) {
        stringBuffer.append(this.r);
        stringBuffer.append(n2);
        stringBuffer.append(this.s);
    }

    protected boolean isFullDetail(Boolean bl2) {
        if (bl2 == null) {
            return this.p;
        }
        return bl2;
    }

    protected String getShortClassName(Class<?> clazz) {
        return ClassUtils.getShortClassName(clazz);
    }

    protected boolean isUseClassName() {
        return this.c;
    }

    protected void setUseClassName(boolean bl2) {
        this.c = bl2;
    }

    protected boolean isUseShortClassName() {
        return this.d;
    }

    protected void setUseShortClassName(boolean bl2) {
        this.d = bl2;
    }

    protected boolean isUseIdentityHashCode() {
        return this.e;
    }

    protected void setUseIdentityHashCode(boolean bl2) {
        this.e = bl2;
    }

    protected boolean isUseFieldNames() {
        return this.b;
    }

    protected void setUseFieldNames(boolean bl2) {
        this.b = bl2;
    }

    protected boolean isDefaultFullDetail() {
        return this.p;
    }

    protected void setDefaultFullDetail(boolean bl2) {
        this.p = bl2;
    }

    protected boolean isArrayContentDetail() {
        return this.n;
    }

    protected void setArrayContentDetail(boolean bl2) {
        this.n = bl2;
    }

    protected String getArrayStart() {
        return this.l;
    }

    protected void setArrayStart(String string) {
        if (string == null) {
            string = "";
        }
        this.l = string;
    }

    protected String getArrayEnd() {
        return this.o;
    }

    protected void setArrayEnd(String string) {
        if (string == null) {
            string = "";
        }
        this.o = string;
    }

    protected String getArraySeparator() {
        return this.m;
    }

    protected void setArraySeparator(String string) {
        if (string == null) {
            string = "";
        }
        this.m = string;
    }

    protected String getContentStart() {
        return this.f;
    }

    protected void setContentStart(String string) {
        if (string == null) {
            string = "";
        }
        this.f = string;
    }

    protected String getContentEnd() {
        return this.g;
    }

    protected void setContentEnd(String string) {
        if (string == null) {
            string = "";
        }
        this.g = string;
    }

    protected String getFieldNameValueSeparator() {
        return this.h;
    }

    protected void setFieldNameValueSeparator(String string) {
        if (string == null) {
            string = "";
        }
        this.h = string;
    }

    protected String getFieldSeparator() {
        return this.k;
    }

    protected void setFieldSeparator(String string) {
        if (string == null) {
            string = "";
        }
        this.k = string;
    }

    protected boolean isFieldSeparatorAtStart() {
        return this.i;
    }

    protected void setFieldSeparatorAtStart(boolean bl2) {
        this.i = bl2;
    }

    protected boolean isFieldSeparatorAtEnd() {
        return this.j;
    }

    protected void setFieldSeparatorAtEnd(boolean bl2) {
        this.j = bl2;
    }

    protected String getNullText() {
        return this.q;
    }

    protected void setNullText(String string) {
        if (string == null) {
            string = "";
        }
        this.q = string;
    }

    protected String getSizeStartText() {
        return this.r;
    }

    protected void setSizeStartText(String string) {
        if (string == null) {
            string = "";
        }
        this.r = string;
    }

    protected String getSizeEndText() {
        return this.s;
    }

    protected void setSizeEndText(String string) {
        if (string == null) {
            string = "";
        }
        this.s = string;
    }

    protected String getSummaryObjectStartText() {
        return this.t;
    }

    protected void setSummaryObjectStartText(String string) {
        if (string == null) {
            string = "";
        }
        this.t = string;
    }

    protected String getSummaryObjectEndText() {
        return this.u;
    }

    protected void setSummaryObjectEndText(String string) {
        if (string == null) {
            string = "";
        }
        this.u = string;
    }

    private static final class b
    extends ToStringStyle {
        b() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setContentStart("{");
            this.setContentEnd("}");
            this.setArrayStart("[");
            this.setArrayEnd("]");
            this.setFieldSeparator(",");
            this.setFieldNameValueSeparator(":");
            this.setNullText("null");
            this.setSummaryObjectStartText("\"<");
            this.setSummaryObjectEndText(">\"");
            this.setSizeStartText("\"<size=");
            this.setSizeEndText(">\"");
        }

        @Override
        public final void append(StringBuffer stringBuffer, String string, Object[] objectArray, Boolean bl2) {
            if (string == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(bl2)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(stringBuffer, string, objectArray, bl2);
        }

        @Override
        public final void append(StringBuffer stringBuffer, String string, long[] lArray, Boolean bl2) {
            if (string == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(bl2)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(stringBuffer, string, lArray, bl2);
        }

        @Override
        public final void append(StringBuffer stringBuffer, String string, int[] nArray, Boolean bl2) {
            if (string == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(bl2)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(stringBuffer, string, nArray, bl2);
        }

        @Override
        public final void append(StringBuffer stringBuffer, String string, short[] sArray, Boolean bl2) {
            if (string == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(bl2)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(stringBuffer, string, sArray, bl2);
        }

        @Override
        public final void append(StringBuffer stringBuffer, String string, byte[] byArray, Boolean bl2) {
            if (string == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(bl2)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(stringBuffer, string, byArray, bl2);
        }

        @Override
        public final void append(StringBuffer stringBuffer, String string, char[] cArray, Boolean bl2) {
            if (string == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(bl2)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(stringBuffer, string, cArray, bl2);
        }

        @Override
        public final void append(StringBuffer stringBuffer, String string, double[] dArray, Boolean bl2) {
            if (string == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(bl2)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(stringBuffer, string, dArray, bl2);
        }

        @Override
        public final void append(StringBuffer stringBuffer, String string, float[] fArray, Boolean bl2) {
            if (string == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(bl2)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(stringBuffer, string, fArray, bl2);
        }

        @Override
        public final void append(StringBuffer stringBuffer, String string, boolean[] blArray, Boolean bl2) {
            if (string == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(bl2)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(stringBuffer, string, blArray, bl2);
        }

        @Override
        public final void append(StringBuffer stringBuffer, String string, Object object, Boolean bl2) {
            if (string == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(bl2)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(stringBuffer, string, object, bl2);
        }

        @Override
        protected final void appendDetail(StringBuffer stringBuffer, String string, char c2) {
            org.apache.commons.lang3.builder.ToStringStyle$b.a(stringBuffer, String.valueOf(c2));
        }

        @Override
        protected final void appendDetail(StringBuffer stringBuffer, String string, Object object) {
            while (true) {
                b b2;
                if (object == null) {
                    this.appendNullText(stringBuffer, string);
                    return;
                }
                if (object instanceof String || object instanceof Character) {
                    org.apache.commons.lang3.builder.ToStringStyle$b.a(stringBuffer, object.toString());
                    return;
                }
                if (object instanceof Number || object instanceof Boolean) {
                    stringBuffer.append(object);
                    return;
                }
                String string2 = object.toString();
                String string3 = string2;
                if (string3.startsWith((b2 = this).getContentStart()) && string3.endsWith(b2.getContentEnd()) || (string3 = string2).startsWith((b2 = this).getArrayStart()) && string3.endsWith(b2.getArrayEnd())) {
                    stringBuffer.append(object);
                    return;
                }
                object = string2;
            }
        }

        @Override
        protected final void appendDetail(StringBuffer stringBuffer, String string, Collection<?> object) {
            if (object != null && !object.isEmpty()) {
                stringBuffer.append(this.getArrayStart());
                int n2 = 0;
                object = object.iterator();
                while (object.hasNext()) {
                    Object e2 = object.next();
                    this.appendDetail(stringBuffer, string, n2++, e2);
                }
                stringBuffer.append(this.getArrayEnd());
                return;
            }
            stringBuffer.append(object);
        }

        @Override
        protected final void appendDetail(StringBuffer stringBuffer, String string, Map<?, ?> object) {
            if (object != null && !object.isEmpty()) {
                stringBuffer.append(this.getContentStart());
                boolean bl2 = true;
                for (Map.Entry entry : object.entrySet()) {
                    String string2 = Objects.toString(entry.getKey(), null);
                    if (string2 == null) continue;
                    if (bl2) {
                        bl2 = false;
                    } else {
                        this.appendFieldEnd(stringBuffer, string2);
                    }
                    this.appendFieldStart(stringBuffer, string2);
                    Object v2 = entry.getValue();
                    if (v2 == null) {
                        this.appendNullText(stringBuffer, string2);
                        continue;
                    }
                    this.appendInternal(stringBuffer, string2, v2, true);
                }
                stringBuffer.append(this.getContentEnd());
                return;
            }
            stringBuffer.append(object);
        }

        private static void a(StringBuffer stringBuffer, String string) {
            stringBuffer.append('\"').append(StringEscapeUtils.escapeJson(string)).append('\"');
        }

        @Override
        protected final void appendFieldStart(StringBuffer stringBuffer, String string) {
            if (string == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            super.appendFieldStart(stringBuffer, "\"" + StringEscapeUtils.escapeJson(string) + "\"");
        }
    }

    private static final class d
    extends ToStringStyle {
        d() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
        }
    }

    private static final class c
    extends ToStringStyle {
        c() {
            this.setContentStart("[");
            this.setFieldSeparator(System.lineSeparator() + "  ");
            this.setFieldSeparatorAtStart(true);
            this.setContentEnd(System.lineSeparator() + "]");
        }
    }

    private static final class g
    extends ToStringStyle {
        g() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setUseFieldNames(false);
            this.setContentStart("");
            this.setContentEnd("");
        }
    }

    private static final class f
    extends ToStringStyle {
        f() {
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
        }
    }

    private static final class e
    extends ToStringStyle {
        e() {
            this.setUseFieldNames(false);
        }
    }

    private static final class a
    extends ToStringStyle {
        a() {
        }
    }
}

