/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;

public abstract class BackgroundInitializer<T>
implements ConcurrentInitializer<T> {
    private ExecutorService a;
    private ExecutorService b;
    private Future<T> c;

    protected BackgroundInitializer() {
        this(null);
    }

    protected BackgroundInitializer(ExecutorService executorService) {
        this.setExternalExecutor(executorService);
    }

    public final synchronized ExecutorService getExternalExecutor() {
        return this.a;
    }

    public synchronized boolean isStarted() {
        return this.c != null;
    }

    public final synchronized void setExternalExecutor(ExecutorService executorService) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot set ExecutorService after start()!");
        }
        this.a = executorService;
    }

    public synchronized boolean start() {
        if (!this.isStarted()) {
            Object object;
            this.b = this.getExternalExecutor();
            if (this.b == null) {
                BackgroundInitializer backgroundInitializer = this;
                object = backgroundInitializer;
                object = Executors.newFixedThreadPool(backgroundInitializer.getTaskCount());
                backgroundInitializer.b = object;
            } else {
                object = null;
            }
            BackgroundInitializer backgroundInitializer = object;
            object = this;
            this.c = this.b.submit(new a((BackgroundInitializer)object, (ExecutorService)((Object)backgroundInitializer)));
            return true;
        }
        return false;
    }

    @Override
    public T get() {
        try {
            return this.getFuture().get();
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            ConcurrentUtils.handleCause(executionException);
            return null;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new ConcurrentException(interruptedException);
        }
    }

    public synchronized Future<T> getFuture() {
        if (this.c == null) {
            throw new IllegalStateException("start() must be called first!");
        }
        return this.c;
    }

    protected final synchronized ExecutorService getActiveExecutor() {
        return this.b;
    }

    protected int getTaskCount() {
        return 1;
    }

    protected abstract T initialize();

    private final class a
    implements Callable<T> {
        private final ExecutorService a;
        private /* synthetic */ BackgroundInitializer b;

        a(BackgroundInitializer backgroundInitializer, ExecutorService executorService) {
            this.b = backgroundInitializer;
            this.a = executorService;
        }

        @Override
        public final T call() {
            try {
                Object t2 = this.b.initialize();
                return t2;
            }
            finally {
                if (this.a != null) {
                    this.a.shutdown();
                }
            }
        }
    }
}

