/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.Validate;

public class BasicThreadFactory
implements ThreadFactory {
    private final AtomicLong a;
    private final ThreadFactory b;
    private final Thread.UncaughtExceptionHandler c;
    private final String d;
    private final Integer e;
    private final Boolean f;

    private BasicThreadFactory(Builder builder) {
        this.b = builder.a == null ? Executors.defaultThreadFactory() : builder.a;
        this.d = builder.c;
        this.e = builder.d;
        this.f = builder.e;
        this.c = builder.b;
        this.a = new AtomicLong();
    }

    public final ThreadFactory getWrappedFactory() {
        return this.b;
    }

    public final String getNamingPattern() {
        return this.d;
    }

    public final Boolean getDaemonFlag() {
        return this.f;
    }

    public final Integer getPriority() {
        return this.e;
    }

    public final Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.c;
    }

    public long getThreadCount() {
        return this.a.get();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Runnable runnable2 = runnable = this.getWrappedFactory().newThread(runnable);
        BasicThreadFactory basicThreadFactory = this;
        if (basicThreadFactory.getNamingPattern() != null) {
            Long l2 = basicThreadFactory.a.incrementAndGet();
            ((Thread)runnable2).setName(String.format(basicThreadFactory.getNamingPattern(), l2));
        }
        if (basicThreadFactory.getUncaughtExceptionHandler() != null) {
            ((Thread)runnable2).setUncaughtExceptionHandler(basicThreadFactory.getUncaughtExceptionHandler());
        }
        if (basicThreadFactory.getPriority() != null) {
            ((Thread)runnable2).setPriority(basicThreadFactory.getPriority());
        }
        if (basicThreadFactory.getDaemonFlag() != null) {
            ((Thread)runnable2).setDaemon(basicThreadFactory.getDaemonFlag());
        }
        return runnable;
    }

    /* synthetic */ BasicThreadFactory(Builder builder, byte by) {
        this(builder);
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<BasicThreadFactory> {
        private ThreadFactory a;
        private Thread.UncaughtExceptionHandler b;
        private String c;
        private Integer d;
        private Boolean e;

        public Builder wrappedFactory(ThreadFactory threadFactory) {
            Validate.notNull(threadFactory, "factory", new Object[0]);
            this.a = threadFactory;
            return this;
        }

        public Builder namingPattern(String string) {
            Validate.notNull(string, "pattern", new Object[0]);
            this.c = string;
            return this;
        }

        public Builder daemon(boolean bl2) {
            this.e = bl2;
            return this;
        }

        public Builder priority(int n2) {
            this.d = n2;
            return this;
        }

        public Builder uncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            Validate.notNull(uncaughtExceptionHandler, "handler", new Object[0]);
            this.b = uncaughtExceptionHandler;
            return this;
        }

        public void reset() {
            this.a = null;
            this.b = null;
            this.c = null;
            this.d = null;
            this.e = null;
        }

        @Override
        public BasicThreadFactory build() {
            BasicThreadFactory basicThreadFactory = new BasicThreadFactory(this, 0);
            this.reset();
            return basicThreadFactory;
        }
    }
}

