/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;

public class MultiBackgroundInitializer
extends BackgroundInitializer<MultiBackgroundInitializerResults> {
    private final Map<String, BackgroundInitializer<?>> a = new HashMap();

    public MultiBackgroundInitializer() {
    }

    public MultiBackgroundInitializer(ExecutorService executorService) {
        super(executorService);
    }

    public void addInitializer(String string, BackgroundInitializer<?> backgroundInitializer) {
        Validate.notNull(string, "name", new Object[0]);
        Validate.notNull(backgroundInitializer, "backgroundInitializer", new Object[0]);
        MultiBackgroundInitializer multiBackgroundInitializer = this;
        synchronized (multiBackgroundInitializer) {
            if (this.isStarted()) {
                throw new IllegalStateException("addInitializer() must not be called after start()!");
            }
            this.a.put(string, backgroundInitializer);
            return;
        }
    }

    @Override
    protected int getTaskCount() {
        int n2 = 1;
        for (BackgroundInitializer<?> backgroundInitializer : this.a.values()) {
            n2 += backgroundInitializer.getTaskCount();
        }
        return n2;
    }

    @Override
    protected MultiBackgroundInitializerResults initialize() {
        Object object2;
        HashMap hashMap;
        Iterator iterator = this;
        synchronized (iterator) {
            hashMap = new HashMap(this.a);
        }
        iterator = this.getActiveExecutor();
        for (Object object2 : hashMap.values()) {
            if (((BackgroundInitializer)object2).getExternalExecutor() == null) {
                ((BackgroundInitializer)object2).setExternalExecutor((ExecutorService)((Object)iterator));
            }
            ((BackgroundInitializer)object2).start();
        }
        HashMap hashMap2 = new HashMap();
        object2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            try {
                hashMap2.put(entry.getKey(), ((BackgroundInitializer)entry.getValue()).get());
            }
            catch (ConcurrentException concurrentException) {
                object2.put(entry.getKey(), concurrentException);
            }
        }
        return new MultiBackgroundInitializerResults(hashMap, hashMap2, (Map)object2, 0);
    }

    public static class MultiBackgroundInitializerResults {
        private final Map<String, BackgroundInitializer<?>> a;
        private final Map<String, Object> b;
        private final Map<String, ConcurrentException> c;

        private MultiBackgroundInitializerResults(Map<String, BackgroundInitializer<?>> map, Map<String, Object> map2, Map<String, ConcurrentException> map3) {
            this.a = map;
            this.b = map2;
            this.c = map3;
        }

        public BackgroundInitializer<?> getInitializer(String string) {
            return this.a(string);
        }

        public Object getResultObject(String string) {
            this.a(string);
            return this.b.get(string);
        }

        public boolean isException(String string) {
            this.a(string);
            return this.c.containsKey(string);
        }

        public ConcurrentException getException(String string) {
            this.a(string);
            return this.c.get(string);
        }

        public Set<String> initializerNames() {
            return Collections.unmodifiableSet(this.a.keySet());
        }

        public boolean isSuccessful() {
            return this.c.isEmpty();
        }

        private BackgroundInitializer<?> a(String string) {
            BackgroundInitializer<?> backgroundInitializer = this.a.get(string);
            if (backgroundInitializer == null) {
                throw new NoSuchElementException("No child initializer with name " + string);
            }
            return backgroundInitializer;
        }

        /* synthetic */ MultiBackgroundInitializerResults(Map map, Map map2, Map map3, byte by) {
            this(map, map2, map3);
        }
    }
}

