/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;

public class TimedSemaphore {
    public static final int NO_LIMIT = 0;
    private final ScheduledExecutorService a;
    private final long b;
    private final TimeUnit c;
    private final boolean d;
    private ScheduledFuture<?> e;
    private long f;
    private long g;
    private int h;
    private int i;
    private int j;
    private boolean k;

    public TimedSemaphore(long l2, TimeUnit timeUnit, int n2) {
        this(null, l2, timeUnit, n2);
    }

    public TimedSemaphore(ScheduledExecutorService scheduledExecutorService, long l2, TimeUnit timeUnit, int n2) {
        Validate.inclusiveBetween(1L, Long.MAX_VALUE, l2, "Time period must be greater than 0!");
        this.b = l2;
        this.c = timeUnit;
        if (scheduledExecutorService != null) {
            this.a = scheduledExecutorService;
            this.d = false;
        } else {
            scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
            ((ScheduledThreadPoolExecutor)scheduledExecutorService).setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            ((ScheduledThreadPoolExecutor)scheduledExecutorService).setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.a = scheduledExecutorService;
            this.d = true;
        }
        this.setLimit(n2);
    }

    public final synchronized int getLimit() {
        return this.h;
    }

    public final synchronized void setLimit(int n2) {
        this.h = n2;
    }

    public synchronized void shutdown() {
        if (!this.k) {
            if (this.d) {
                this.getExecutorService().shutdownNow();
            }
            if (this.e != null) {
                this.e.cancel(false);
            }
            this.k = true;
        }
    }

    public synchronized boolean isShutdown() {
        return this.k;
    }

    public synchronized void acquire() {
        boolean bl2;
        this.b();
        do {
            if (bl2 = this.c()) continue;
            this.wait();
        } while (!bl2);
    }

    public synchronized boolean tryAcquire() {
        this.b();
        return this.c();
    }

    public synchronized int getLastAcquiresPerPeriod() {
        return this.j;
    }

    public synchronized int getAcquireCount() {
        return this.i;
    }

    public synchronized int getAvailablePermits() {
        return this.getLimit() - this.getAcquireCount();
    }

    public synchronized double getAverageCallsPerPeriod() {
        if (this.g == 0L) {
            return 0.0;
        }
        return (double)this.f / (double)this.g;
    }

    public long getPeriod() {
        return this.b;
    }

    public TimeUnit getUnit() {
        return this.c;
    }

    protected ScheduledExecutorService getExecutorService() {
        return this.a;
    }

    protected ScheduledFuture<?> startTimer() {
        return this.getExecutorService().scheduleAtFixedRate(this::a, this.getPeriod(), this.getPeriod(), this.getUnit());
    }

    synchronized void a() {
        this.j = this.i;
        this.f += (long)this.i;
        ++this.g;
        this.i = 0;
        this.notifyAll();
    }

    private void b() {
        if (this.isShutdown()) {
            throw new IllegalStateException("TimedSemaphore is shut down!");
        }
        if (this.e == null) {
            this.e = this.startTimer();
        }
    }

    private boolean c() {
        if (this.getLimit() <= 0 || this.i < this.getLimit()) {
            ++this.i;
            return true;
        }
        return false;
    }
}

