/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent.locks;

import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.apache.commons.lang3.function.Failable;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableFunction;

public class LockingVisitors {
    public static <O> ReadWriteLockVisitor<O> reentrantReadWriteLockVisitor(O o2) {
        return new ReadWriteLockVisitor<O>(o2, new ReentrantReadWriteLock());
    }

    public static <O> StampedLockVisitor<O> stampedLockVisitor(O o2) {
        return new StampedLockVisitor<O>(o2, new StampedLock());
    }

    public static class StampedLockVisitor<O>
    extends LockVisitor<O, StampedLock> {
        protected StampedLockVisitor(O o2, StampedLock stampedLock) {
            StampedLock stampedLock2 = stampedLock;
            super(o2, stampedLock2, stampedLock2::asReadLock, stampedLock::asWriteLock);
        }
    }

    public static class ReadWriteLockVisitor<O>
    extends LockVisitor<O, ReadWriteLock> {
        protected ReadWriteLockVisitor(O o2, ReadWriteLock readWriteLock) {
            ReadWriteLock readWriteLock2 = readWriteLock;
            super(o2, readWriteLock2, readWriteLock2::readLock, readWriteLock::writeLock);
        }
    }

    public static class LockVisitor<O, L> {
        private final L a;
        private final O b;
        private final Supplier<Lock> c;
        private final Supplier<Lock> d;

        protected LockVisitor(O o2, L l2, Supplier<Lock> supplier, Supplier<Lock> supplier2) {
            this.b = Objects.requireNonNull(o2, "object");
            this.a = Objects.requireNonNull(l2, "lock");
            this.c = Objects.requireNonNull(supplier, "readLockSupplier");
            this.d = Objects.requireNonNull(supplier2, "writeLockSupplier");
        }

        public void acceptReadLocked(FailableConsumer<O, ?> failableConsumer) {
            LockVisitor lockVisitor = this;
            lockVisitor.lockAcceptUnlock(lockVisitor.c, failableConsumer);
        }

        public void acceptWriteLocked(FailableConsumer<O, ?> failableConsumer) {
            LockVisitor lockVisitor = this;
            lockVisitor.lockAcceptUnlock(lockVisitor.d, failableConsumer);
        }

        public <T> T applyReadLocked(FailableFunction<O, T, ?> failableFunction) {
            LockVisitor lockVisitor = this;
            return lockVisitor.lockApplyUnlock(lockVisitor.c, failableFunction);
        }

        public <T> T applyWriteLocked(FailableFunction<O, T, ?> failableFunction) {
            LockVisitor lockVisitor = this;
            return lockVisitor.lockApplyUnlock(lockVisitor.d, failableFunction);
        }

        public L getLock() {
            return this.a;
        }

        public O getObject() {
            return this.b;
        }

        protected void lockAcceptUnlock(Supplier<Lock> object, FailableConsumer<O, ?> object2) {
            object = object.get();
            object.lock();
            try {
                object2.accept(this.b);
                return;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw Failable.rethrow(throwable);
            }
            finally {
                object.unlock();
            }
        }

        protected <T> T lockApplyUnlock(Supplier<Lock> object, FailableFunction<O, T, ?> object2) {
            object = object.get();
            object.lock();
            try {
                object2 = object2.apply(this.b);
                return (T)object2;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw Failable.rethrow(throwable);
            }
            finally {
                object.unlock();
            }
        }
    }
}

