/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.event;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.Validate;

public class EventListenerSupport<L>
implements Serializable {
    private List<L> a = new CopyOnWriteArrayList<L>();
    private transient L b;
    private transient L[] c;

    public static <T> EventListenerSupport<T> create(Class<T> clazz) {
        return new EventListenerSupport<T>(clazz);
    }

    public EventListenerSupport(Class<L> clazz) {
        this(clazz, Thread.currentThread().getContextClassLoader());
    }

    public EventListenerSupport(Class<L> serializable, ClassLoader object) {
        this();
        Validate.notNull(serializable, "listenerInterface", new Object[0]);
        Validate.notNull(object, "classLoader", new Object[0]);
        Validate.isTrue(((Class)serializable).isInterface(), "Class %s is not an interface", ((Class)serializable).getName());
        ClassLoader classLoader = object;
        object = serializable;
        serializable = this;
        Object[] objectArray = (Object[])Array.newInstance(object, 0);
        ((EventListenerSupport)serializable).c = objectArray;
        ((EventListenerSupport)v0).b = ((Class)object).cast(Proxy.newProxyInstance(classLoader, new Class[]{object}, ((EventListenerSupport)serializable).createInvocationHandler()));
    }

    private EventListenerSupport() {
    }

    public L fire() {
        return this.b;
    }

    public void addListener(L l2) {
        this.addListener(l2, true);
    }

    public void addListener(L l2, boolean bl2) {
        Validate.notNull(l2, "listener", new Object[0]);
        if (bl2 || !this.a.contains(l2)) {
            this.a.add(l2);
        }
    }

    public void removeListener(L l2) {
        Validate.notNull(l2, "listener", new Object[0]);
        this.a.remove(l2);
    }

    public L[] getListeners() {
        return this.a.toArray(this.c);
    }

    protected InvocationHandler createInvocationHandler() {
        return new ProxyInvocationHandler(this);
    }

    protected class ProxyInvocationHandler
    implements InvocationHandler {
        private /* synthetic */ EventListenerSupport a;

        protected ProxyInvocationHandler(EventListenerSupport eventListenerSupport) {
            this.a = eventListenerSupport;
        }

        @Override
        public Object invoke(Object iterator, Method method, Object[] objectArray) {
            for (Object e2 : this.a.a) {
                method.invoke(e2, objectArray);
            }
            return null;
        }
    }
}

