/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultExceptionContext
implements Serializable,
ExceptionContext {
    private final List<Pair<String, Object>> a = new ArrayList<Pair<String, Object>>();

    @Override
    public DefaultExceptionContext addContextValue(String string, Object object) {
        this.a.add(new ImmutablePair<String, Object>(string, object));
        return this;
    }

    @Override
    public DefaultExceptionContext setContextValue(String string, Object object) {
        this.a.removeIf(pair -> StringUtils.equals(string, (CharSequence)pair.getKey()));
        this.addContextValue(string, object);
        return this;
    }

    @Override
    public List<Object> getContextValues(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Pair<String, Object> pair : this.a) {
            if (!StringUtils.equals(string, pair.getKey())) continue;
            arrayList.add(pair.getValue());
        }
        return arrayList;
    }

    @Override
    public Object getFirstContextValue(String string) {
        for (Pair<String, Object> pair : this.a) {
            if (!StringUtils.equals(string, pair.getKey())) continue;
            return pair.getValue();
        }
        return null;
    }

    @Override
    public Set<String> getContextLabels() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Pair<String, Object> pair : this.a) {
            hashSet.add(pair.getKey());
        }
        return hashSet;
    }

    @Override
    public List<Pair<String, Object>> getContextEntries() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedExceptionMessage(String string) {
        StringBuilder stringBuilder = new StringBuilder(256);
        if (string != null) {
            stringBuilder.append(string);
        }
        if (!this.a.isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("Exception Context:\n");
            int n2 = 0;
            for (Pair<String, Object> exception : this.a) {
                stringBuilder.append("\t[");
                stringBuilder.append(++n2);
                stringBuilder.append(':');
                stringBuilder.append(exception.getKey());
                stringBuilder.append("=");
                Object object = exception.getValue();
                if (object == null) {
                    stringBuilder.append("null");
                } else {
                    void var4_11;
                    try {
                        String string2 = object.toString();
                    }
                    catch (Exception exception2) {
                        String string3 = "Exception thrown on toString(): " + ExceptionUtils.getStackTrace(exception2);
                    }
                    stringBuilder.append((String)var4_11);
                }
                stringBuilder.append("]\n");
            }
            stringBuilder.append("---------------------------------");
        }
        return stringBuilder.toString();
    }
}

