/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

public class ExceptionUtils {
    private static final String[] a = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};

    @Deprecated
    public static Throwable getCause(Throwable throwable) {
        return ExceptionUtils.getCause(throwable, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static Throwable getCause(Throwable throwable, String[] object) {
        void var1_4;
        if (throwable == null) {
            return null;
        }
        if (object == null) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                return throwable2;
            }
            String[] stringArray = a;
        }
        for (void var4_9 : var1_4) {
            Throwable throwable3;
            if (var4_9 == null || (throwable3 = ExceptionUtils.a(throwable, (String)var4_9)) == null) continue;
            return throwable3;
        }
        return null;
    }

    private static Throwable a(Throwable throwable, String string) {
        Method method = null;
        try {
            method = throwable.getClass().getMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {}
        if (method != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {}
        }
        return null;
    }

    @Deprecated
    public static String[] getDefaultCauseMethodNames() {
        return ArrayUtils.clone(a);
    }

    public static String getMessage(Throwable object) {
        if (object == null) {
            return "";
        }
        String string = ClassUtils.getShortClassName(object, null);
        object = ((Throwable)object).getMessage();
        return string + ": " + StringUtils.defaultString((String)object);
    }

    public static Throwable getRootCause(Throwable object) {
        if ((object = ExceptionUtils.getThrowableList((Throwable)object)).isEmpty()) {
            return null;
        }
        Object object2 = object;
        return (Throwable)object2.get(object2.size() - 1);
    }

    public static String getRootCauseMessage(Throwable throwable) {
        Throwable throwable2 = ExceptionUtils.getRootCause(throwable);
        throwable2 = throwable2 == null ? throwable : throwable2;
        return ExceptionUtils.getMessage(throwable2);
    }

    public static String[] getRootCauseStackTrace(Throwable throwableArray) {
        if (throwableArray == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        throwableArray = ExceptionUtils.getThrowables((Throwable)throwableArray);
        int n2 = throwableArray.length;
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = ExceptionUtils.a(throwableArray[n2 - 1]);
        int n3 = n2;
        while (--n3 >= 0) {
            List<String> list2 = list;
            if (n3 != 0) {
                list = ExceptionUtils.a(throwableArray[n3 - 1]);
                ExceptionUtils.removeCommonFrames(list2, list);
            }
            if (n3 == n2 - 1) {
                arrayList.add(throwableArray[n3].toString());
            } else {
                arrayList.add(" [wrapped] " + throwableArray[n3].toString());
            }
            arrayList.addAll(list2);
        }
        return arrayList.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private static List<String> a(Throwable object) {
        object = ExceptionUtils.getStackTrace((Throwable)object);
        Object object2 = System.lineSeparator();
        object = new StringTokenizer((String)object, (String)object2);
        object2 = new ArrayList();
        boolean bl2 = false;
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken();
            int n2 = string.indexOf("at");
            if (n2 != -1 && string.substring(0, n2).trim().isEmpty()) {
                bl2 = true;
                object2.add(string);
                continue;
            }
            if (!bl2) continue;
        }
        return object2;
    }

    public static String[] getStackFrames(Throwable object) {
        if (object == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        object = ExceptionUtils.getStackTrace((Throwable)object);
        Object object2 = System.lineSeparator();
        object = new StringTokenizer((String)object, (String)object2);
        object2 = new ArrayList();
        while (((StringTokenizer)object).hasMoreTokens()) {
            object2.add(((StringTokenizer)object).nextToken());
        }
        return object2.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    public static int getThrowableCount(Throwable throwable) {
        return ExceptionUtils.getThrowableList(throwable).size();
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        while (throwable != null && !arrayList.contains(throwable)) {
            arrayList.add(throwable);
            throwable = throwable.getCause();
        }
        return arrayList;
    }

    public static Throwable[] getThrowables(Throwable object) {
        object = ExceptionUtils.getThrowableList((Throwable)object);
        return object.toArray(ArrayUtils.EMPTY_THROWABLE_ARRAY);
    }

    public static boolean hasCause(Throwable throwable, Class<? extends Throwable> clazz) {
        if (throwable instanceof UndeclaredThrowableException) {
            throwable = throwable.getCause();
        }
        return clazz.isInstance(throwable);
    }

    private static int a(Throwable throwableArray, Class<? extends Throwable> clazz, int n2, boolean bl2) {
        if (throwableArray == null || clazz == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= (throwableArray = ExceptionUtils.getThrowables((Throwable)throwableArray)).length) {
            return -1;
        }
        if (bl2) {
            while (n2 < throwableArray.length) {
                if (clazz.isAssignableFrom(throwableArray[n2].getClass())) {
                    return n2;
                }
                ++n2;
            }
        } else {
            while (n2 < throwableArray.length) {
                if (clazz.equals(throwableArray[n2].getClass())) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public static int indexOfThrowable(Throwable throwable, Class<? extends Throwable> clazz) {
        return ExceptionUtils.a(throwable, clazz, 0, false);
    }

    public static int indexOfThrowable(Throwable throwable, Class<? extends Throwable> clazz, int n2) {
        return ExceptionUtils.a(throwable, clazz, n2, false);
    }

    public static int indexOfType(Throwable throwable, Class<? extends Throwable> clazz) {
        return ExceptionUtils.a(throwable, clazz, 0, true);
    }

    public static int indexOfType(Throwable throwable, Class<? extends Throwable> clazz, int n2) {
        return ExceptionUtils.a(throwable, clazz, n2, true);
    }

    public static void printRootCauseStackTrace(Throwable throwable) {
        ExceptionUtils.printRootCauseStackTrace(throwable, System.err);
    }

    public static void printRootCauseStackTrace(Throwable stringArray, PrintStream printStream) {
        if (stringArray == null) {
            return;
        }
        Objects.requireNonNull(printStream, "printStream");
        String[] stringArray2 = ExceptionUtils.getRootCauseStackTrace((Throwable)stringArray);
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            printStream.println(string);
        }
        printStream.flush();
    }

    public static void printRootCauseStackTrace(Throwable stringArray, PrintWriter printWriter) {
        if (stringArray == null) {
            return;
        }
        Objects.requireNonNull(printWriter, "printWriter");
        String[] stringArray2 = ExceptionUtils.getRootCauseStackTrace((Throwable)stringArray);
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            printWriter.println(string);
        }
        printWriter.flush();
    }

    public static void removeCommonFrames(List<String> list, List<String> list2) {
        if (list == null || list2 == null) {
            throw new IllegalArgumentException("The List must not be null");
        }
        int n2 = list.size() - 1;
        for (int i2 = list2.size() - 1; n2 >= 0 && i2 >= 0; --n2, --i2) {
            String string;
            String string2 = list.get(n2);
            if (!string2.equals(string = list2.get(i2))) continue;
            list.remove(n2);
        }
    }

    public static <R> R rethrow(Throwable throwable) {
        throw throwable;
    }

    private static <T extends Throwable> T b(Throwable throwableArray, Class<T> clazz, int n2, boolean bl2) {
        if (throwableArray == null || clazz == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= (throwableArray = ExceptionUtils.getThrowables((Throwable)throwableArray)).length) {
            return null;
        }
        if (bl2) {
            while (n2 < throwableArray.length) {
                if (clazz.isAssignableFrom(throwableArray[n2].getClass())) {
                    return (T)((Throwable)clazz.cast(throwableArray[n2]));
                }
                ++n2;
            }
        } else {
            while (n2 < throwableArray.length) {
                if (clazz.equals(throwableArray[n2].getClass())) {
                    return (T)((Throwable)clazz.cast(throwableArray[n2]));
                }
                ++n2;
            }
        }
        return null;
    }

    public static <T extends Throwable> T throwableOfThrowable(Throwable throwable, Class<T> clazz) {
        return ExceptionUtils.b(throwable, clazz, 0, false);
    }

    public static <T extends Throwable> T throwableOfThrowable(Throwable throwable, Class<T> clazz, int n2) {
        return ExceptionUtils.b(throwable, clazz, n2, false);
    }

    public static <T extends Throwable> T throwableOfType(Throwable throwable, Class<T> clazz) {
        return ExceptionUtils.b(throwable, clazz, 0, true);
    }

    public static <T extends Throwable> T throwableOfType(Throwable throwable, Class<T> clazz, int n2) {
        return ExceptionUtils.b(throwable, clazz, n2, true);
    }

    public static <R> R wrapAndThrow(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable);
    }
}

