/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.math.BigInteger;
import org.apache.commons.lang3.Validate;

public final class Fraction
extends Number
implements Comparable<Fraction> {
    public static final Fraction ZERO = new Fraction(0, 1);
    public static final Fraction ONE = new Fraction(1, 1);
    public static final Fraction ONE_HALF = new Fraction(1, 2);
    public static final Fraction ONE_THIRD = new Fraction(1, 3);
    public static final Fraction TWO_THIRDS = new Fraction(2, 3);
    public static final Fraction ONE_QUARTER = new Fraction(1, 4);
    public static final Fraction TWO_QUARTERS = new Fraction(2, 4);
    public static final Fraction THREE_QUARTERS = new Fraction(3, 4);
    public static final Fraction ONE_FIFTH = new Fraction(1, 5);
    public static final Fraction TWO_FIFTHS = new Fraction(2, 5);
    public static final Fraction THREE_FIFTHS = new Fraction(3, 5);
    public static final Fraction FOUR_FIFTHS = new Fraction(4, 5);
    private final int a;
    private final int b;
    private transient int c;
    private transient String d;
    private transient String e;

    private Fraction(int n2, int n3) {
        this.a = n2;
        this.b = n3;
    }

    public static Fraction getFraction(int n2, int n3) {
        if (n3 == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (n3 < 0) {
            if (n2 == Integer.MIN_VALUE || n3 == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            n2 = -n2;
            n3 = -n3;
        }
        return new Fraction(n2, n3);
    }

    public static Fraction getFraction(int n2, int n3, int n4) {
        if (n4 == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (n4 < 0) {
            throw new ArithmeticException("The denominator must not be negative");
        }
        if (n3 < 0) {
            throw new ArithmeticException("The numerator must not be negative");
        }
        long l2 = n2 < 0 ? (long)n2 * (long)n4 - (long)n3 : (long)n2 * (long)n4 + (long)n3;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("Numerator too large to represent as an Integer.");
        }
        return new Fraction((int)l2, n4);
    }

    public static Fraction getReducedFraction(int n2, int n3) {
        if (n3 == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (n2 == 0) {
            return ZERO;
        }
        if (n3 == Integer.MIN_VALUE && (n2 & 1) == 0) {
            n2 /= 2;
            n3 /= 2;
        }
        if (n3 < 0) {
            if (n2 == Integer.MIN_VALUE || n3 == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            n2 = -n2;
            n3 = -n3;
        }
        int n4 = Fraction.a(n2, n3);
        return new Fraction(n2 /= n4, n3 /= n4);
    }

    public static Fraction getFraction(double d2) {
        int n2;
        double d3;
        int n3 = d2 < 0.0 ? -1 : 1;
        if ((d2 = Math.abs(d2)) > 2.147483647E9 || Double.isNaN(d2)) {
            throw new ArithmeticException("The value must not be greater than Integer.MAX_VALUE or NaN");
        }
        int n4 = (int)d2;
        int n5 = 0;
        int n6 = 1;
        int n7 = 1;
        int n8 = 0;
        int n9 = (int)(d2 -= (double)n4);
        double d4 = 1.0;
        double d5 = d2 - (double)n9;
        double d6 = Double.MAX_VALUE;
        int n10 = 1;
        do {
            d3 = d6;
            int n11 = (int)(d4 / d5);
            double d7 = d5;
            double d8 = d4 - (double)n11 * d5;
            int n12 = n9 * n7 + n5;
            n2 = n9 * n8 + n6;
            double d9 = (double)n12 / (double)n2;
            d6 = Math.abs(d2 - d9);
            n9 = n11;
            d4 = d7;
            d5 = d8;
            n5 = n7;
            n6 = n8;
            n7 = n12;
            n8 = n2;
        } while (d3 > d6 && n2 <= 10000 && n2 > 0 && ++n10 < 25);
        if (n10 == 25) {
            throw new ArithmeticException("Unable to convert double to fraction");
        }
        return Fraction.getReducedFraction((n5 + n4 * n6) * n3, n6);
    }

    public static Fraction getFraction(String string) {
        Validate.notNull(string, "str", new Object[0]);
        int n2 = string.indexOf(46);
        if (n2 >= 0) {
            return Fraction.getFraction(Double.parseDouble(string));
        }
        n2 = string.indexOf(32);
        if (n2 > 0) {
            int n3 = Integer.parseInt(string.substring(0, n2));
            if ((n2 = (string = string.substring(n2 + 1)).indexOf(47)) < 0) {
                throw new NumberFormatException("The fraction could not be parsed as the format X Y/Z");
            }
            int n4 = Integer.parseInt(string.substring(0, n2));
            int n5 = Integer.parseInt(string.substring(n2 + 1));
            return Fraction.getFraction(n3, n4, n5);
        }
        n2 = string.indexOf(47);
        if (n2 < 0) {
            return Fraction.getFraction(Integer.parseInt(string), 1);
        }
        int n6 = Integer.parseInt(string.substring(0, n2));
        int n7 = Integer.parseInt(string.substring(n2 + 1));
        return Fraction.getFraction(n6, n7);
    }

    public final int getNumerator() {
        return this.a;
    }

    public final int getDenominator() {
        return this.b;
    }

    public final int getProperNumerator() {
        return Math.abs(this.a % this.b);
    }

    public final int getProperWhole() {
        return this.a / this.b;
    }

    @Override
    public final int intValue() {
        return this.a / this.b;
    }

    @Override
    public final long longValue() {
        return (long)this.a / (long)this.b;
    }

    @Override
    public final float floatValue() {
        return (float)this.a / (float)this.b;
    }

    @Override
    public final double doubleValue() {
        return (double)this.a / (double)this.b;
    }

    public final Fraction reduce() {
        if (this.a == 0) {
            if (this.equals(ZERO)) {
                return this;
            }
            return ZERO;
        }
        int n2 = Fraction.a(Math.abs(this.a), this.b);
        if (n2 == 1) {
            return this;
        }
        return Fraction.getFraction(this.a / n2, this.b / n2);
    }

    public final Fraction invert() {
        if (this.a == 0) {
            throw new ArithmeticException("Unable to invert zero.");
        }
        if (this.a == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: can't negate numerator");
        }
        if (this.a < 0) {
            return new Fraction(-this.b, -this.a);
        }
        return new Fraction(this.b, this.a);
    }

    public final Fraction negate() {
        if (this.a == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: too large to negate");
        }
        return new Fraction(-this.a, this.b);
    }

    public final Fraction abs() {
        if (this.a >= 0) {
            return this;
        }
        return this.negate();
    }

    public final Fraction pow(int n2) {
        Fraction fraction;
        while (true) {
            Fraction fraction2;
            if (n2 == 1) {
                return fraction2;
            }
            if (n2 == 0) {
                return ONE;
            }
            if (n2 < 0) {
                if (n2 == Integer.MIN_VALUE) {
                    n2 = -(n2 / 2);
                    fraction2 = fraction2.invert().pow(2);
                    continue;
                }
                n2 = -n2;
                fraction2 = fraction2.invert();
                continue;
            }
            Fraction fraction3 = fraction2;
            fraction = fraction3.multiplyBy(fraction3);
            if (n2 % 2 != 0) break;
            n2 /= 2;
            fraction2 = fraction;
        }
        return fraction.pow(n2 / 2).multiplyBy(fraction2);
    }

    private static int a(int n2, int n3) {
        int n4;
        int n5;
        if (n2 == 0 || n3 == 0) {
            if (n2 == Integer.MIN_VALUE || n3 == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: gcd is 2^31");
            }
            return Math.abs(n2) + Math.abs(n3);
        }
        if (Math.abs(n2) == 1 || Math.abs(n3) == 1) {
            return 1;
        }
        if (n2 > 0) {
            n2 = -n2;
        }
        if (n3 > 0) {
            n3 = -n3;
        }
        for (n5 = 0; (n2 & 1) == 0 && (n3 & 1) == 0 && n5 < 31; ++n5) {
            n2 /= 2;
            n3 /= 2;
        }
        if (n5 == 31) {
            throw new ArithmeticException("overflow: gcd is 2^31");
        }
        int n6 = n4 = (n2 & 1) == 1 ? n3 : -(n2 / 2);
        while (true) {
            if ((n4 & 1) == 0) {
                n6 = n4 / 2;
                continue;
            }
            if (n4 > 0) {
                n2 = -n4;
            } else {
                n3 = n4;
            }
            if ((n4 = (n3 - n2) / 2) == 0) break;
        }
        return -n2 * (1 << n5);
    }

    private static int b(int n2, int n3) {
        long l2 = (long)n2 * (long)n3;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mul");
        }
        return (int)l2;
    }

    private static int c(int n2, int n3) {
        long l2 = (long)n2 * (long)n3;
        if (l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mulPos");
        }
        return (int)l2;
    }

    private static int d(int n2, int n3) {
        long l2 = (long)n2 + (long)n3;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)l2;
    }

    private static int e(int n2, int n3) {
        long l2 = (long)n2 - (long)n3;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)l2;
    }

    public final Fraction add(Fraction fraction) {
        return this.a(fraction, true);
    }

    public final Fraction subtract(Fraction fraction) {
        return this.a(fraction, false);
    }

    private Fraction a(Fraction fraction, boolean bl2) {
        Validate.notNull(fraction, "fraction", new Object[0]);
        if (this.a == 0) {
            if (bl2) {
                return fraction;
            }
            return fraction.negate();
        }
        if (fraction.a == 0) {
            return this;
        }
        int n2 = Fraction.a(this.b, fraction.b);
        if (n2 == 1) {
            int n3 = Fraction.b(this.a, fraction.b);
            int n4 = Fraction.b(fraction.a, this.b);
            return new Fraction(bl2 ? Fraction.d(n3, n4) : Fraction.e(n3, n4), Fraction.c(this.b, fraction.b));
        }
        BigInteger bigInteger = BigInteger.valueOf(this.a).multiply(BigInteger.valueOf(fraction.b / n2));
        BigInteger bigInteger2 = BigInteger.valueOf(fraction.a).multiply(BigInteger.valueOf(this.b / n2));
        BigInteger bigInteger3 = bl2 ? bigInteger.add(bigInteger2) : bigInteger.subtract(bigInteger2);
        int n5 = bigInteger3.mod(BigInteger.valueOf(n2)).intValue();
        if ((bigInteger3 = bigInteger3.divide(BigInteger.valueOf(n5 = n5 == 0 ? n2 : Fraction.a(n5, n2)))).bitLength() > 31) {
            throw new ArithmeticException("overflow: numerator too large after multiply");
        }
        return new Fraction(bigInteger3.intValue(), Fraction.c(this.b / n2, fraction.b / n5));
    }

    public final Fraction multiplyBy(Fraction fraction) {
        Validate.notNull(fraction, "fraction", new Object[0]);
        if (this.a == 0 || fraction.a == 0) {
            return ZERO;
        }
        int n2 = Fraction.a(this.a, fraction.b);
        int n3 = Fraction.a(fraction.a, this.b);
        return Fraction.getReducedFraction(Fraction.b(this.a / n2, fraction.a / n3), Fraction.c(this.b / n3, fraction.b / n2));
    }

    public final Fraction divideBy(Fraction fraction) {
        Validate.notNull(fraction, "fraction", new Object[0]);
        if (fraction.a == 0) {
            throw new ArithmeticException("The fraction to divide by must not be zero");
        }
        return this.multiplyBy(fraction.invert());
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Fraction)) {
            return false;
        }
        object = (Fraction)object;
        return this.getNumerator() == ((Fraction)object).getNumerator() && this.getDenominator() == ((Fraction)object).getDenominator();
    }

    public final int hashCode() {
        if (this.c == 0) {
            this.c = 37 * (629 + this.getNumerator()) + this.getDenominator();
        }
        return this.c;
    }

    @Override
    public final int compareTo(Fraction fraction) {
        if (this == fraction) {
            return 0;
        }
        if (this.a == fraction.a && this.b == fraction.b) {
            return 0;
        }
        long l2 = (long)this.a * (long)fraction.b;
        long l3 = (long)fraction.a * (long)this.b;
        return Long.compare(l2, l3);
    }

    public final String toString() {
        if (this.d == null) {
            this.d = this.getNumerator() + "/" + this.getDenominator();
        }
        return this.d;
    }

    public final String toProperString() {
        if (this.e == null) {
            int n2;
            this.e = this.a == 0 ? "0" : (this.a == this.b ? "1" : (this.a == -1 * this.b ? "-1" : ((this.a > 0 ? -this.a : this.a) < -this.b ? ((n2 = this.getProperNumerator()) == 0 ? Integer.toString(this.getProperWhole()) : this.getProperWhole() + " " + n2 + "/" + this.getDenominator()) : this.getNumerator() + "/" + this.getDenominator())));
        }
        return this.e;
    }
}

