/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.lang3.reflect.a;

public class ConstructorUtils {
    public static <T> T invokeConstructor(Class<T> clazz, Object ... objectArray) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return ConstructorUtils.invokeConstructor(clazz, objectArray, classArray);
    }

    public static <T> T invokeConstructor(Class<T> classArray, Object[] objectArray, Class<?>[] object) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        object = ArrayUtils.nullToEmpty(object);
        if ((object = ConstructorUtils.getMatchingAccessibleConstructor(classArray, object)) == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + classArray.getName());
        }
        if (((Constructor)object).isVarArgs()) {
            classArray = ((Constructor)object).getParameterTypes();
            objectArray = MethodUtils.a(objectArray, classArray);
        }
        return ((Constructor)object).newInstance(objectArray);
    }

    public static <T> T invokeExactConstructor(Class<T> clazz, Object ... objectArray) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return ConstructorUtils.invokeExactConstructor(clazz, objectArray, classArray);
    }

    public static <T> T invokeExactConstructor(Class<T> clazz, Object[] objectArray, Class<?>[] object) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        object = ArrayUtils.nullToEmpty(object);
        if ((object = ConstructorUtils.getAccessibleConstructor(clazz, object)) == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return ((Constructor)object).newInstance(objectArray);
    }

    public static <T> Constructor<T> getAccessibleConstructor(Class<T> clazz, Class<?> ... classArray) {
        Validate.notNull(clazz, "cls", new Object[0]);
        try {
            return ConstructorUtils.getAccessibleConstructor(clazz.getConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> Constructor<T> getAccessibleConstructor(Constructor<T> constructor) {
        Validate.notNull(constructor, "ctor", new Object[0]);
        if (a.a(constructor)) {
            boolean bl2;
            block4: {
                Class<Object> clazz = constructor.getDeclaringClass();
                while (clazz != null) {
                    if (!Modifier.isPublic(clazz.getModifiers())) {
                        bl2 = false;
                        break block4;
                    }
                    clazz = clazz.getEnclosingClass();
                }
                bl2 = true;
            }
            if (bl2) {
                return constructor;
            }
        }
        return null;
    }

    public static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> constructorArray, Class<?> ... classArray) {
        Validate.notNull(constructorArray, "cls", new Object[0]);
        try {
            Constructor<T> constructor = constructorArray.getConstructor(classArray);
            a.a(constructor);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor<?> constructor = null;
            Constructor<?>[] constructorArray2 = constructorArray.getConstructors();
            constructorArray = constructorArray2;
            constructorArray = constructorArray2;
            int n2 = constructorArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Constructor<?> constructor2 = constructorArray[i2];
                if (!a.a(constructor2, classArray) || (constructor2 = ConstructorUtils.getAccessibleConstructor(constructor2)) == null) continue;
                a.a(constructor2);
                if (constructor != null && a.a(constructor2, constructor, classArray) >= 0) continue;
                constructor = constructor2;
            }
            return constructor;
        }
    }
}

