/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.reflect.a;

public class MethodUtils {
    private static final Comparator<Method> a = Comparator.comparing(Method::toString);

    public static Object invokeMethod(Object object, String string) {
        return MethodUtils.invokeMethod(object, string, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, boolean bl2, String string) {
        return MethodUtils.invokeMethod(object, bl2, string, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, String string, Object ... objectArray) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeMethod(object, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, boolean bl2, String string, Object ... objectArray) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeMethod(object, bl2, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, boolean bl2, String string, Object[] objectArray, Class<?>[] object2) {
        String string2;
        object2 = ArrayUtils.nullToEmpty(object2);
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        if (bl2) {
            string2 = "No such method: ";
            object2 = MethodUtils.getMatchingMethod(object.getClass(), string, object2);
            if (object2 != null && !((AccessibleObject)object2).isAccessible()) {
                ((Method)object2).setAccessible(true);
            }
        } else {
            string2 = "No such accessible method: ";
            object2 = MethodUtils.getMatchingAccessibleMethod(object.getClass(), string, object2);
        }
        if (object2 == null) {
            throw new NoSuchMethodException(string2 + string + "() on object: " + object.getClass().getName());
        }
        objectArray = MethodUtils.a((Method)object2, objectArray);
        return ((Method)object2).invoke(object, objectArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class<?>[] classArray) {
        return MethodUtils.invokeMethod(object, false, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string) {
        return MethodUtils.invokeExactMethod(object, string, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeExactMethod(Object object, String string, Object ... objectArray) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeExactMethod(object, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray, Class<?>[] object2) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        object2 = ArrayUtils.nullToEmpty(object2);
        object2 = MethodUtils.getAccessibleMethod(object.getClass(), string, object2);
        if (object2 == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return ((Method)object2).invoke(object, objectArray);
    }

    public static Object invokeExactStaticMethod(Class<?> clazz, String string, Object[] objectArray, Class<?>[] object) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        object = ArrayUtils.nullToEmpty(object);
        if ((object = MethodUtils.getAccessibleMethod(clazz, string, object)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on class: " + clazz.getName());
        }
        return ((Method)object).invoke(null, objectArray);
    }

    public static Object invokeStaticMethod(Class<?> clazz, String string, Object ... objectArray) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeStaticMethod(clazz, string, objectArray, classArray);
    }

    public static Object invokeStaticMethod(Class<?> clazz, String string, Object[] objectArray, Class<?>[] object) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        object = ArrayUtils.nullToEmpty(object);
        if ((object = MethodUtils.getMatchingAccessibleMethod(clazz, string, object)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on class: " + clazz.getName());
        }
        objectArray = MethodUtils.a(object, objectArray);
        return ((Method)object).invoke(null, objectArray);
    }

    private static Object[] a(Method classArray, Object[] objectArray) {
        if (classArray.isVarArgs()) {
            classArray = classArray.getParameterTypes();
            objectArray = MethodUtils.a(objectArray, classArray);
        }
        return objectArray;
    }

    static Object[] a(Object[] objectArray, Class<?>[] classArray) {
        if (objectArray.length == classArray.length && (objectArray[objectArray.length - 1] == null || objectArray[objectArray.length - 1].getClass().equals(classArray[classArray.length - 1]))) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[classArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, classArray.length - 1);
        Class<?> clazz = classArray[classArray.length - 1].getComponentType();
        int n2 = objectArray.length - classArray.length + 1;
        Object object = Array.newInstance(ClassUtils.primitiveToWrapper(clazz), n2);
        System.arraycopy(objectArray, classArray.length - 1, object, 0, n2);
        if (clazz.isPrimitive()) {
            object = ArrayUtils.toPrimitive(object);
        }
        objectArray2[classArray.length - 1] = object;
        return objectArray2;
    }

    public static Object invokeExactStaticMethod(Class<?> clazz, String string, Object ... objectArray) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeExactStaticMethod(clazz, string, objectArray, classArray);
    }

    public static Method getAccessibleMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return MethodUtils.getAccessibleMethod(clazz.getMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        Class<?>[] classArray;
        if (!org.apache.commons.lang3.reflect.a.a(method)) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        String string = method.getName();
        if ((method = MethodUtils.b(clazz, string, classArray = method.getParameterTypes())) == null) {
            method = MethodUtils.a(clazz, string, classArray);
        }
        return method;
    }

    private static Method a(Class<?> clazz, String string, Class<?> ... classArray) {
        for (clazz = clazz.getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!Modifier.isPublic(clazz.getModifiers())) continue;
            try {
                return clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return null;
    }

    private static Method b(Class<?> clazz, String string, Class<?> ... classArray) {
        while (clazz != null) {
            Class<?>[] classArray2 = clazz.getInterfaces();
            Class<?>[] classArray3 = classArray2;
            classArray3 = classArray2;
            int n2 = classArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                GenericDeclaration genericDeclaration = classArray3[i2];
                if (!Modifier.isPublic(genericDeclaration.getModifiers())) continue;
                try {
                    return genericDeclaration.getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    genericDeclaration = MethodUtils.b(genericDeclaration, string, classArray);
                    if (genericDeclaration == null) continue;
                    return genericDeclaration;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class<?> serializable, String string, Class<?> ... classArray) {
        try {
            Method method = ((Class)serializable).getMethod(string, classArray);
            org.apache.commons.lang3.reflect.a.a(method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Object object3;
            Object object2 = ((Class)serializable).getMethods();
            serializable = new ArrayList();
            for (Object object3 : object2) {
                if (!((Method)object3).getName().equals(string) || !org.apache.commons.lang3.reflect.a.a((Method)object3, classArray)) continue;
                serializable.add(object3);
            }
            serializable.sort(a);
            object2 = null;
            Class<?>[] classArray2 = serializable.iterator();
            while (classArray2.hasNext()) {
                Method method = (Method)classArray2.next();
                object3 = MethodUtils.getAccessibleMethod(method);
                if (object3 == null || object2 != null && org.apache.commons.lang3.reflect.a.a((Method)object3, (Method)object2, classArray) >= 0) continue;
                object2 = object3;
            }
            if (object2 != null) {
                org.apache.commons.lang3.reflect.a.a((AccessibleObject)object2);
            }
            if (object2 != null && ((Method)object2).isVarArgs() && ((Method)object2).getParameterTypes().length > 0 && classArray.length > 0) {
                classArray2 = ((Method)object2).getParameterTypes();
                Class<?> clazz = classArray2[classArray2.length - 1].getComponentType();
                object3 = ClassUtils.primitiveToWrapper(clazz).getName();
                serializable = classArray[classArray.length - 1];
                string = serializable == null ? null : ((Class)serializable).getName();
                Serializable serializable2 = serializable = serializable == null ? null : ((Class)serializable).getSuperclass().getName();
                if (string != null && serializable != null && !((String)object3).equals(string) && !((String)object3).equals(serializable)) {
                    return null;
                }
            }
            return object2;
        }
    }

    public static Method getMatchingMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Object object2;
        Validate.notNull(clazz, "cls", new Object[0]);
        Validate.notEmpty(string, "methodName", new Object[0]);
        List list = Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.getName().equals(string)).collect(Collectors.toList());
        ClassUtils.getAllSuperclasses(clazz).stream().map(Class::getDeclaredMethods).flatMap(Arrays::stream).filter(method -> method.getName().equals(string)).forEach(list::add);
        for (Object object2 : list) {
            if (!Arrays.deepEquals(((Method)object2).getParameterTypes(), classArray)) continue;
            return object2;
        }
        TreeMap treeMap = new TreeMap();
        list.stream().filter(method -> ClassUtils.isAssignable(classArray, method.getParameterTypes(), true)).forEach(method -> {
            int n3;
            Class<?>[] classArray2 = method.getParameterTypes();
            int n4 = 0;
            if (!ClassUtils.isAssignable(classArray, classArray2, true)) {
                n3 = -1;
            } else {
                for (int i2 = 0; i2 < classArray.length; ++i2) {
                    Class clazz = classArray[i2];
                    Class<?> clazz2 = classArray2[i2];
                    if (clazz == null || clazz.equals(clazz2)) continue;
                    if (ClassUtils.isAssignable(clazz, clazz2, true) && !ClassUtils.isAssignable(clazz, clazz2, false)) {
                        ++n4;
                        continue;
                    }
                    n4 += 2;
                }
                n3 = n4;
            }
            int n5 = n3;
            List list = treeMap.computeIfAbsent(n5, n2 -> new ArrayList());
            list.add(method);
        });
        if (treeMap.isEmpty()) {
            return null;
        }
        object2 = (List)treeMap.values().iterator().next();
        if (object2.size() == 1) {
            return (Method)object2.get(0);
        }
        throw new IllegalStateException(String.format("Found multiple candidates for method %s on class %s : %s", string + Arrays.stream(classArray).map(String::valueOf).collect(Collectors.joining(",", "(", ")")), clazz.getName(), object2.stream().map(Method::toString).collect(Collectors.joining(",", "[", "]"))));
    }

    public static Set<Method> getOverrideHierarchy(Method method, ClassUtils.Interfaces object) {
        Validate.notNull(method);
        LinkedHashSet<Method> linkedHashSet = new LinkedHashSet<Method>();
        linkedHashSet.add(method);
        Object[] objectArray = method.getParameterTypes();
        Class<?> clazz = method.getDeclaringClass();
        object = ClassUtils.hierarchy(clazz, (ClassUtils.Interfaces)((Object)object)).iterator();
        object.next();
        block0: while (object.hasNext()) {
            GenericDeclaration genericDeclaration = (Class)object.next();
            if ((genericDeclaration = MethodUtils.getMatchingAccessibleMethod(genericDeclaration, method.getName(), objectArray)) == null) continue;
            if (Arrays.equals(((Method)genericDeclaration).getParameterTypes(), objectArray)) {
                linkedHashSet.add((Method)genericDeclaration);
                continue;
            }
            Map<TypeVariable<?>, Type> map = TypeUtils.getTypeArguments(clazz, ((Method)genericDeclaration).getDeclaringClass());
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Type type;
                Type type2 = TypeUtils.unrollVariables(map, method.getGenericParameterTypes()[i2]);
                if (!TypeUtils.equals(type2, type = TypeUtils.unrollVariables(map, ((Method)genericDeclaration).getGenericParameterTypes()[i2]))) continue block0;
            }
            linkedHashSet.add((Method)genericDeclaration);
        }
        return linkedHashSet;
    }

    public static Method[] getMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2) {
        return MethodUtils.getMethodsWithAnnotation(clazz, clazz2, false, false);
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2) {
        return MethodUtils.getMethodsListWithAnnotation(clazz, clazz2, false, false);
    }

    public static Method[] getMethodsWithAnnotation(Class<?> object, Class<? extends Annotation> clazz, boolean bl2, boolean bl3) {
        object = MethodUtils.getMethodsListWithAnnotation(object, clazz, bl2, bl3);
        return object.toArray(ArrayUtils.EMPTY_METHOD_ARRAY);
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> serializable, Class<? extends Annotation> clazz, boolean bl2, boolean bl3) {
        Validate.notNull(serializable, "cls", new Object[0]);
        Validate.notNull(clazz, "annotationCls", new Object[0]);
        Object object = bl2 ? MethodUtils.a(serializable) : new ArrayList();
        object.add(0, serializable);
        serializable = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Method[] methodArray = (Method[])object.next();
            Method[] methodArray2 = bl3 ? methodArray.getDeclaredMethods() : methodArray.getMethods();
            methodArray = methodArray2;
            methodArray = methodArray2;
            int n2 = methodArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Method method = methodArray[i2];
                if (method.getAnnotation(clazz) == null) continue;
                serializable.add((Method)method);
            }
        }
        return serializable;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> clazz, boolean bl2, boolean bl3) {
        Validate.notNull(method, "method", new Object[0]);
        Validate.notNull(clazz, "annotationCls", new Object[0]);
        if (!bl3 && !org.apache.commons.lang3.reflect.a.a(method)) {
            return null;
        }
        A a2 = method.getAnnotation(clazz);
        if (a2 == null && bl2) {
            Iterator<Class<?>> iterator = method.getDeclaringClass();
            iterator = MethodUtils.a(iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                GenericDeclaration genericDeclaration = iterator.next();
                genericDeclaration = bl3 ? MethodUtils.getMatchingMethod(genericDeclaration, method.getName(), method.getParameterTypes()) : MethodUtils.getMatchingAccessibleMethod(genericDeclaration, method.getName(), method.getParameterTypes());
                if (genericDeclaration == null || (a2 = ((Method)genericDeclaration).getAnnotation(clazz)) == null) continue;
            }
        }
        return a2;
    }

    private static List<Class<?>> a(Class<?> object) {
        if (object == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        List<Class<?>> list = ClassUtils.getAllSuperclasses(object);
        int n2 = 0;
        object = ClassUtils.getAllInterfaces(object);
        int n3 = 0;
        while (n3 < object.size() || n2 < list.size()) {
            Class clazz = n3 < object.size() && (n2 >= list.size() || n3 < n2 || n2 >= n3) ? (Class)object.get(n3++) : list.get(n2++);
            arrayList.add(clazz);
        }
        return arrayList;
    }
}

