/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.reflect.Typed;

public class TypeUtils {
    public static final WildcardType WILDCARD_ALL = TypeUtils.wildcardType().withUpperBounds(new Type[]{Object.class}).build();

    private static <T> StringBuilder a(StringBuilder stringBuilder, String string, T ... TArray) {
        Validate.notEmpty(Validate.noNullElements(TArray));
        if (TArray.length > 0) {
            stringBuilder.append(TypeUtils.a(TArray[0]));
            for (int i2 = 1; i2 < TArray.length; ++i2) {
                stringBuilder.append(string).append(TypeUtils.a(TArray[i2]));
            }
        }
        return stringBuilder;
    }

    private static String a(Class<?> clazz) {
        if (clazz.isArray()) {
            return TypeUtils.toString(clazz.getComponentType()) + "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (clazz.getEnclosingClass() != null) {
            stringBuilder.append(TypeUtils.a(clazz.getEnclosingClass())).append('.').append(clazz.getSimpleName());
        } else {
            stringBuilder.append(clazz.getName());
        }
        if (clazz.getTypeParameters().length > 0) {
            stringBuilder.append('<');
            TypeUtils.a(stringBuilder, ", ", clazz.getTypeParameters());
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsTypeVariables(Type object) {
        while (true) {
            void var0_1;
            if (var0_1 instanceof TypeVariable) {
                return true;
            }
            if (var0_1 instanceof Class) {
                return ((Class)var0_1).getTypeParameters().length > 0;
            }
            if (var0_1 instanceof ParameterizedType) {
                for (Type type : ((ParameterizedType)var0_1).getActualTypeArguments()) {
                    if (!TypeUtils.containsTypeVariables(type)) continue;
                    return true;
                }
                return false;
            }
            if (var0_1 instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)var0_1;
                return TypeUtils.containsTypeVariables(TypeUtils.getImplicitLowerBounds(wildcardType)[0]) || TypeUtils.containsTypeVariables(TypeUtils.getImplicitUpperBounds(wildcardType)[0]);
            }
            if (!(var0_1 instanceof GenericArrayType)) break;
            Type type = ((GenericArrayType)var0_1).getGenericComponentType();
        }
        return false;
    }

    public static Map<TypeVariable<?>, Type> determineTypeArguments(Class<?> clazz, ParameterizedType object) {
        Type type;
        while (true) {
            Validate.notNull(clazz, "cls", new Object[0]);
            Validate.notNull(object, "superParameterizedType", new Object[0]);
            type = TypeUtils.a((ParameterizedType)object);
            if (!TypeUtils.a(clazz, type)) {
                return null;
            }
            if (clazz.equals(type)) {
                return TypeUtils.a((ParameterizedType)object, type, null);
            }
            if (!((type = TypeUtils.a(clazz, type)) instanceof Class)) break;
            clazz = type;
        }
        type = (ParameterizedType)type;
        Class<?> clazz2 = TypeUtils.a((ParameterizedType)type);
        object = TypeUtils.determineTypeArguments(clazz2, (ParameterizedType)object);
        TypeUtils.a(clazz, type, object);
        return object;
    }

    private static boolean a(GenericArrayType genericArrayType, Type type) {
        return type instanceof GenericArrayType && TypeUtils.equals(genericArrayType.getGenericComponentType(), ((GenericArrayType)type).getGenericComponentType());
    }

    private static boolean a(ParameterizedType parameterizedType, Type type) {
        if (type instanceof ParameterizedType) {
            type = (ParameterizedType)type;
            if (TypeUtils.equals(parameterizedType.getRawType(), type.getRawType()) && TypeUtils.equals(parameterizedType.getOwnerType(), type.getOwnerType())) {
                return TypeUtils.a(parameterizedType.getActualTypeArguments(), type.getActualTypeArguments());
            }
        }
        return false;
    }

    public static boolean equals(Type type, Type type2) {
        if (Objects.equals(type, type2)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.a((ParameterizedType)type, type2);
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.a((GenericArrayType)type, type2);
        }
        if (type instanceof WildcardType) {
            return TypeUtils.a((WildcardType)type, type2);
        }
        return false;
    }

    private static boolean a(Type[] typeArray, Type[] typeArray2) {
        if (typeArray.length == typeArray2.length) {
            for (int i2 = 0; i2 < typeArray.length; ++i2) {
                if (TypeUtils.equals(typeArray[i2], typeArray2[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean a(WildcardType wildcardType, Type type) {
        if (type instanceof WildcardType) {
            type = (WildcardType)type;
            return TypeUtils.a(TypeUtils.getImplicitLowerBounds(wildcardType), TypeUtils.getImplicitLowerBounds((WildcardType)type)) && TypeUtils.a(TypeUtils.getImplicitUpperBounds(wildcardType), TypeUtils.getImplicitUpperBounds((WildcardType)type));
        }
        return false;
    }

    private static Type[] a(Map<TypeVariable<?>, Type> map, TypeVariable<?>[] typeVariableArray) {
        Type[] typeArray = new Type[typeVariableArray.length];
        int n2 = 0;
        for (TypeVariable<?> typeVariable : typeVariableArray) {
            Validate.isTrue(map.containsKey(typeVariable), "missing argument mapping for %s", TypeUtils.toString(typeVariable));
            typeArray[n2++] = map.get(typeVariable);
        }
        return typeArray;
    }

    public static GenericArrayType genericArrayType(Type type) {
        return new a(Validate.notNull(type, "componentType", new Object[0]), 0);
    }

    public static Type getArrayComponentType(Type type) {
        if (type instanceof Class) {
            if (((Class)(type = (Class)type)).isArray()) {
                return ((Class)type).getComponentType();
            }
            return null;
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        return null;
    }

    private static Type a(Class<?> clazz, Class<?> clazz2) {
        if (clazz2.isInterface()) {
            Type[] typeArray = clazz.getGenericInterfaces();
            Type type = null;
            for (Type type2 : typeArray) {
                Class clazz3;
                if (type2 instanceof ParameterizedType) {
                    clazz3 = TypeUtils.a((ParameterizedType)type2);
                } else if (type2 instanceof Class) {
                    clazz3 = (Class)type2;
                } else {
                    throw new IllegalStateException("Unexpected generic interface type found: " + type2);
                }
                if (!TypeUtils.a((Type)clazz3, clazz2) || !TypeUtils.isAssignable(type, clazz3)) continue;
                type = type2;
            }
            if (type != null) {
                return type;
            }
        }
        return clazz.getGenericSuperclass();
    }

    public static Type[] getImplicitBounds(TypeVariable<?> typeArray) {
        Validate.notNull(typeArray, "typeVariable", new Object[0]);
        typeArray = typeArray.getBounds();
        if (typeArray.length == 0) {
            return new Type[]{Object.class};
        }
        return TypeUtils.normalizeUpperBounds(typeArray);
    }

    public static Type[] getImplicitLowerBounds(WildcardType typeArray) {
        Validate.notNull(typeArray, "wildcardType", new Object[0]);
        typeArray = typeArray.getLowerBounds();
        if (typeArray.length == 0) {
            return new Type[]{null};
        }
        return typeArray;
    }

    public static Type[] getImplicitUpperBounds(WildcardType typeArray) {
        Validate.notNull(typeArray, "wildcardType", new Object[0]);
        typeArray = typeArray.getUpperBounds();
        if (typeArray.length == 0) {
            return new Type[]{Object.class};
        }
        return TypeUtils.normalizeUpperBounds(typeArray);
    }

    private static Class<?> a(ParameterizedType type) {
        if (!((type = type.getRawType()) instanceof Class)) {
            throw new IllegalStateException("Wait... What!? Type of rawType: " + type);
        }
        return (Class)type;
    }

    public static Class<?> getRawType(Type type, Type type2) {
        Object object;
        while (true) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.a((ParameterizedType)type);
            }
            if (!(type instanceof TypeVariable)) break;
            if (type2 == null) {
                return null;
            }
            object = ((TypeVariable)type).getGenericDeclaration();
            if (!(object instanceof Class)) {
                return null;
            }
            if ((object = TypeUtils.getTypeArguments(type2, (Class)object)) == null) {
                return null;
            }
            if ((type = (Type)object.get(type)) != null) continue;
            return null;
        }
        if (type instanceof GenericArrayType) {
            object = TypeUtils.getRawType(((GenericArrayType)type).getGenericComponentType(), type2);
            return Array.newInstance(object, 0).getClass();
        }
        if (type instanceof WildcardType) {
            return null;
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }

    private static Map<TypeVariable<?>, Type> a(Class<?> clazz, Class<?> clazz2, Map<TypeVariable<?>, Type> map) {
        if (!TypeUtils.a(clazz, clazz2)) {
            return null;
        }
        if (clazz.isPrimitive()) {
            if (clazz2.isPrimitive()) {
                return new HashMap();
            }
            clazz = ClassUtils.primitiveToWrapper(clazz);
        }
        Map<TypeVariable<?>, Type> map2 = map = map == null ? new HashMap() : new HashMap(map);
        if (clazz2.equals(clazz)) {
            return map;
        }
        return TypeUtils.a(TypeUtils.a(clazz, clazz2), clazz2, map);
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType parameterizedType) {
        ParameterizedType parameterizedType2 = parameterizedType;
        return TypeUtils.a(parameterizedType2, TypeUtils.a(parameterizedType2), null);
    }

    private static Map<TypeVariable<?>, Type> a(ParameterizedType typeVariableArray, Class<?> clazz, Map<TypeVariable<?>, Type> map) {
        Map<TypeVariable<?>, Type> map2;
        Class<?> clazz2 = TypeUtils.a((ParameterizedType)typeVariableArray);
        if (!TypeUtils.a(clazz2, clazz)) {
            return null;
        }
        Type[] typeArray = typeVariableArray.getOwnerType();
        if (typeArray instanceof ParameterizedType) {
            typeArray = (ParameterizedType)typeArray;
            map2 = TypeUtils.a((ParameterizedType)typeArray, TypeUtils.a((ParameterizedType)typeArray), map);
        } else {
            map2 = map == null ? new HashMap() : new HashMap(map);
        }
        map = map2;
        typeArray = typeVariableArray.getActualTypeArguments();
        typeVariableArray = clazz2.getTypeParameters();
        for (int i2 = 0; i2 < typeVariableArray.length; ++i2) {
            Type type;
            Type type2 = type = typeArray[i2];
            map.put(typeVariableArray[i2], map.getOrDefault(type2, type2));
        }
        if (clazz.equals(clazz2)) {
            return map;
        }
        return TypeUtils.a(TypeUtils.a(clazz2, clazz), clazz, map);
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> clazz) {
        return TypeUtils.a(type, clazz, null);
    }

    private static Map<TypeVariable<?>, Type> a(Type object, Class<?> clazz, Map<TypeVariable<?>, Type> map) {
        block7: {
            block0: while (true) {
                Type type;
                int n2;
                int n3;
                if (object instanceof Class) {
                    return TypeUtils.a((Class)object, clazz, map);
                }
                if (object instanceof ParameterizedType) {
                    return TypeUtils.a((ParameterizedType)object, clazz, map);
                }
                if (object instanceof GenericArrayType) {
                    clazz = clazz.isArray() ? clazz.getComponentType() : clazz;
                    object = ((GenericArrayType)object).getGenericComponentType();
                    continue;
                }
                if (object instanceof WildcardType) {
                    object = TypeUtils.getImplicitUpperBounds((WildcardType)object);
                    n3 = ((Type[])object).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        type = object[n2];
                        if (!TypeUtils.a(type, clazz)) continue;
                        object = type;
                        continue block0;
                    }
                    return null;
                }
                if (!(object instanceof TypeVariable)) break block7;
                object = TypeUtils.getImplicitBounds((TypeVariable)object);
                n3 = ((Type[])object).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    type = object[n2];
                    if (!TypeUtils.a(type, clazz)) continue;
                    object = type;
                    continue block0;
                }
                break;
            }
            return null;
        }
        throw new IllegalStateException("found an unhandled type: " + object);
    }

    public static boolean isArrayType(Type type) {
        return type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray();
    }

    private static boolean a(Type typeArray, Class<?> clazz) {
        while (true) {
            if (typeArray == null) {
                return clazz == null || !clazz.isPrimitive();
            }
            if (clazz == null) {
                return false;
            }
            if (clazz.equals(typeArray)) {
                return true;
            }
            if (typeArray instanceof Class) {
                return ClassUtils.isAssignable((Class)typeArray, clazz);
            }
            if (!(typeArray instanceof ParameterizedType)) break;
            typeArray = TypeUtils.a((ParameterizedType)typeArray);
        }
        if (typeArray instanceof TypeVariable) {
            for (Type type : ((TypeVariable)typeArray).getBounds()) {
                if (!TypeUtils.a(type, clazz)) continue;
                return true;
            }
            return false;
        }
        if (typeArray instanceof GenericArrayType) {
            return clazz.equals(Object.class) || clazz.isArray() && TypeUtils.a(((GenericArrayType)typeArray).getGenericComponentType(), clazz.getComponentType());
        }
        if (typeArray instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + typeArray);
    }

    private static boolean a(Type typeArray, GenericArrayType genericArrayType, Map<TypeVariable<?>, Type> map) {
        if (typeArray == null) {
            return true;
        }
        if (genericArrayType == null) {
            return false;
        }
        if (genericArrayType.equals(typeArray)) {
            return true;
        }
        Type type = genericArrayType.getGenericComponentType();
        if (typeArray instanceof Class) {
            return (typeArray = (Class)typeArray).isArray() && TypeUtils.a(typeArray.getComponentType(), type, map);
        }
        if (typeArray instanceof GenericArrayType) {
            return TypeUtils.a(((GenericArrayType)typeArray).getGenericComponentType(), type, map);
        }
        if (typeArray instanceof WildcardType) {
            for (Type type2 : TypeUtils.getImplicitUpperBounds((WildcardType)typeArray)) {
                if (!TypeUtils.isAssignable(type2, genericArrayType)) continue;
                return true;
            }
            return false;
        }
        if (typeArray instanceof TypeVariable) {
            for (Type type3 : TypeUtils.getImplicitBounds((TypeVariable)typeArray)) {
                if (!TypeUtils.isAssignable(type3, genericArrayType)) continue;
                return true;
            }
            return false;
        }
        if (typeArray instanceof ParameterizedType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + typeArray);
    }

    private static boolean a(Type object, ParameterizedType object2, Map<TypeVariable<?>, Type> map) {
        if (object == null) {
            return true;
        }
        if (object2 == null) {
            return false;
        }
        if (object instanceof GenericArrayType) {
            return false;
        }
        if (((Object)object2).equals(object)) {
            return true;
        }
        Class<?> clazz = TypeUtils.a((ParameterizedType)((Object)object2));
        if ((object = TypeUtils.a((Type)((Object)object), clazz, null)) == null) {
            return false;
        }
        if (object.isEmpty()) {
            return true;
        }
        object2 = TypeUtils.a((ParameterizedType)((Object)object2), clazz, map);
        for (TypeVariable typeVariable : object2.keySet()) {
            Type type = TypeUtils.a(typeVariable, object2);
            Type type2 = TypeUtils.a(typeVariable, object);
            if (type == null && type2 instanceof Class || type2 == null || type == null || type.equals(type2) || type instanceof WildcardType && TypeUtils.a(type2, type, map)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Type type, Type type2) {
        return TypeUtils.a(type, type2, null);
    }

    private static boolean a(Type type, Type type2, Map<TypeVariable<?>, Type> map) {
        if (type2 == null || type2 instanceof Class) {
            return TypeUtils.a(type, (Class)type2);
        }
        if (type2 instanceof ParameterizedType) {
            return TypeUtils.a(type, (ParameterizedType)type2, map);
        }
        if (type2 instanceof GenericArrayType) {
            return TypeUtils.a(type, (GenericArrayType)type2, map);
        }
        if (type2 instanceof WildcardType) {
            return TypeUtils.a(type, (WildcardType)type2, map);
        }
        if (type2 instanceof TypeVariable) {
            return TypeUtils.a(type, (TypeVariable)type2, map);
        }
        throw new IllegalStateException("found an unhandled type: " + type2);
    }

    private static boolean a(Type type, TypeVariable<?> typeVariable, Map<TypeVariable<?>, Type> map) {
        if (type == null) {
            return true;
        }
        if (typeVariable == null) {
            return false;
        }
        if (typeVariable.equals(type)) {
            return true;
        }
        if (type instanceof TypeVariable) {
            Type[] typeArray = TypeUtils.getImplicitBounds((TypeVariable)type);
            Type[] typeArray2 = typeArray;
            typeArray2 = typeArray;
            int n2 = typeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Type type2 = typeArray2[i2];
                if (!TypeUtils.a(type2, typeVariable, map)) continue;
                return true;
            }
        }
        if (type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType || type instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static boolean a(Type type, WildcardType typeArray, Map<TypeVariable<?>, Type> map) {
        int n2;
        if (type == null) {
            return true;
        }
        if (typeArray == null) {
            return false;
        }
        if (typeArray.equals(type)) {
            return true;
        }
        Type[] object = TypeUtils.getImplicitUpperBounds((WildcardType)typeArray);
        typeArray = TypeUtils.getImplicitLowerBounds((WildcardType)typeArray);
        if (type instanceof WildcardType) {
            Type type2;
            int n3;
            int n4;
            Type[] typeArray2;
            Type type3;
            int n5;
            WildcardType wildcardType = (WildcardType)type;
            Type[] typeArray3 = TypeUtils.getImplicitUpperBounds(wildcardType);
            Type[] typeArray4 = TypeUtils.getImplicitLowerBounds(wildcardType);
            Type[] typeArray5 = object;
            int n52 = object.length;
            for (n5 = 0; n5 < n52; ++n5) {
                type3 = typeArray5[n5];
                type3 = TypeUtils.a(type3, map);
                typeArray2 = typeArray3;
                n4 = typeArray3.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    type2 = typeArray2[n3];
                    if (TypeUtils.a(type2, type3, map)) continue;
                    return false;
                }
            }
            Type[] typeArray6 = typeArray;
            n52 = typeArray.length;
            for (n5 = 0; n5 < n52; ++n5) {
                type3 = typeArray6[n5];
                type3 = TypeUtils.a(type3, map);
                typeArray2 = typeArray4;
                n4 = typeArray4.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    type2 = typeArray2[n3];
                    if (TypeUtils.a(type3, type2, map)) continue;
                    return false;
                }
            }
            return true;
        }
        Type[] typeArray7 = object;
        int n6 = object.length;
        for (n2 = 0; n2 < n6; ++n2) {
            Type type4 = typeArray7[n2];
            if (TypeUtils.a(type, TypeUtils.a(type4, map), map)) continue;
            return false;
        }
        typeArray7 = typeArray;
        n6 = typeArray.length;
        for (n2 = 0; n2 < n6; ++n2) {
            Type type5 = typeArray7[n2];
            if (TypeUtils.a(TypeUtils.a(type5, map), type, map)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInstance(Object object, Type type) {
        if (type == null) {
            return false;
        }
        if (object == null) {
            return !(type instanceof Class) || !((Class)type).isPrimitive();
        }
        return TypeUtils.a(object.getClass(), type, null);
    }

    private static <T> void a(Class<T> object, ParameterizedType typeVariableArray, Map<TypeVariable<?>, Type> map) {
        Type[] typeArray = typeVariableArray.getOwnerType();
        if (typeArray instanceof ParameterizedType) {
            TypeUtils.a(object, (ParameterizedType)typeArray, map);
        }
        typeArray = typeVariableArray.getActualTypeArguments();
        typeVariableArray = TypeUtils.a((ParameterizedType)typeVariableArray).getTypeParameters();
        object = Arrays.asList(((Class)object).getTypeParameters());
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            TypeVariable<Class<?>> typeVariable = typeVariableArray[i2];
            Type type = typeArray[i2];
            if (!object.contains(type) || !map.containsKey(typeVariable)) continue;
            map.put((TypeVariable)type, map.get(typeVariable));
        }
    }

    public static Type[] normalizeUpperBounds(Type[] typeArray) {
        Validate.notNull(typeArray, "bounds", new Object[0]);
        if (typeArray.length < 2) {
            return typeArray;
        }
        HashSet<Type> hashSet = new HashSet<Type>(typeArray.length);
        Type[] typeArray2 = typeArray;
        int n2 = typeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Type type = typeArray2[i2];
            boolean bl2 = false;
            Type[] typeArray3 = typeArray;
            int n3 = typeArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Type type2 = typeArray3[i3];
                if (type == type2 || !TypeUtils.a(type2, type, null)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            hashSet.add(type);
        }
        return hashSet.toArray(ArrayUtils.EMPTY_TYPE_ARRAY);
    }

    public static final ParameterizedType parameterize(Class<?> clazz, Map<TypeVariable<?>, Type> map) {
        Validate.notNull(clazz, "rawClass", new Object[0]);
        Validate.notNull(map, "typeVariableMap", new Object[0]);
        return TypeUtils.parameterizeWithOwner(null, clazz, TypeUtils.a(map, clazz.getTypeParameters()));
    }

    public static final ParameterizedType parameterize(Class<?> clazz, Type ... typeArray) {
        return TypeUtils.parameterizeWithOwner(null, clazz, typeArray);
    }

    public static final ParameterizedType parameterizeWithOwner(Type type, Class<?> clazz, Map<TypeVariable<?>, Type> map) {
        Validate.notNull(clazz, "rawClass", new Object[0]);
        Validate.notNull(map, "typeVariableMap", new Object[0]);
        return TypeUtils.parameterizeWithOwner(type, clazz, TypeUtils.a(map, clazz.getTypeParameters()));
    }

    public static final ParameterizedType parameterizeWithOwner(Type clazz, Class<?> clazz2, Type ... typeArray) {
        Validate.notNull(clazz2, "rawClass", new Object[0]);
        if (clazz2.getEnclosingClass() == null) {
            Validate.isTrue(clazz == null, "no owner allowed for top-level %s", clazz2);
            clazz = null;
        } else if (clazz == null) {
            clazz = clazz2.getEnclosingClass();
        } else {
            Validate.isTrue(TypeUtils.a(clazz, clazz2.getEnclosingClass()), "%s is invalid owner type for parameterized %s", clazz, clazz2);
        }
        Validate.noNullElements(typeArray, "null type argument at index %s", new Object[0]);
        Validate.isTrue(clazz2.getTypeParameters().length == typeArray.length, "invalid number of type parameters specified: expected %d, got %d", clazz2.getTypeParameters().length, typeArray.length);
        return new b(clazz2, clazz, typeArray, 0);
    }

    private static Type a(Type type, Map<TypeVariable<?>, Type> object) {
        if (type instanceof TypeVariable && object != null) {
            if ((object = object.get(type)) == null) {
                throw new IllegalArgumentException("missing assignment type for type variable " + type);
            }
            return object;
        }
        return type;
    }

    public static String toLongString(TypeVariable<?> typeVariable) {
        StringBuilder stringBuilder;
        block5: {
            Validate.notNull(typeVariable, "typeVariable", new Object[0]);
            stringBuilder = new StringBuilder();
            Object object = typeVariable.getGenericDeclaration();
            if (object instanceof Class) {
                object = (Class)object;
                while (true) {
                    if (((Class)object).getEnclosingClass() == null) {
                        stringBuilder.insert(0, ((Class)object).getName());
                        break block5;
                    }
                    stringBuilder.insert(0, ((Class)object).getSimpleName()).insert(0, '.');
                    object = ((Class)object).getEnclosingClass();
                }
            }
            if (object instanceof Type) {
                stringBuilder.append(TypeUtils.toString((Type)object));
            } else {
                stringBuilder.append(object);
            }
        }
        return stringBuilder.append(':').append(TypeUtils.a(typeVariable)).toString();
    }

    private static <T> String a(T t2) {
        if (t2 instanceof Type) {
            return TypeUtils.toString((Type)t2);
        }
        return t2.toString();
    }

    public static String toString(Type type) {
        Validate.notNull(type);
        if (type instanceof Class) {
            return TypeUtils.a((Class)type);
        }
        if (type instanceof ParameterizedType) {
            int n2;
            type = (ParameterizedType)type;
            StringBuilder stringBuilder = new StringBuilder();
            Object object = type.getOwnerType();
            Object object2 = (Type[])type.getRawType();
            if (object == null) {
                stringBuilder.append(object2.getName());
            } else {
                if (object instanceof Class) {
                    stringBuilder.append(((Class)object).getName());
                } else {
                    stringBuilder.append(object.toString());
                }
                stringBuilder.append('.').append(object2.getSimpleName());
            }
            object = type;
            object2 = Arrays.copyOf(object.getActualTypeArguments(), object.getActualTypeArguments().length);
            Object[] objectArray = new int[]{};
            for (n2 = 0; n2 < ((Type[])object2).length; ++n2) {
                if (!(object2[n2] instanceof TypeVariable)) continue;
                Object object3 = object;
                TypeVariable typeVariable = (TypeVariable)object2[n2];
                if (!ArrayUtils.contains(typeVariable.getBounds(), object3)) continue;
                objectArray = ArrayUtils.add(objectArray, n2);
            }
            object = objectArray;
            if (objectArray.length > 0) {
                objectArray = type.getActualTypeArguments();
                object2 = object;
                object = stringBuilder;
                for (n2 = 0; n2 < ((Type[])object2).length; ++n2) {
                    TypeUtils.a(((StringBuilder)object).append('<'), ", ", objectArray[n2].toString()).append('>');
                }
                Type[] typeArray = (Type[])ArrayUtils.removeAll(objectArray, (int[])object2);
                if (typeArray.length > 0) {
                    TypeUtils.a(((StringBuilder)object).append('<'), ", ", typeArray).append('>');
                }
            } else {
                TypeUtils.a(stringBuilder.append('<'), ", ", type.getActualTypeArguments()).append('>');
            }
            return stringBuilder.toString();
        }
        if (type instanceof WildcardType) {
            type = (WildcardType)type;
            StringBuilder stringBuilder = new StringBuilder("?");
            Type[] typeArray = type.getLowerBounds();
            Type[] typeArray2 = type.getUpperBounds();
            if (typeArray.length > 1 || typeArray.length == 1 && typeArray[0] != null) {
                TypeUtils.a(stringBuilder.append(" super "), " & ", typeArray);
            } else if (typeArray2.length > 1 || typeArray2.length == 1 && !Object.class.equals((Object)typeArray2[0])) {
                TypeUtils.a(stringBuilder.append(" extends "), " & ", typeArray2);
            }
            return stringBuilder.toString();
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.a((TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            type = (GenericArrayType)type;
            return String.format("%s[]", TypeUtils.toString(type.getGenericComponentType()));
        }
        throw new IllegalArgumentException(ObjectUtils.identityToString(type));
    }

    public static boolean typesSatisfyVariables(Map<TypeVariable<?>, Type> map) {
        Validate.notNull(map, "typeVariableMap", new Object[0]);
        for (Map.Entry<TypeVariable<?>, Type> entry : map.entrySet()) {
            Type[] typeArray = entry.getKey();
            Type object = entry.getValue();
            for (Type type : TypeUtils.getImplicitBounds(typeArray)) {
                if (TypeUtils.a(object, TypeUtils.a(type, map), map)) continue;
                return false;
            }
        }
        return true;
    }

    private static String a(TypeVariable<?> typeVariable) {
        StringBuilder stringBuilder = new StringBuilder(typeVariable.getName());
        Type[] typeArray = typeVariable.getBounds();
        if (!(typeArray.length <= 0 || typeArray.length == 1 && Object.class.equals((Object)typeArray[0]))) {
            stringBuilder.append(" extends ");
            TypeUtils.a(stringBuilder, " & ", typeVariable.getBounds());
        }
        return stringBuilder.toString();
    }

    private static Type[] a(Map<TypeVariable<?>, Type> map, Type[] typeArray) {
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            Type type = TypeUtils.unrollVariables(map, typeArray[i2]);
            if (type == null) {
                typeArray = ArrayUtils.remove(typeArray, i2--);
                continue;
            }
            typeArray[i2] = type;
        }
        return typeArray;
    }

    private static Type a(TypeVariable<?> typeVariable, Map<TypeVariable<?>, Type> map) {
        Type type;
        while ((type = map.get(typeVariable)) instanceof TypeVariable && !type.equals(typeVariable)) {
            typeVariable = (TypeVariable)type;
        }
        return type;
    }

    public static Type unrollVariables(Map<TypeVariable<?>, Type> map, Type type) {
        block6: {
            while (true) {
                if (map == null) {
                    map = Collections.emptyMap();
                }
                if (!TypeUtils.containsTypeVariables(type)) break block6;
                if (!(type instanceof TypeVariable)) break;
                type = map.get(type);
            }
            if (type instanceof ParameterizedType) {
                if ((type = (ParameterizedType)type).getOwnerType() != null) {
                    map = new HashMap<TypeVariable<Object>, Type>(map);
                    map.putAll(TypeUtils.getTypeArguments((ParameterizedType)type));
                }
                Type[] typeArray = type.getActualTypeArguments();
                for (int i2 = 0; i2 < typeArray.length; ++i2) {
                    Type type2 = TypeUtils.unrollVariables(map, typeArray[i2]);
                    if (type2 == null) continue;
                    typeArray[i2] = type2;
                }
                return TypeUtils.parameterizeWithOwner(type.getOwnerType(), (Class)type.getRawType(), typeArray);
            }
            if (type instanceof WildcardType) {
                type = (WildcardType)type;
                return TypeUtils.wildcardType().withUpperBounds(TypeUtils.a(map, type.getUpperBounds())).withLowerBounds(TypeUtils.a(map, type.getLowerBounds())).build();
            }
        }
        return type;
    }

    public static WildcardTypeBuilder wildcardType() {
        return new WildcardTypeBuilder(0);
    }

    public static <T> Typed<T> wrap(Class<T> clazz) {
        return TypeUtils.wrap(clazz);
    }

    public static <T> Typed<T> wrap(Type type) {
        return () -> type;
    }

    private static final class c
    implements WildcardType {
        private final Type[] a;
        private final Type[] b;

        private c(Type[] typeArray, Type[] typeArray2) {
            this.a = ObjectUtils.defaultIfNull(typeArray, ArrayUtils.EMPTY_TYPE_ARRAY);
            this.b = ObjectUtils.defaultIfNull(typeArray2, ArrayUtils.EMPTY_TYPE_ARRAY);
        }

        public final boolean equals(Object object) {
            return object == this || object instanceof WildcardType && TypeUtils.a((WildcardType)this, (Type)((WildcardType)object));
        }

        @Override
        public final Type[] getLowerBounds() {
            return (Type[])this.b.clone();
        }

        @Override
        public final Type[] getUpperBounds() {
            return (Type[])this.a.clone();
        }

        public final int hashCode() {
            int n2 = 0x4900 | Arrays.hashCode(this.a);
            n2 <<= 8;
            return n2 |= Arrays.hashCode(this.b);
        }

        public final String toString() {
            return TypeUtils.toString(this);
        }

        /* synthetic */ c(Type[] typeArray, Type[] typeArray2, byte by) {
            this(typeArray, typeArray2);
        }
    }

    public static class WildcardTypeBuilder
    implements Builder<WildcardType> {
        private Type[] a;
        private Type[] b;

        private WildcardTypeBuilder() {
        }

        @Override
        public WildcardType build() {
            return new c(this.a, this.b, 0);
        }

        public WildcardTypeBuilder withLowerBounds(Type ... typeArray) {
            this.b = typeArray;
            return this;
        }

        public WildcardTypeBuilder withUpperBounds(Type ... typeArray) {
            this.a = typeArray;
            return this;
        }

        /* synthetic */ WildcardTypeBuilder(byte by) {
            this();
        }
    }

    private static final class b
    implements ParameterizedType {
        private final Class<?> a;
        private final Type b;
        private final Type[] c;

        private b(Class<?> clazz, Type type, Type[] typeArray) {
            this.a = clazz;
            this.b = type;
            this.c = (Type[])Arrays.copyOf(typeArray, typeArray.length, Type[].class);
        }

        public final boolean equals(Object object) {
            return object == this || object instanceof ParameterizedType && TypeUtils.a((ParameterizedType)this, (Type)((ParameterizedType)object));
        }

        @Override
        public final Type[] getActualTypeArguments() {
            return (Type[])this.c.clone();
        }

        @Override
        public final Type getOwnerType() {
            return this.b;
        }

        @Override
        public final Type getRawType() {
            return this.a;
        }

        public final int hashCode() {
            int n2 = 0x470 | this.a.hashCode();
            n2 <<= 4;
            n2 |= Objects.hashCode(this.b);
            n2 <<= 8;
            return n2 |= Arrays.hashCode(this.c);
        }

        public final String toString() {
            return TypeUtils.toString(this);
        }

        /* synthetic */ b(Class clazz, Type type, Type[] typeArray, byte by) {
            this(clazz, type, typeArray);
        }
    }

    private static final class a
    implements GenericArrayType {
        private final Type a;

        private a(Type type) {
            this.a = type;
        }

        public final boolean equals(Object object) {
            return object == this || object instanceof GenericArrayType && TypeUtils.a((GenericArrayType)this, (Type)((GenericArrayType)object));
        }

        @Override
        public final Type getGenericComponentType() {
            return this.a;
        }

        public final int hashCode() {
            int n2 = 0x430 | this.a.hashCode();
            return n2;
        }

        public final String toString() {
            return TypeUtils.toString(this);
        }

        /* synthetic */ a(Type type, byte by) {
            this(type);
        }
    }
}

