/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.lang3.time.FastTimeZone;

public class DateFormatUtils {
    private static final TimeZone a = FastTimeZone.getGmtTimeZone();
    public static final FastDateFormat ISO_8601_EXTENDED_DATETIME_FORMAT;
    @Deprecated
    public static final FastDateFormat ISO_DATETIME_FORMAT;
    public static final FastDateFormat ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT;
    @Deprecated
    public static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT;
    public static final FastDateFormat ISO_8601_EXTENDED_DATE_FORMAT;
    @Deprecated
    public static final FastDateFormat ISO_DATE_FORMAT;
    @Deprecated
    public static final FastDateFormat ISO_DATE_TIME_ZONE_FORMAT;
    @Deprecated
    public static final FastDateFormat ISO_TIME_FORMAT;
    @Deprecated
    public static final FastDateFormat ISO_TIME_TIME_ZONE_FORMAT;
    public static final FastDateFormat ISO_8601_EXTENDED_TIME_FORMAT;
    @Deprecated
    public static final FastDateFormat ISO_TIME_NO_T_FORMAT;
    public static final FastDateFormat ISO_8601_EXTENDED_TIME_TIME_ZONE_FORMAT;
    @Deprecated
    public static final FastDateFormat ISO_TIME_NO_T_TIME_ZONE_FORMAT;
    public static final FastDateFormat SMTP_DATETIME_FORMAT;

    public static String formatUTC(long l2, String string) {
        return DateFormatUtils.format(new Date(l2), string, a, null);
    }

    public static String formatUTC(Date date, String string) {
        return DateFormatUtils.format(date, string, a, null);
    }

    public static String formatUTC(long l2, String string, Locale locale) {
        return DateFormatUtils.format(new Date(l2), string, a, locale);
    }

    public static String formatUTC(Date date, String string, Locale locale) {
        return DateFormatUtils.format(date, string, a, locale);
    }

    public static String format(long l2, String string) {
        return DateFormatUtils.format(new Date(l2), string, null, null);
    }

    public static String format(Date date, String string) {
        return DateFormatUtils.format(date, string, null, null);
    }

    public static String format(Calendar calendar, String string) {
        return DateFormatUtils.format(calendar, string, null, null);
    }

    public static String format(long l2, String string, TimeZone timeZone) {
        return DateFormatUtils.format(new Date(l2), string, timeZone, null);
    }

    public static String format(Date date, String string, TimeZone timeZone) {
        return DateFormatUtils.format(date, string, timeZone, null);
    }

    public static String format(Calendar calendar, String string, TimeZone timeZone) {
        return DateFormatUtils.format(calendar, string, timeZone, null);
    }

    public static String format(long l2, String string, Locale locale) {
        return DateFormatUtils.format(new Date(l2), string, null, locale);
    }

    public static String format(Date date, String string, Locale locale) {
        return DateFormatUtils.format(date, string, null, locale);
    }

    public static String format(Calendar calendar, String string, Locale locale) {
        return DateFormatUtils.format(calendar, string, null, locale);
    }

    public static String format(long l2, String string, TimeZone timeZone, Locale locale) {
        return DateFormatUtils.format(new Date(l2), string, timeZone, locale);
    }

    public static String format(Date date, String object, TimeZone timeZone, Locale locale) {
        object = FastDateFormat.getInstance((String)object, timeZone, locale);
        return ((FastDateFormat)object).format(date);
    }

    public static String format(Calendar calendar, String object, TimeZone timeZone, Locale locale) {
        object = FastDateFormat.getInstance((String)object, timeZone, locale);
        return ((FastDateFormat)object).format(calendar);
    }

    static {
        ISO_DATETIME_FORMAT = ISO_8601_EXTENDED_DATETIME_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss");
        ISO_DATETIME_TIME_ZONE_FORMAT = ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ssZZ");
        ISO_DATE_FORMAT = ISO_8601_EXTENDED_DATE_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd");
        ISO_DATE_TIME_ZONE_FORMAT = FastDateFormat.getInstance("yyyy-MM-ddZZ");
        ISO_TIME_FORMAT = FastDateFormat.getInstance("'T'HH:mm:ss");
        ISO_TIME_TIME_ZONE_FORMAT = FastDateFormat.getInstance("'T'HH:mm:ssZZ");
        ISO_TIME_NO_T_FORMAT = ISO_8601_EXTENDED_TIME_FORMAT = FastDateFormat.getInstance("HH:mm:ss");
        ISO_TIME_NO_T_TIME_ZONE_FORMAT = ISO_8601_EXTENDED_TIME_TIME_ZONE_FORMAT = FastDateFormat.getInstance("HH:mm:ssZZ");
        SMTP_DATETIME_FORMAT = FastDateFormat.getInstance("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
    }
}

