/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.FastDateParser;

public class DateUtils {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int SEMI_MONTH = 1001;
    private static final int[][] a = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, {0}};
    public static final int RANGE_WEEK_SUNDAY = 1;
    public static final int RANGE_WEEK_MONDAY = 2;
    public static final int RANGE_WEEK_RELATIVE = 3;
    public static final int RANGE_WEEK_CENTER = 4;
    public static final int RANGE_MONTH_SUNDAY = 5;
    public static final int RANGE_MONTH_MONDAY = 6;

    public static boolean isSameDay(Date comparable, Date date) {
        if (comparable == null || date == null) {
            throw DateUtils.a();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)comparable);
        comparable = Calendar.getInstance();
        ((Calendar)comparable).setTime(date);
        return DateUtils.isSameDay(calendar, (Calendar)comparable);
    }

    public static boolean isSameDay(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw DateUtils.a();
        }
        return calendar.get(0) == calendar2.get(0) && calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    public static boolean isSameInstant(Date date, Date date2) {
        if (date == null || date2 == null) {
            throw DateUtils.a();
        }
        return date.getTime() == date2.getTime();
    }

    public static boolean isSameInstant(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw DateUtils.a();
        }
        return calendar.getTime().getTime() == calendar2.getTime().getTime();
    }

    public static boolean isSameLocalTime(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw DateUtils.a();
        }
        return calendar.get(14) == calendar2.get(14) && calendar.get(13) == calendar2.get(13) && calendar.get(12) == calendar2.get(12) && calendar.get(11) == calendar2.get(11) && calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1) && calendar.get(0) == calendar2.get(0) && calendar.getClass() == calendar2.getClass();
    }

    public static Date parseDate(String string, String ... stringArray) {
        return DateUtils.parseDate(string, null, stringArray);
    }

    public static Date parseDate(String string, Locale locale, String ... stringArray) {
        return DateUtils.a(string, locale, stringArray, true);
    }

    public static Date parseDateStrictly(String string, String ... stringArray) {
        return DateUtils.parseDateStrictly(string, null, stringArray);
    }

    public static Date parseDateStrictly(String string, Locale locale, String ... stringArray) {
        return DateUtils.a(string, locale, stringArray, false);
    }

    private static Date a(String string, Locale locale, String[] stringArray, boolean n2) {
        if (string == null || stringArray == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        TimeZone timeZone = TimeZone.getDefault();
        locale = LocaleUtils.toLocale(locale);
        ParsePosition parsePosition = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        calendar.setLenient(n2 != 0);
        for (String string2 : stringArray) {
            FastDateParser object = new FastDateParser(string2, timeZone, locale);
            calendar.clear();
            try {
                if (object.parse(string, parsePosition, calendar) && parsePosition.getIndex() == string.length()) {
                    return calendar.getTime();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            parsePosition.setIndex(0);
        }
        throw new ParseException("Unable to parse the date: " + string, -1);
    }

    public static Date addYears(Date date, int n2) {
        return DateUtils.a(date, 1, n2);
    }

    public static Date addMonths(Date date, int n2) {
        return DateUtils.a(date, 2, n2);
    }

    public static Date addWeeks(Date date, int n2) {
        return DateUtils.a(date, 3, n2);
    }

    public static Date addDays(Date date, int n2) {
        return DateUtils.a(date, 5, n2);
    }

    public static Date addHours(Date date, int n2) {
        return DateUtils.a(date, 11, n2);
    }

    public static Date addMinutes(Date date, int n2) {
        return DateUtils.a(date, 12, n2);
    }

    public static Date addSeconds(Date date, int n2) {
        return DateUtils.a(date, 13, n2);
    }

    public static Date addMilliseconds(Date date, int n2) {
        return DateUtils.a(date, 14, n2);
    }

    private static Date a(Date date, int n2, int n3) {
        DateUtils.a(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(n2, n3);
        return calendar.getTime();
    }

    public static Date setYears(Date date, int n2) {
        return DateUtils.b(date, 1, n2);
    }

    public static Date setMonths(Date date, int n2) {
        return DateUtils.b(date, 2, n2);
    }

    public static Date setDays(Date date, int n2) {
        return DateUtils.b(date, 5, n2);
    }

    public static Date setHours(Date date, int n2) {
        return DateUtils.b(date, 11, n2);
    }

    public static Date setMinutes(Date date, int n2) {
        return DateUtils.b(date, 12, n2);
    }

    public static Date setSeconds(Date date, int n2) {
        return DateUtils.b(date, 13, n2);
    }

    public static Date setMilliseconds(Date date, int n2) {
        return DateUtils.b(date, 14, n2);
    }

    private static Date b(Date date, int n2, int n3) {
        DateUtils.a(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTime(date);
        calendar.set(n2, n3);
        return calendar.getTime();
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar toCalendar(Date date, TimeZone cloneable) {
        cloneable = Calendar.getInstance(cloneable);
        ((Calendar)cloneable).setTime(date);
        return cloneable;
    }

    public static Date round(Date date, int n2) {
        DateUtils.a(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.a(calendar, n2, b.b);
        return calendar.getTime();
    }

    public static Calendar round(Calendar calendar, int n2) {
        if (calendar == null) {
            throw DateUtils.a();
        }
        calendar = (Calendar)calendar.clone();
        DateUtils.a(calendar, n2, b.b);
        return calendar;
    }

    private static IllegalArgumentException a() {
        return new IllegalArgumentException("The date must not be null");
    }

    public static Date round(Object object, int n2) {
        if (object == null) {
            throw DateUtils.a();
        }
        if (object instanceof Date) {
            return DateUtils.round((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.round((Calendar)object, n2).getTime();
        }
        throw new ClassCastException("Could not round " + object);
    }

    public static Date truncate(Date date, int n2) {
        DateUtils.a(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.a(calendar, n2, b.a);
        return calendar.getTime();
    }

    public static Calendar truncate(Calendar calendar, int n2) {
        if (calendar == null) {
            throw DateUtils.a();
        }
        calendar = (Calendar)calendar.clone();
        DateUtils.a(calendar, n2, b.a);
        return calendar;
    }

    public static Date truncate(Object object, int n2) {
        if (object == null) {
            throw DateUtils.a();
        }
        if (object instanceof Date) {
            return DateUtils.truncate((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.truncate((Calendar)object, n2).getTime();
        }
        throw new ClassCastException("Could not truncate " + object);
    }

    public static Date ceiling(Date date, int n2) {
        DateUtils.a(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.a(calendar, n2, b.c);
        return calendar.getTime();
    }

    public static Calendar ceiling(Calendar calendar, int n2) {
        if (calendar == null) {
            throw DateUtils.a();
        }
        calendar = (Calendar)calendar.clone();
        DateUtils.a(calendar, n2, b.c);
        return calendar;
    }

    public static Date ceiling(Object object, int n2) {
        if (object == null) {
            throw DateUtils.a();
        }
        if (object instanceof Date) {
            return DateUtils.ceiling((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.ceiling((Calendar)object, n2).getTime();
        }
        throw new ClassCastException("Could not find ceiling of for type: " + object.getClass());
    }

    private static void a(Calendar calendar, int n2, int n3) {
        if (calendar.get(1) > 280000000) {
            throw new ArithmeticException("Calendar value too large for accurate calculations");
        }
        if (n2 == 14) {
            return;
        }
        Date date = calendar.getTime();
        long l2 = date.getTime();
        int n4 = 0;
        int n5 = calendar.get(14);
        if (b.a == n3 || n5 < 500) {
            l2 -= (long)n5;
        }
        if (n2 == 13) {
            n4 = 1;
        }
        n5 = calendar.get(13);
        if (n4 == 0 && (b.a == n3 || n5 < 30)) {
            l2 -= (long)n5 * 1000L;
        }
        if (n2 == 12) {
            n4 = 1;
        }
        n5 = calendar.get(12);
        if (n4 == 0 && (b.a == n3 || n5 < 30)) {
            l2 -= (long)n5 * 60000L;
        }
        if (date.getTime() != l2) {
            date.setTime(l2);
            calendar.setTime(date);
        }
        boolean bl2 = false;
        int[][] nArray = a;
        int n6 = a.length;
        for (n4 = 0; n4 < n6; ++n4) {
            int n7;
            int n8;
            int[] nArray2;
            int[] nArray3 = nArray2 = nArray[n4];
            int n9 = nArray2.length;
            for (n8 = 0; n8 < n9; ++n8) {
                n7 = nArray3[n8];
                if (n7 != n2) continue;
                if (n3 == b.c || n3 == b.b && bl2) {
                    if (n2 == 1001) {
                        if (calendar.get(5) == 1) {
                            calendar.add(5, 15);
                            return;
                        }
                        calendar.add(5, -15);
                        calendar.add(2, 1);
                        return;
                    }
                    if (n2 == 9) {
                        if (calendar.get(11) == 0) {
                            calendar.add(11, 12);
                            return;
                        }
                        calendar.add(11, -12);
                        calendar.add(5, 1);
                        return;
                    }
                    calendar.add(nArray2[0], 1);
                }
                return;
            }
            int n10 = 0;
            n9 = 0;
            switch (n2) {
                case 1001: {
                    if (nArray2[0] != 5) break;
                    n10 = calendar.get(5) - 1;
                    if (n10 >= 15) {
                        n10 -= 15;
                    }
                    bl2 = n10 > 7;
                    n9 = 1;
                    break;
                }
                case 9: {
                    if (nArray2[0] != 11) break;
                    n10 = calendar.get(11);
                    if (n10 >= 12) {
                        n10 -= 12;
                    }
                    bl2 = n10 >= 6;
                    n9 = 1;
                }
            }
            if (n9 == 0) {
                n8 = calendar.getActualMinimum(nArray2[0]);
                n7 = calendar.getActualMaximum(nArray2[0]);
                n10 = calendar.get(nArray2[0]) - n8;
                boolean bl3 = bl2 = n10 > (n7 - n8) / 2;
            }
            if (n10 == 0) continue;
            calendar.set(nArray2[0], calendar.get(nArray2[0]) - n10);
        }
        throw new IllegalArgumentException("The field " + n2 + " is not supported");
    }

    public static Iterator<Calendar> iterator(Date date, int n2) {
        DateUtils.a(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.iterator(calendar, n2);
    }

    public static Iterator<Calendar> iterator(Calendar calendar, int n2) {
        Calendar calendar2;
        Calendar calendar3;
        if (calendar == null) {
            throw DateUtils.a();
        }
        int n3 = 1;
        int n4 = 7;
        block0 : switch (n2) {
            case 5: 
            case 6: {
                calendar3 = DateUtils.truncate(calendar, 2);
                calendar2 = (Calendar)calendar3.clone();
                calendar2.add(2, 1);
                calendar2.add(5, -1);
                if (n2 != 6) break;
                n3 = 2;
                n4 = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                calendar3 = DateUtils.truncate(calendar, 5);
                calendar2 = DateUtils.truncate(calendar, 5);
                switch (n2) {
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        n3 = 2;
                        n4 = 1;
                        break block0;
                    }
                    case 3: {
                        n3 = calendar.get(7);
                        n4 = n3 - 1;
                        break block0;
                    }
                    case 4: {
                        n3 = calendar.get(7) - 3;
                        n4 = calendar.get(7) + 3;
                        break block0;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The range style " + n2 + " is not valid.");
            }
        }
        if (n3 <= 0) {
            n3 += 7;
        }
        if (n3 > 7) {
            n3 -= 7;
        }
        if (n4 <= 0) {
            n4 += 7;
        }
        if (n4 > 7) {
            n4 -= 7;
        }
        while (calendar3.get(7) != n3) {
            calendar3.add(5, -1);
        }
        while (calendar2.get(7) != n4) {
            calendar2.add(5, 1);
        }
        return new a(calendar3, calendar2);
    }

    public static Iterator<?> iterator(Object object, int n2) {
        if (object == null) {
            throw DateUtils.a();
        }
        if (object instanceof Date) {
            return DateUtils.iterator((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.iterator((Calendar)object, n2);
        }
        throw new ClassCastException("Could not iterate based on " + object);
    }

    public static long getFragmentInMilliseconds(Date date, int n2) {
        return DateUtils.a(date, n2, TimeUnit.MILLISECONDS);
    }

    public static long getFragmentInSeconds(Date date, int n2) {
        return DateUtils.a(date, n2, TimeUnit.SECONDS);
    }

    public static long getFragmentInMinutes(Date date, int n2) {
        return DateUtils.a(date, n2, TimeUnit.MINUTES);
    }

    public static long getFragmentInHours(Date date, int n2) {
        return DateUtils.a(date, n2, TimeUnit.HOURS);
    }

    public static long getFragmentInDays(Date date, int n2) {
        return DateUtils.a(date, n2, TimeUnit.DAYS);
    }

    public static long getFragmentInMilliseconds(Calendar calendar, int n2) {
        return DateUtils.a(calendar, n2, TimeUnit.MILLISECONDS);
    }

    public static long getFragmentInSeconds(Calendar calendar, int n2) {
        return DateUtils.a(calendar, n2, TimeUnit.SECONDS);
    }

    public static long getFragmentInMinutes(Calendar calendar, int n2) {
        return DateUtils.a(calendar, n2, TimeUnit.MINUTES);
    }

    public static long getFragmentInHours(Calendar calendar, int n2) {
        return DateUtils.a(calendar, n2, TimeUnit.HOURS);
    }

    public static long getFragmentInDays(Calendar calendar, int n2) {
        return DateUtils.a(calendar, n2, TimeUnit.DAYS);
    }

    private static long a(Date date, int n2, TimeUnit timeUnit) {
        DateUtils.a(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.a(calendar, n2, timeUnit);
    }

    private static long a(Calendar calendar, int n2, TimeUnit timeUnit) {
        if (calendar == null) {
            throw DateUtils.a();
        }
        long l2 = 0L;
        int n3 = timeUnit == TimeUnit.DAYS ? 0 : 1;
        switch (n2) {
            case 1: {
                l2 = 0L + timeUnit.convert(calendar.get(6) - n3, TimeUnit.DAYS);
                break;
            }
            case 2: {
                l2 = 0L + timeUnit.convert(calendar.get(5) - n3, TimeUnit.DAYS);
            }
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                l2 += timeUnit.convert(calendar.get(11), TimeUnit.HOURS);
            }
            case 11: {
                l2 += timeUnit.convert(calendar.get(12), TimeUnit.MINUTES);
            }
            case 12: {
                l2 += timeUnit.convert(calendar.get(13), TimeUnit.SECONDS);
            }
            case 13: {
                l2 += timeUnit.convert(calendar.get(14), TimeUnit.MILLISECONDS);
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The fragment " + n2 + " is not supported");
            }
        }
        return l2;
    }

    public static boolean truncatedEquals(Calendar calendar, Calendar calendar2, int n2) {
        return DateUtils.truncatedCompareTo(calendar, calendar2, n2) == 0;
    }

    public static boolean truncatedEquals(Date date, Date date2, int n2) {
        return DateUtils.truncatedCompareTo(date, date2, n2) == 0;
    }

    public static int truncatedCompareTo(Calendar calendar, Calendar calendar2, int n2) {
        calendar = DateUtils.truncate(calendar, n2);
        calendar2 = DateUtils.truncate(calendar2, n2);
        return calendar.compareTo(calendar2);
    }

    public static int truncatedCompareTo(Date date, Date date2, int n2) {
        date = DateUtils.truncate(date, n2);
        date2 = DateUtils.truncate(date2, n2);
        return date.compareTo(date2);
    }

    private static void a(Date date) {
        Validate.notNull(date, "date", new Object[0]);
    }

    static final class a
    implements Iterator<Calendar> {
        private final Calendar a;
        private final Calendar b;

        a(Calendar calendar, Calendar calendar2) {
            this.a = calendar2;
            this.b = calendar;
            this.b.add(5, -1);
        }

        @Override
        public final boolean hasNext() {
            return this.b.before(this.a);
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            a a2 = this;
            if (a2.b.equals(a2.a)) {
                throw new NoSuchElementException();
            }
            a2.b.add(5, 1);
            return (Calendar)a2.b.clone();
        }
    }

    private static final class b
    extends Enum<b> {
        public static final int a = 1;
        public static final int b = 2;
        public static final int c = 3;
        private static final /* synthetic */ int[] d;

        public static int[] values$740bc527() {
            return (int[])d.clone();
        }

        static {
            d = new int[]{a, b, c};
        }
    }
}

