/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class DurationFormatUtils {
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.SSS'S'";

    public static String formatDurationHMS(long l2) {
        return DurationFormatUtils.formatDuration(l2, "HH:mm:ss.SSS");
    }

    public static String formatDurationISO(long l2) {
        return DurationFormatUtils.formatDuration(l2, ISO_EXTENDED_FORMAT_PATTERN, false);
    }

    public static String formatDuration(long l2, String string) {
        return DurationFormatUtils.formatDuration(l2, string, true);
    }

    public static String formatDuration(long l2, String aArray, boolean bl2) {
        Validate.inclusiveBetween(0L, Long.MAX_VALUE, l2, "durationMillis must not be negative");
        aArray = DurationFormatUtils.a((String)aArray);
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = l2;
        if (a.a(aArray, "d")) {
            l3 = l2 / 86400000L;
            l7 = l2 - l3 * 86400000L;
        }
        if (a.a(aArray, "H")) {
            l4 = l7 / 3600000L;
            l7 -= l4 * 3600000L;
        }
        if (a.a(aArray, "m")) {
            l5 = l7 / 60000L;
            l7 -= l5 * 60000L;
        }
        if (a.a(aArray, "s")) {
            l6 = l7 / 1000L;
            l7 -= l6 * 1000L;
        }
        return DurationFormatUtils.a(aArray, 0L, 0L, l3, l4, l5, l6, l7, bl2);
    }

    public static String formatDurationWords(long l2, boolean bl2, boolean bl3) {
        String string;
        String string2 = DurationFormatUtils.formatDuration(l2, "d' days 'H' hours 'm' minutes 's' seconds'");
        if (bl2) {
            string = StringUtils.replaceOnce(string2 = " " + string2, " 0 days", "");
            if (string.length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 hours", "")).length() != string2.length()) {
                string2 = string;
                string2 = string = StringUtils.replaceOnce(string2, " 0 minutes", "");
                if (string.length() != string2.length()) {
                    string2 = StringUtils.replaceOnce(string, " 0 seconds", "");
                }
            }
            if (!string2.isEmpty()) {
                string2 = string2.substring(1);
            }
        }
        if (bl3 && (string = StringUtils.replaceOnce(string2, " 0 seconds", "")).length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 minutes", "")).length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 hours", "")).length() != string2.length()) {
            string2 = StringUtils.replaceOnce(string, " 0 days", "");
        }
        string2 = " " + string2;
        string2 = StringUtils.replaceOnce(string2, " 1 seconds", " 1 second");
        string2 = StringUtils.replaceOnce(string2, " 1 minutes", " 1 minute");
        string2 = StringUtils.replaceOnce(string2, " 1 hours", " 1 hour");
        string2 = StringUtils.replaceOnce(string2, " 1 days", " 1 day");
        return string2.trim();
    }

    public static String formatPeriodISO(long l2, long l3) {
        return DurationFormatUtils.formatPeriod(l2, l3, ISO_EXTENDED_FORMAT_PATTERN, false, TimeZone.getDefault());
    }

    public static String formatPeriod(long l2, long l3, String string) {
        return DurationFormatUtils.formatPeriod(l2, l3, string, true, TimeZone.getDefault());
    }

    public static String formatPeriod(long l2, long l3, String aArray, boolean bl2, TimeZone timeZone) {
        Validate.isTrue(l2 <= l3, "startMillis must not be greater than endMillis", new Object[0]);
        aArray = DurationFormatUtils.a((String)aArray);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(new Date(l2));
        Calendar calendar2 = Calendar.getInstance(timeZone);
        calendar2.setTime(new Date(l3));
        int n2 = calendar2.get(14) - calendar.get(14);
        int n3 = calendar2.get(13) - calendar.get(13);
        int n4 = calendar2.get(12) - calendar.get(12);
        int n5 = calendar2.get(11) - calendar.get(11);
        int n6 = calendar2.get(5) - calendar.get(5);
        int n7 = calendar2.get(2) - calendar.get(2);
        int n8 = calendar2.get(1) - calendar.get(1);
        while (n2 < 0) {
            n2 += 1000;
            --n3;
        }
        while (n3 < 0) {
            n3 += 60;
            --n4;
        }
        while (n4 < 0) {
            n4 += 60;
            --n5;
        }
        while (n5 < 0) {
            n5 += 24;
            --n6;
        }
        if (a.a(aArray, "M")) {
            while (n6 < 0) {
                n6 += calendar.getActualMaximum(5);
                --n7;
                calendar.add(2, 1);
            }
            while (n7 < 0) {
                n7 += 12;
                --n8;
            }
            if (!a.a(aArray, "y") && n8 != 0) {
                while (n8 != 0) {
                    n7 += n8 * 12;
                    n8 = 0;
                }
            }
        } else {
            if (!a.a(aArray, "y")) {
                n8 = calendar2.get(1);
                if (n7 < 0) {
                    --n8;
                }
                while (calendar.get(1) != n8) {
                    n6 += calendar.getActualMaximum(6) - calendar.get(6);
                    if (calendar instanceof GregorianCalendar && calendar.get(2) == 1 && calendar.get(5) == 29) {
                        ++n6;
                    }
                    calendar.add(1, 1);
                    n6 += calendar.get(6);
                }
                n8 = 0;
            }
            while (calendar.get(2) != calendar2.get(2)) {
                n6 += calendar.getActualMaximum(5);
                calendar.add(2, 1);
            }
            n7 = 0;
            while (n6 < 0) {
                n6 += calendar.getActualMaximum(5);
                --n7;
                calendar.add(2, 1);
            }
        }
        if (!a.a(aArray, "d")) {
            n5 += n6 * 24;
            n6 = 0;
        }
        if (!a.a(aArray, "H")) {
            n4 += n5 * 60;
            n5 = 0;
        }
        if (!a.a(aArray, "m")) {
            n3 += n4 * 60;
            n4 = 0;
        }
        if (!a.a(aArray, "s")) {
            n2 += n3 * 1000;
            n3 = 0;
        }
        return DurationFormatUtils.a(aArray, n8, n7, n6, n5, n4, n3, n2, bl2);
    }

    private static String a(a[] aArray, long l2, long l3, long l4, long l5, long l6, long l7, long l8, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (a a2 : aArray) {
            Object object = a2.c();
            int n3 = a2.b();
            if (object instanceof StringBuilder) {
                stringBuilder.append(object.toString());
                continue;
            }
            if (object.equals("y")) {
                stringBuilder.append(DurationFormatUtils.a(l2, bl2, n3));
            } else if (object.equals("M")) {
                stringBuilder.append(DurationFormatUtils.a(l3, bl2, n3));
            } else if (object.equals("d")) {
                stringBuilder.append(DurationFormatUtils.a(l4, bl2, n3));
            } else if (object.equals("H")) {
                stringBuilder.append(DurationFormatUtils.a(l5, bl2, n3));
            } else if (object.equals("m")) {
                stringBuilder.append(DurationFormatUtils.a(l6, bl2, n3));
            } else {
                if (object.equals("s")) {
                    stringBuilder.append(DurationFormatUtils.a(l7, bl2, n3));
                    n2 = 1;
                    continue;
                }
                if (!object.equals("S")) continue;
                if (n2 != 0) {
                    n2 = bl2 ? Math.max(3, n3) : 3;
                    stringBuilder.append(DurationFormatUtils.a(l8, true, n2));
                } else {
                    stringBuilder.append(DurationFormatUtils.a(l8, bl2, n3));
                }
            }
            n2 = 0;
        }
        return stringBuilder.toString();
    }

    private static String a(long l2, boolean bl2, int n2) {
        String string = Long.toString(l2);
        if (bl2) {
            return StringUtils.leftPad(string, n2, '0');
        }
        return string;
    }

    private static a[] a(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>(string.length());
        boolean bl2 = false;
        Object object = null;
        Object object2 = null;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (bl2 && c2 != '\'') {
                ((StringBuilder)object).append(c2);
                continue;
            }
            String string2 = null;
            switch (c2) {
                case '\'': {
                    if (bl2) {
                        object = null;
                        bl2 = false;
                        break;
                    }
                    object = new StringBuilder();
                    arrayList.add(new a(object));
                    bl2 = true;
                    break;
                }
                case 'y': {
                    string2 = "y";
                    break;
                }
                case 'M': {
                    string2 = "M";
                    break;
                }
                case 'd': {
                    string2 = "d";
                    break;
                }
                case 'H': {
                    string2 = "H";
                    break;
                }
                case 'm': {
                    string2 = "m";
                    break;
                }
                case 's': {
                    string2 = "s";
                    break;
                }
                case 'S': {
                    string2 = "S";
                    break;
                }
                default: {
                    if (object == null) {
                        object = new StringBuilder();
                        arrayList.add(new a(object));
                    }
                    ((StringBuilder)object).append(c2);
                }
            }
            if (string2 == null) continue;
            if (object2 != null && ((a)object2).c().equals(string2)) {
                ((a)object2).a();
            } else {
                object = new a(string2);
                arrayList.add(object);
                object2 = object;
            }
            object = null;
        }
        if (bl2) {
            throw new IllegalArgumentException("Unmatched quote in format: " + string);
        }
        return arrayList.toArray(a.a);
    }

    static final class a {
        private static final a[] a = new a[0];
        private final Object b;
        private int c;

        static boolean a(a[] aArray, Object object) {
            for (a a2 : aArray) {
                a a3 = a2;
                a3 = a2;
                if (a2.b != object) continue;
                return true;
            }
            return false;
        }

        a(Object object) {
            this.b = object;
            this.c = 1;
        }

        final void a() {
            ++this.c;
        }

        final int b() {
            return this.c;
        }

        final Object c() {
            return this.b;
        }

        public final boolean equals(Object object) {
            if (object instanceof a) {
                object = (a)object;
                if (this.b.getClass() != ((a)object).b.getClass()) {
                    return false;
                }
                if (this.c != ((a)object).c) {
                    return false;
                }
                if (this.b instanceof StringBuilder) {
                    return this.b.toString().equals(((a)object).b.toString());
                }
                if (this.b instanceof Number) {
                    return this.b.equals(((a)object).b);
                }
                return this.b == ((a)object).b;
            }
            return false;
        }

        public final int hashCode() {
            return this.b.hashCode();
        }

        public final String toString() {
            return StringUtils.repeat(this.b.toString(), this.c);
        }
    }
}

